/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Codec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;

public class DataType {
    private final Name name;
    private final List<DataType> typeArguments;
    private final String customClassName;
    private static final Map<Name, DataType> primitiveTypeMap = new EnumMap<Name, DataType>(Name.class);
    private static final Set<DataType> primitiveTypeSet;

    private DataType(Name name, List<DataType> typeArguments) {
        this(name, typeArguments, null);
    }

    private DataType(Name name, List<DataType> typeArguments, String customClassName) {
        this.name = name;
        this.typeArguments = typeArguments;
        this.customClassName = customClassName;
    }

    public static DataType ascii() {
        return primitiveTypeMap.get((Object)Name.ASCII);
    }

    public static DataType bigint() {
        return primitiveTypeMap.get((Object)Name.BIGINT);
    }

    public static DataType blob() {
        return primitiveTypeMap.get((Object)Name.BLOB);
    }

    public static DataType cboolean() {
        return primitiveTypeMap.get((Object)Name.BOOLEAN);
    }

    public static DataType counter() {
        return primitiveTypeMap.get((Object)Name.COUNTER);
    }

    public static DataType decimal() {
        return primitiveTypeMap.get((Object)Name.DECIMAL);
    }

    public static DataType cdouble() {
        return primitiveTypeMap.get((Object)Name.DOUBLE);
    }

    public static DataType cfloat() {
        return primitiveTypeMap.get((Object)Name.FLOAT);
    }

    public static DataType inet() {
        return primitiveTypeMap.get((Object)Name.INET);
    }

    public static DataType cint() {
        return primitiveTypeMap.get((Object)Name.INT);
    }

    public static DataType text() {
        return primitiveTypeMap.get((Object)Name.TEXT);
    }

    public static DataType timestamp() {
        return primitiveTypeMap.get((Object)Name.TIMESTAMP);
    }

    public static DataType uuid() {
        return primitiveTypeMap.get((Object)Name.UUID);
    }

    public static DataType varchar() {
        return primitiveTypeMap.get((Object)Name.VARCHAR);
    }

    public static DataType varint() {
        return primitiveTypeMap.get((Object)Name.VARINT);
    }

    public static DataType timeuuid() {
        return primitiveTypeMap.get((Object)Name.TIMEUUID);
    }

    public static DataType list(DataType elementType) {
        return new DataType(Name.LIST, (List<DataType>)ImmutableList.of((Object)elementType));
    }

    public static DataType set(DataType elementType) {
        return new DataType(Name.SET, (List<DataType>)ImmutableList.of((Object)elementType));
    }

    public static DataType map(DataType keyType, DataType valueType) {
        return new DataType(Name.MAP, (List<DataType>)ImmutableList.of((Object)keyType, (Object)valueType));
    }

    public static DataType custom(String typeClassName) {
        if (typeClassName == null) {
            throw new NullPointerException();
        }
        return new DataType(Name.CUSTOM, Collections.<DataType>emptyList(), typeClassName);
    }

    public Name getName() {
        return this.name;
    }

    public List<DataType> getTypeArguments() {
        return this.typeArguments;
    }

    public String getCustomTypeClassName() {
        return this.customClassName;
    }

    public ByteBuffer parse(String value) {
        if (this.name == Name.CUSTOM) {
            throw new InvalidTypeException(String.format("Cannot parse '%s' as value of custom type of class '%s' (values for custom type cannot be parse and must be inputed as bytes directly)", value, this.customClassName));
        }
        try {
            return Codec.getCodec(this).fromString(value);
        }
        catch (MarshalException e) {
            throw new InvalidTypeException(String.format("Cannot parse '%s' as a %s value (%s)", value, this, e.getMessage()));
        }
    }

    public boolean isCollection() {
        return this.name.isCollection();
    }

    public Class<?> asJavaClass() {
        return this.getName().asJavaClass();
    }

    public static Set<DataType> allPrimitiveTypes() {
        return primitiveTypeSet;
    }

    public ByteBuffer serialize(Object value) {
        Class<?> providedClass = value.getClass();
        Class<?> expectedClass = this.asJavaClass();
        if (!expectedClass.isAssignableFrom(providedClass)) {
            throw new InvalidTypeException(String.format("Invalid value for CQL type %s, expecting %s but %s provided", this.toString(), expectedClass, providedClass));
        }
        try {
            return Codec.getCodec(this).decompose(value);
        }
        catch (ClassCastException e) {
            throw new InvalidTypeException("Invalid type for collection element: " + e.getMessage());
        }
    }

    public Object deserialize(ByteBuffer bytes) {
        AbstractType codec = Codec.getCodec(this);
        try {
            codec.validate(bytes);
        }
        catch (MarshalException e) {
            throw new InvalidTypeException(String.format("Invalid serialized value for type %s (%s)", this.toString(), e.getMessage()));
        }
        try {
            return codec.compose(bytes);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.typeArguments, this.customClassName});
    }

    public final boolean equals(Object o) {
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType d = (DataType)o;
        return this.name == d.name && ((Object)this.typeArguments).equals(d.typeArguments) && Objects.equal((Object)this.customClassName, (Object)d.customClassName);
    }

    public String toString() {
        switch (this.name) {
            case LIST: 
            case SET: {
                return String.format("%s<%s>", new Object[]{this.name, this.typeArguments.get(0)});
            }
            case MAP: {
                return String.format("%s<%s, %s>", new Object[]{this.name, this.typeArguments.get(0), this.typeArguments.get(1)});
            }
            case CUSTOM: {
                return String.format("'%s'", this.customClassName);
            }
        }
        return this.name.toString();
    }

    static {
        for (Name name : Name.values()) {
            if (name.isCollection() || name == Name.CUSTOM) continue;
            primitiveTypeMap.put(name, new DataType(name, Collections.<DataType>emptyList()));
        }
        primitiveTypeSet = ImmutableSet.copyOf(primitiveTypeMap.values());
    }

    public static enum Name {
        ASCII(String.class),
        BIGINT(Long.class),
        BLOB(ByteBuffer.class),
        BOOLEAN(Boolean.class),
        COUNTER(Long.class),
        DECIMAL(BigDecimal.class),
        DOUBLE(Double.class),
        FLOAT(Float.class),
        INET(InetAddress.class),
        INT(Integer.class),
        TEXT(String.class),
        TIMESTAMP(Date.class),
        UUID(UUID.class),
        VARCHAR(String.class),
        VARINT(BigInteger.class),
        TIMEUUID(UUID.class),
        LIST(List.class),
        SET(Set.class),
        MAP(Map.class),
        CUSTOM(ByteBuffer.class);

        final Class<?> javaType;

        private Name(Class<?> javaType) {
            this.javaType = javaType;
        }

        public boolean isCollection() {
            switch (this) {
                case LIST: 
                case SET: 
                case MAP: {
                    return true;
                }
            }
            return false;
        }

        public Class<?> asJavaClass() {
            return this.javaType;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

