/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.cassandra.transport.messages;

import com.datastax.cassandra.transport.Message;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.transport.CBUtil;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class CredentialsMessage
extends Message.Request {
    public static final Message.Codec<CredentialsMessage> codec = new Message.Codec<CredentialsMessage>(){

        public CredentialsMessage decode(ChannelBuffer body) {
            CredentialsMessage msg = new CredentialsMessage();
            int count = body.readUnsignedShort();
            for (int i = 0; i < count; ++i) {
                String key = CBUtil.readString((ChannelBuffer)body);
                String value = CBUtil.readString((ChannelBuffer)body);
                msg.credentials.put(key, value);
            }
            return msg;
        }

        public ChannelBuffer encode(CredentialsMessage msg) {
            ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
            cb.writeShort(msg.credentials.size());
            for (Map.Entry<String, String> entry : msg.credentials.entrySet()) {
                cb.writeBytes(CBUtil.stringToCB((String)entry.getKey()));
                cb.writeBytes(CBUtil.stringToCB((String)entry.getValue()));
            }
            return cb;
        }
    };
    public final Map<String, String> credentials = new HashMap<String, String>();

    public CredentialsMessage() {
        super(Message.Type.CREDENTIALS);
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    public String toString() {
        return "CREDENTIALS " + this.credentials;
    }
}

