/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.cassandra.transport;

import com.datastax.cassandra.transport.Connection;
import com.datastax.cassandra.transport.Frame;
import com.datastax.cassandra.transport.messages.AuthChallenge;
import com.datastax.cassandra.transport.messages.AuthResponse;
import com.datastax.cassandra.transport.messages.AuthSuccess;
import com.datastax.cassandra.transport.messages.AuthenticateMessage;
import com.datastax.cassandra.transport.messages.CredentialsMessage;
import com.datastax.cassandra.transport.messages.ErrorMessage;
import com.datastax.cassandra.transport.messages.EventMessage;
import com.datastax.cassandra.transport.messages.ExecuteMessage;
import com.datastax.cassandra.transport.messages.OptionsMessage;
import com.datastax.cassandra.transport.messages.PrepareMessage;
import com.datastax.cassandra.transport.messages.QueryMessage;
import com.datastax.cassandra.transport.messages.ReadyMessage;
import com.datastax.cassandra.transport.messages.RegisterMessage;
import com.datastax.cassandra.transport.messages.ResultMessage;
import com.datastax.cassandra.transport.messages.StartupMessage;
import com.datastax.cassandra.transport.messages.SupportedMessage;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.CBCodec;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.ProtocolException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneDecoder;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    protected static final Logger logger = LoggerFactory.getLogger(Message.class);
    public final Type type;
    protected volatile Connection connection;
    private volatile int streamId;

    protected Message(Type type) {
        this.type = type;
    }

    public void attach(Connection connection) {
        this.connection = connection;
    }

    public Connection connection() {
        return this.connection;
    }

    public Message setStreamId(int streamId) {
        this.streamId = streamId;
        return this;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public abstract ChannelBuffer encode();

    public static class ProtocolEncoder
    extends OneToOneEncoder {
        public Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) {
            assert (msg instanceof Message) : "Expecting message, got " + msg;
            Message message = (Message)msg;
            ChannelBuffer body = message.encode();
            EnumSet<Frame.Header.Flag> flags = EnumSet.noneOf(Frame.Header.Flag.class);
            if (message instanceof Response) {
                UUID tracingId = ((Response)message).getTracingId();
                if (tracingId != null) {
                    body = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.uuidToCB((UUID)tracingId), body});
                    flags.add(Frame.Header.Flag.TRACING);
                }
            } else {
                assert (message instanceof Request);
                if (((Request)message).isTracingRequested()) {
                    flags.add(Frame.Header.Flag.TRACING);
                }
            }
            return Frame.create(message.type, message.getStreamId(), flags, body, message.connection());
        }
    }

    public static class ProtocolDecoder
    extends OneToOneDecoder {
        public Object decode(ChannelHandlerContext ctx, Channel channel, Object msg) {
            assert (msg instanceof Frame) : "Expecting frame, got " + msg;
            Frame frame = (Frame)msg;
            boolean isRequest = frame.header.type.direction == Direction.REQUEST;
            boolean isTracing = frame.header.flags.contains((Object)Frame.Header.Flag.TRACING);
            UUID tracingId = isRequest || !isTracing ? null : CBUtil.readUuid((ChannelBuffer)frame.body);
            try {
                Message message = (Message)frame.header.type.codec.decode(frame.body);
                message.setStreamId(frame.header.streamId);
                if (isRequest) {
                    assert (message instanceof Request);
                    Request req = (Request)message;
                    req.attach(frame.connection);
                    if (isTracing) {
                        req.setTracingRequested();
                    }
                } else {
                    assert (message instanceof Response);
                    if (isTracing) {
                        ((Response)message).setTracingId(tracingId);
                    }
                }
                return message;
            }
            catch (Exception ex) {
                throw ErrorMessage.wrap(ex, frame.header.streamId);
            }
        }
    }

    public static abstract class Response
    extends Message {
        protected UUID tracingId;

        protected Response(Type type) {
            super(type);
            if (type.direction != Direction.RESPONSE) {
                throw new IllegalArgumentException();
            }
        }

        public Message setTracingId(UUID tracingId) {
            this.tracingId = tracingId;
            return this;
        }

        public UUID getTracingId() {
            return this.tracingId;
        }
    }

    public static abstract class Request
    extends Message {
        protected boolean tracingRequested;

        protected Request(Type type) {
            super(type);
            if (type.direction != Direction.REQUEST) {
                throw new IllegalArgumentException();
            }
        }

        public Response execute(QueryState queryState) {
            throw new UnsupportedOperationException("This message should not be executed by the client");
        }

        public void setTracingRequested() {
            this.tracingRequested = true;
        }

        public boolean isTracingRequested() {
            return this.tracingRequested;
        }
    }

    public static enum Type {
        ERROR(0, Direction.RESPONSE, ErrorMessage.codec),
        STARTUP(1, Direction.REQUEST, StartupMessage.codec),
        READY(2, Direction.RESPONSE, ReadyMessage.codec),
        AUTHENTICATE(3, Direction.RESPONSE, AuthenticateMessage.codec),
        CREDENTIALS(4, Direction.REQUEST, CredentialsMessage.codec),
        OPTIONS(5, Direction.REQUEST, OptionsMessage.codec),
        SUPPORTED(6, Direction.RESPONSE, SupportedMessage.codec),
        QUERY(7, Direction.REQUEST, QueryMessage.codec),
        RESULT(8, Direction.RESPONSE, ResultMessage.codec),
        PREPARE(9, Direction.REQUEST, PrepareMessage.codec),
        EXECUTE(10, Direction.REQUEST, ExecuteMessage.codec),
        REGISTER(11, Direction.REQUEST, RegisterMessage.codec),
        EVENT(12, Direction.RESPONSE, EventMessage.codec),
        AUTH_CHALLENGE(14, Direction.RESPONSE, AuthChallenge.codec),
        AUTH_RESPONSE(15, Direction.REQUEST, AuthResponse.codec),
        AUTH_SUCCESS(16, Direction.RESPONSE, AuthSuccess.codec);

        public final int opcode;
        public final Direction direction;
        public final Codec<?> codec;
        private static final Type[] opcodeIdx;

        private Type(int opcode, Direction direction, Codec<?> codec) {
            this.opcode = opcode;
            this.direction = direction;
            this.codec = codec;
        }

        public static Type fromOpcode(int opcode, Direction direction) {
            Type t = opcodeIdx[opcode];
            if (t == null) {
                throw new ProtocolException(String.format("Unknown opcode %d", opcode));
            }
            if (t.direction != direction) {
                throw new ProtocolException(String.format("Wrong protocol direction (expected %s, got %s) for opcode %d (%s)", new Object[]{t.direction, direction, opcode, t}));
            }
            return t;
        }

        static {
            int maxOpcode = -1;
            for (Type type : Type.values()) {
                maxOpcode = Math.max(maxOpcode, type.opcode);
            }
            opcodeIdx = new Type[maxOpcode + 1];
            for (Type type : Type.values()) {
                if (opcodeIdx[type.opcode] != null) {
                    throw new IllegalStateException("Duplicate opcode");
                }
                Type.opcodeIdx[type.opcode] = type;
            }
        }
    }

    public static enum Direction {
        REQUEST,
        RESPONSE;


        public static Direction extractFromVersion(int versionWithDirection) {
            return (versionWithDirection & 0x80) == 0 ? REQUEST : RESPONSE;
        }

        public int addToVersion(int rawVersion) {
            return this == REQUEST ? rawVersion & 0x7F : rawVersion | 0x80;
        }
    }

    public static interface Codec<M extends Message>
    extends CBCodec<M> {
    }
}

