/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import java.net.InetAddress;
import java.nio.charset.Charset;

public class PlainTextAuthProvider
implements AuthProvider {
    private final String username;
    private final String password;

    public PlainTextAuthProvider(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public Authenticator newAuthenticator(InetAddress host) {
        return new PlainTextAuthenticator(this.username, this.password);
    }

    private static class PlainTextAuthenticator
    implements Authenticator {
        private final byte[] username;
        private final byte[] password;

        public PlainTextAuthenticator(String username, String password) {
            this.username = username.getBytes(Charset.forName("UTF-8"));
            this.password = password.getBytes(Charset.forName("UTF-8"));
        }

        @Override
        public byte[] initialResponse() {
            byte[] initialToken = new byte[this.username.length + this.password.length + 2];
            initialToken[0] = 0;
            System.arraycopy(this.username, 0, initialToken, 1, this.username.length);
            initialToken[this.username.length + 1] = 0;
            System.arraycopy(this.password, 0, initialToken, this.username.length + 2, this.password.length);
            return initialToken;
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) {
            return null;
        }
    }
}

