/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConvictionPolicy;
import com.datastax.driver.core.ExecutionInfo;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;

public class Host {
    private final InetAddress address;
    private final HealthMonitor monitor;
    private volatile String datacenter;
    private volatile String rack;
    private volatile boolean isUp;
    private final ConvictionPolicy policy;
    final AtomicReference<ScheduledFuture<?>> reconnectionAttempt = new AtomicReference();
    final ExecutionInfo defaultExecutionInfo;

    Host(InetAddress address, ConvictionPolicy.Factory policy) {
        if (address == null || policy == null) {
            throw new NullPointerException();
        }
        this.address = address;
        this.policy = policy.create(this);
        this.monitor = new HealthMonitor();
        this.defaultExecutionInfo = new ExecutionInfo((List<Host>)ImmutableList.of((Object)this));
    }

    void setLocationInfo(String datacenter, String rack) {
        this.datacenter = datacenter;
        this.rack = rack;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getRack() {
        return this.rack;
    }

    public boolean isUp() {
        return this.isUp;
    }

    @Deprecated
    public HealthMonitor getMonitor() {
        return this.monitor;
    }

    public final int hashCode() {
        return this.address.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Host)) {
            return false;
        }
        return this.address.equals(((Host)o).address);
    }

    public String toString() {
        return this.address.toString();
    }

    void setDown() {
        this.isUp = false;
    }

    void setUp() {
        this.policy.reset();
        this.isUp = true;
        for (StateListener listener : this.monitor.listeners) {
            listener.onUp(this);
        }
    }

    boolean signalConnectionFailure(ConnectionException exception) {
        boolean isDown = this.policy.addFailure(exception);
        if (isDown) {
            for (StateListener listener : this.monitor.listeners) {
                listener.onDown(this);
            }
        }
        return isDown;
    }

    public static interface StateListener {
        public void onAdd(Host var1);

        public void onUp(Host var1);

        public void onDown(Host var1);

        public void onRemove(Host var1);
    }

    @Deprecated
    public class HealthMonitor {
        private Set<StateListener> listeners = new CopyOnWriteArraySet<StateListener>();

        HealthMonitor() {
        }

        @Deprecated
        public void register(StateListener listener) {
            this.listeners.add(listener);
        }

        @Deprecated
        public void unregister(StateListener listener) {
            this.listeners.remove(listener);
        }

        @Deprecated
        public boolean isUp() {
            return Host.this.isUp;
        }
    }
}

