/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.ShutdownFuture;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    final Manager manager;

    Session(Cluster cluster, Collection<Host> hosts) {
        this.manager = new Manager(cluster, hosts);
    }

    public ResultSet execute(String query) {
        return this.execute(new SimpleStatement(query));
    }

    public ResultSet execute(String query, Object ... values) {
        return this.execute(new SimpleStatement(query, values));
    }

    public ResultSet execute(Statement statement) {
        return this.executeAsync(statement).getUninterruptibly();
    }

    public ResultSetFuture executeAsync(String query) {
        return this.executeAsync(new SimpleStatement(query));
    }

    public ResultSetFuture executeAsync(String query, Object ... values) {
        return this.executeAsync(new SimpleStatement(query, values));
    }

    public ResultSetFuture executeAsync(Statement statement) {
        return this.manager.executeQuery(this.manager.makeRequestMessage(statement, null), statement);
    }

    public PreparedStatement prepare(String query) {
        Connection.Future future = new Connection.Future(new Requests.Prepare(query));
        this.manager.execute(future, Statement.DEFAULT);
        return this.toPreparedStatement(query, future);
    }

    public PreparedStatement prepare(RegularStatement statement) {
        if (statement.getValues() != null) {
            throw new IllegalArgumentException("A statement to prepare should not have values");
        }
        PreparedStatement prepared = this.prepare(statement.toString());
        ByteBuffer routingKey = statement.getRoutingKey();
        if (routingKey != null) {
            prepared.setRoutingKey(routingKey);
        }
        prepared.setConsistencyLevel(statement.getConsistencyLevel());
        if (statement.isTracing()) {
            prepared.enableTracing();
        }
        prepared.setRetryPolicy(statement.getRetryPolicy());
        return prepared;
    }

    public ShutdownFuture shutdown() {
        return this.manager.shutdown();
    }

    public Cluster getCluster() {
        return this.manager.cluster;
    }

    private PreparedStatement toPreparedStatement(String query, Connection.Future future) {
        try {
            Message.Response response = (Message.Response)Uninterruptibles.getUninterruptibly((Future)((Object)future));
            switch (response.type) {
                case RESULT: {
                    Responses.Result rm = (Responses.Result)response;
                    switch (rm.kind) {
                        case PREPARED: {
                            Responses.Result.Prepared pmsg = (Responses.Result.Prepared)rm;
                            PreparedStatement stmt = PreparedStatement.fromMessage(pmsg, this.manager.cluster.getMetadata(), query, this.manager.poolsState.keyspace);
                            try {
                                this.manager.cluster.manager.prepare(pmsg.statementId, stmt, future.getAddress());
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            return stmt;
                        }
                    }
                    throw new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{rm.kind}));
                }
                case ERROR: {
                    throw ((Responses.Error)response).asException(future.getAddress());
                }
            }
            throw new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{response.type}));
        }
        catch (ExecutionException e) {
            throw ResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    static class Manager {
        final Cluster cluster;
        final ConcurrentMap<Host, HostConnectionPool> pools;
        final HostConnectionPool.PoolState poolsState;
        final AtomicReference<ShutdownFuture> shutdownFuture = new AtomicReference();

        public Manager(Cluster cluster, Collection<Host> hosts) {
            this.cluster = cluster;
            this.pools = new ConcurrentHashMap<Host, HostConnectionPool>(hosts.size());
            this.poolsState = new HostConnectionPool.PoolState();
            for (Host host : hosts) {
                try {
                    this.addOrRenewPool(host, false).get();
                }
                catch (ExecutionException e) {
                    throw new DriverInternalError(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public Connection.Factory connectionFactory() {
            return this.cluster.manager.connectionFactory;
        }

        public Configuration configuration() {
            return this.cluster.manager.configuration;
        }

        LoadBalancingPolicy loadBalancingPolicy() {
            return this.cluster.manager.loadBalancingPolicy();
        }

        ReconnectionPolicy reconnectionPolicy() {
            return this.cluster.manager.reconnectionPolicy();
        }

        public ListeningExecutorService executor() {
            return this.cluster.manager.executor;
        }

        public ListeningExecutorService blockingExecutor() {
            return this.cluster.manager.blockingTasksExecutor;
        }

        boolean isShutdown() {
            return this.shutdownFuture.get() != null;
        }

        private ShutdownFuture shutdown() {
            ShutdownFuture future = this.shutdownFuture.get();
            if (future != null) {
                return future;
            }
            ArrayList<ShutdownFuture> futures = new ArrayList<ShutdownFuture>(this.pools.size());
            for (HostConnectionPool pool : this.pools.values()) {
                futures.add(pool.shutdown());
            }
            future = new ShutdownFuture.Forwarding(futures);
            return this.shutdownFuture.compareAndSet(null, future) ? future : this.shutdownFuture.get();
        }

        ListenableFuture<Boolean> addOrRenewPool(final Host host, final boolean isHostAddition) {
            final HostDistance distance = this.cluster.manager.loadBalancingPolicy().distance(host);
            if (distance == HostDistance.IGNORED) {
                return Futures.immediateFuture((Object)true);
            }
            return this.executor().submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    logger.debug("Adding {} to list of queried hosts", (Object)host);
                    try {
                        HostConnectionPool previous = Manager.this.pools.put(host, new HostConnectionPool(host, distance, Manager.this));
                        if (previous != null) {
                            previous.shutdown();
                        }
                        return true;
                    }
                    catch (AuthenticationException e) {
                        logger.error("Error creating pool to {} ({})", (Object)host, (Object)e.getMessage());
                        Manager.this.cluster.manager.signalConnectionFailure(host, new ConnectionException(e.getHost(), e.getMessage()), isHostAddition);
                        return false;
                    }
                    catch (ConnectionException e) {
                        logger.debug("Error creating pool to {} ({})", (Object)host, (Object)e.getMessage());
                        Manager.this.cluster.manager.signalConnectionFailure(host, e, isHostAddition);
                        return false;
                    }
                }
            });
        }

        ListenableFuture<?> removePool(Host host) {
            final HostConnectionPool pool = (HostConnectionPool)this.pools.remove(host);
            if (pool == null) {
                return Futures.immediateFuture(null);
            }
            return this.executor().submit(new Runnable(){

                @Override
                public void run() {
                    pool.shutdown();
                }
            });
        }

        void updateCreatedPools() {
            for (Host h : this.cluster.getMetadata().allHosts()) {
                HostDistance dist = this.loadBalancingPolicy().distance(h);
                HostConnectionPool pool = (HostConnectionPool)this.pools.get(h);
                if (pool == null) {
                    if (dist == HostDistance.IGNORED || !h.isUp()) continue;
                    this.addOrRenewPool(h, false);
                    continue;
                }
                if (dist == pool.hostDistance) continue;
                if (dist == HostDistance.IGNORED) {
                    this.removePool(h);
                    continue;
                }
                pool.hostDistance = dist;
            }
        }

        public void onDown(Host host) {
            this.removePool(host).addListener(new Runnable(){

                @Override
                public void run() {
                    Manager.this.updateCreatedPools();
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
        }

        public void onRemove(Host host) {
            this.onDown(host);
        }

        public void setKeyspace(String keyspace) {
            long timeout = this.configuration().getSocketOptions().getConnectTimeoutMillis();
            try {
                ResultSetFuture future = this.executeQuery(new Requests.Query("use " + keyspace), Statement.DEFAULT);
                Uninterruptibles.getUninterruptibly((Future)((Object)future), (long)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new DriverInternalError(String.format("No responses after %d milliseconds while setting current keyspace. This should not happen, unless you have setup a very low connection timeout.", timeout));
            }
            catch (ExecutionException e) {
                throw ResultSetFuture.extractCauseFromExecutionException(e);
            }
        }

        public Message.Request makeRequestMessage(Statement statement, ByteBuffer pagingState) {
            ConsistencyLevel serialConsistency;
            ConsistencyLevel consistency = statement.getConsistencyLevel();
            if (consistency == null) {
                consistency = this.configuration().getQueryOptions().getConsistencyLevel();
            }
            if ((serialConsistency = statement.getSerialConsistencyLevel()) == null) {
                serialConsistency = this.configuration().getQueryOptions().getSerialConsistencyLevel();
            }
            return this.makeRequestMessage(statement, consistency, serialConsistency, pagingState);
        }

        public Message.Request makeRequestMessage(Statement statement, ConsistencyLevel cl, ConsistencyLevel scl, ByteBuffer pagingState) {
            int fetchSize = statement.getFetchSize();
            if (fetchSize <= 0) {
                fetchSize = this.configuration().getQueryOptions().getFetchSize();
            }
            if (fetchSize == Integer.MAX_VALUE) {
                fetchSize = -1;
            }
            if (statement instanceof RegularStatement) {
                RegularStatement rs = (RegularStatement)statement;
                ByteBuffer[] rawValues = rs.getValues();
                List<ByteBuffer> values = rawValues == null ? Collections.emptyList() : Arrays.asList(rawValues);
                String qString = rs.getQueryString();
                Requests.QueryProtocolOptions options = new Requests.QueryProtocolOptions(cl, values, false, fetchSize, pagingState, scl);
                return new Requests.Query(qString, options);
            }
            if (statement instanceof BoundStatement) {
                BoundStatement bs = (BoundStatement)statement;
                boolean skipMetadata = bs.statement.resultSetMetadata != null;
                Requests.QueryProtocolOptions options = new Requests.QueryProtocolOptions(cl, Arrays.asList(bs.values), skipMetadata, fetchSize, pagingState, scl);
                return new Requests.Execute(bs.statement.id, options);
            }
            assert (statement instanceof BatchStatement) : statement;
            assert (pagingState == null);
            BatchStatement bs = (BatchStatement)statement;
            BatchStatement.IdAndValues idAndVals = bs.getIdAndValues();
            return new Requests.Batch(bs.batchType, idAndVals.ids, idAndVals.values, cl);
        }

        public void execute(RequestHandler.Callback callback, Statement statement) {
            new RequestHandler(this, callback, statement).sendRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void prepare(String query, InetAddress toExclude) throws InterruptedException {
            Iterator i$ = this.pools.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entry = i$.next();
                if (((Host)entry.getKey()).getAddress().equals(toExclude)) continue;
                Connection c = null;
                try {
                    c = ((HostConnectionPool)entry.getValue()).borrowConnection(200L, TimeUnit.MILLISECONDS);
                    c.write(new Requests.Prepare(query)).get();
                    continue;
                }
                catch (ConnectionException e) {
                    continue;
                }
                catch (BusyConnectionException e) {
                    continue;
                }
                catch (TimeoutException e) {
                    continue;
                }
                catch (ExecutionException e) {
                    logger.error(String.format("Unexpected error while preparing query (%s) on %s", query, entry.getKey()), (Throwable)e);
                    continue;
                }
                finally {
                    if (c == null) continue;
                    ((HostConnectionPool)entry.getValue()).returnConnection(c);
                    continue;
                }
                break;
            }
            return;
        }

        public ResultSetFuture executeQuery(Message.Request msg, Statement statement) {
            if (statement.isTracing()) {
                msg.setTracingRequested();
            }
            ResultSetFuture future = new ResultSetFuture(this, msg);
            this.execute(future.callback, statement);
            return future;
        }
    }
}

