/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.google.common.base.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber> {
    private static final String VERSION_REGEXP = "(\\d+)\\.(\\d+)(\\.\\d+)?(\\-[.\\w]+)?";
    private static final Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?(\\-[.\\w]+)?");
    private final int major;
    private final int minor;
    private final int patch;
    private final String preRelease;

    private VersionNumber(int major, int minor, int patch, String preRelease) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
    }

    public static VersionNumber parse(String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version number: " + version);
        }
        try {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            String pa = matcher.group(3);
            int patch = pa == null || pa.isEmpty() ? 0 : Integer.parseInt(pa.substring(1));
            String pr = matcher.group(4);
            String preRelease = pr == null || pr.isEmpty() ? null : pr.substring(1);
            return new VersionNumber(major, minor, patch, preRelease);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version number: " + version);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getPreReleaseLabel() {
        return this.preRelease;
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.preRelease == null) {
            return other.preRelease == null ? 0 : 1;
        }
        return this.preRelease.compareTo(other.preRelease);
    }

    public boolean equals(Object o) {
        if (!(o instanceof VersionNumber)) {
            return false;
        }
        VersionNumber that = (VersionNumber)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && Objects.equal((Object)this.preRelease, (Object)that.preRelease);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.major, this.minor, this.patch, this.preRelease});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.preRelease != null) {
            sb.append('-').append(this.preRelease);
        }
        return sb.toString();
    }
}

