/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ArrayBackedRow;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrayBackedResultSet
implements ResultSet {
    private static final Logger logger = LoggerFactory.getLogger(ResultSet.class);
    private static final Queue<List<ByteBuffer>> EMPTY_QUEUE = new ArrayDeque<List<ByteBuffer>>(0);
    private final ColumnDefinitions metadata;
    private final Queue<List<ByteBuffer>> rows;
    private final List<ExecutionInfo> infos;
    private volatile FetchingState fetchState;
    private final SessionManager session;
    private final Statement statement;

    private ArrayBackedResultSet(ColumnDefinitions metadata, Queue<List<ByteBuffer>> rows, ExecutionInfo info, ByteBuffer initialPagingState, SessionManager session, Statement statement) {
        this.metadata = metadata;
        this.rows = rows;
        this.session = session;
        if (initialPagingState == null) {
            this.fetchState = null;
            this.infos = Collections.singletonList(info);
        } else {
            this.fetchState = new FetchingState(initialPagingState, null);
            this.infos = new ArrayList<ExecutionInfo>();
            this.infos.add(info);
        }
        this.statement = statement;
        assert (this.fetchState == null || session != null && statement != null);
    }

    static ArrayBackedResultSet fromMessage(Responses.Result msg, SessionManager session, ExecutionInfo info, Statement statement) {
        UUID tracingId = msg.getTracingId();
        info = tracingId == null || info == null ? info : info.withTrace(new QueryTrace(tracingId, session));
        switch (msg.kind) {
            case VOID: {
                return ArrayBackedResultSet.empty(info);
            }
            case ROWS: {
                ColumnDefinitions columnDefs;
                Responses.Result.Rows r = (Responses.Result.Rows)msg;
                if (r.metadata.columns == null) {
                    assert (statement instanceof BoundStatement);
                    columnDefs = ((BoundStatement)statement).statement.getPreparedId().resultSetMetadata;
                    assert (columnDefs != null);
                } else {
                    columnDefs = r.metadata.columns;
                }
                return new ArrayBackedResultSet(columnDefs, r.data, info, r.metadata.pagingState, session, statement);
            }
            case SET_KEYSPACE: 
            case SCHEMA_CHANGE: {
                return ArrayBackedResultSet.empty(info);
            }
            case PREPARED: {
                throw new RuntimeException("Prepared statement received when a ResultSet was expected");
            }
        }
        logger.error("Received unknown result type '{}'; returning empty result set", (Object)msg.kind);
        return ArrayBackedResultSet.empty(info);
    }

    private static ArrayBackedResultSet empty(ExecutionInfo info) {
        return new ArrayBackedResultSet(ColumnDefinitions.EMPTY, EMPTY_QUEUE, info, null, null, null);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    public boolean isExhausted() {
        if (!this.rows.isEmpty()) {
            return false;
        }
        this.fetchMoreResultsBlocking();
        assert (!this.rows.isEmpty() || this.isFullyFetched());
        return this.rows.isEmpty();
    }

    @Override
    public Row one() {
        List<ByteBuffer> nextRow = this.rows.poll();
        if (nextRow != null) {
            return ArrayBackedRow.fromData(this.metadata, nextRow);
        }
        this.fetchMoreResultsBlocking();
        return ArrayBackedRow.fromData(this.metadata, this.rows.poll());
    }

    @Override
    public List<Row> all() {
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        ArrayList<Row> result = new ArrayList<Row>(this.rows.size());
        for (Row row : this) {
            result.add(row);
        }
        return result;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return !ArrayBackedResultSet.this.isExhausted();
            }

            @Override
            public Row next() {
                return ArrayBackedResultSet.this.one();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int getAvailableWithoutFetching() {
        return this.rows.size();
    }

    @Override
    public boolean isFullyFetched() {
        return this.fetchState == null;
    }

    private void fetchMoreResultsBlocking() {
        try {
            Uninterruptibles.getUninterruptibly(this.fetchMoreResults());
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    @Override
    public ListenableFuture<Void> fetchMoreResults() {
        if (this.isFullyFetched()) {
            return Futures.immediateFuture(null);
        }
        if (this.fetchState.inProgress != null) {
            return this.fetchState.inProgress;
        }
        assert (this.fetchState.nextStart != null);
        ByteBuffer state = this.fetchState.nextStart;
        SettableFuture future = SettableFuture.create();
        this.fetchState = new FetchingState(null, (ListenableFuture<Void>)future);
        return this.queryNextPage(state, (SettableFuture<Void>)future);
    }

    private ListenableFuture<Void> queryNextPage(ByteBuffer nextStart, final SettableFuture<Void> future) {
        assert (!(this.statement instanceof BatchStatement));
        final Message.Request request = this.session.makeRequestMessage(this.statement, nextStart);
        this.session.execute(new RequestHandler.Callback(){

            @Override
            public Message.Request request() {
                return request;
            }

            @Override
            public void register(RequestHandler handler) {
            }

            @Override
            public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
                try {
                    switch (response.type) {
                        case RESULT: {
                            Responses.Result rm = (Responses.Result)response;
                            ArrayBackedResultSet tmp = ArrayBackedResultSet.fromMessage(rm, ArrayBackedResultSet.this.session, info, statement);
                            ArrayBackedResultSet.this.rows.addAll(tmp.rows);
                            ArrayBackedResultSet.this.fetchState = tmp.fetchState;
                            ArrayBackedResultSet.this.infos.addAll(tmp.infos);
                            future.set(null);
                            break;
                        }
                        case ERROR: {
                            future.setException((Throwable)((Responses.Error)response).asException(connection.address));
                            break;
                        }
                        default: {
                            connection.defunct(new ConnectionException(connection.address, String.format("Got unexpected %s response", new Object[]{response.type})));
                            future.setException((Throwable)new DriverInternalError(String.format("Got unexpected %s response from %s", new Object[]{response.type, connection.address})));
                            break;
                        }
                    }
                }
                catch (RuntimeException e) {
                    future.setException((Throwable)new DriverInternalError("Unexpected error while processing response from " + connection.address, e));
                }
            }

            @Override
            public void onSet(Connection connection, Message.Response response, long latency) {
                this.onSet(connection, response, null, null, latency);
            }

            @Override
            public void onException(Connection connection, Exception exception, long latency) {
                future.setException((Throwable)exception);
            }

            @Override
            public void onTimeout(Connection connection, long latency) {
                throw new UnsupportedOperationException();
            }
        }, this.statement);
        return future;
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.infos.get(this.infos.size() - 1);
    }

    @Override
    public List<ExecutionInfo> getAllExecutionInfo() {
        return new ArrayList<ExecutionInfo>(this.infos);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResultSet[ exhausted: ").append(this.isExhausted());
        sb.append(", ").append(this.metadata).append(']');
        return sb.toString();
    }

    private static class FetchingState {
        public final ByteBuffer nextStart;
        public final ListenableFuture<Void> inProgress;

        FetchingState(ByteBuffer nextStart, ListenableFuture<Void> inProgress) {
            assert (nextStart == null != (inProgress == null));
            this.nextStart = nextStart;
            this.inProgress = inProgress;
        }
    }
}

