/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CassandraTypeParser;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleJSONParser;
import com.datastax.driver.core.VersionNumber;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetadata {
    private static final Logger logger = LoggerFactory.getLogger(TableMetadata.class);
    static final String CF_NAME = "columnfamily_name";
    private static final String KEY_VALIDATOR = "key_validator";
    private static final String COMPARATOR = "comparator";
    private static final String VALIDATOR = "default_validator";
    private static final String KEY_ALIASES = "key_aliases";
    private static final String COLUMN_ALIASES = "column_aliases";
    private static final String VALUE_ALIAS = "value_alias";
    private static final String DEFAULT_KEY_ALIAS = "key";
    private static final String DEFAULT_COLUMN_ALIAS = "column";
    private static final String DEFAULT_VALUE_ALIAS = "value";
    private static final Comparator<ColumnMetadata> columnMetadataComparator = new Comparator<ColumnMetadata>(){

        @Override
        public int compare(ColumnMetadata c1, ColumnMetadata c2) {
            return c1.getName().compareTo(c2.getName());
        }
    };
    private final KeyspaceMetadata keyspace;
    private final String name;
    private final List<ColumnMetadata> partitionKey;
    private final List<ColumnMetadata> clusteringColumns;
    private final Map<String, ColumnMetadata> columns;
    private final Options options;
    private final List<Order> clusteringOrder;
    private final VersionNumber cassandraVersion;

    private TableMetadata(KeyspaceMetadata keyspace, String name, List<ColumnMetadata> partitionKey, List<ColumnMetadata> clusteringColumns, LinkedHashMap<String, ColumnMetadata> columns, Options options, List<Order> clusteringOrder, VersionNumber cassandraVersion) {
        this.keyspace = keyspace;
        this.name = name;
        this.partitionKey = partitionKey;
        this.clusteringColumns = clusteringColumns;
        this.columns = columns;
        this.options = options;
        this.clusteringOrder = clusteringOrder;
        this.cassandraVersion = cassandraVersion;
    }

    static TableMetadata build(KeyspaceMetadata ksm, Row row, Map<String, ColumnMetadata.Raw> rawCols, VersionNumber cassandraVersion) {
        String name = row.getString(CF_NAME);
        CassandraTypeParser.ParseResult keyValidator = CassandraTypeParser.parseWithComposite(row.getString(KEY_VALIDATOR));
        CassandraTypeParser.ParseResult comparator = CassandraTypeParser.parseWithComposite(row.getString(COMPARATOR));
        List<String> columnAliases = cassandraVersion.getMajor() >= 2 || row.getString(COLUMN_ALIASES) == null ? Collections.emptyList() : SimpleJSONParser.parseStringList(row.getString(COLUMN_ALIASES));
        int clusteringSize = TableMetadata.findClusteringSize(comparator, rawCols.values(), columnAliases, cassandraVersion);
        boolean isDense = clusteringSize != comparator.types.size() - 1;
        boolean isCompact = isDense || !comparator.isComposite;
        List<ColumnMetadata> partitionKey = TableMetadata.nullInitializedList(keyValidator.types.size());
        List<ColumnMetadata> clusteringColumns = TableMetadata.nullInitializedList(clusteringSize);
        List<Order> clusteringOrder = TableMetadata.nullInitializedList(clusteringSize);
        LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
        Options options = null;
        try {
            options = new Options(row, isCompact, cassandraVersion);
        }
        catch (RuntimeException e) {
            logger.error(String.format("Error parsing schema options for table %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getTable(\"%s\").getOptions() will return null", ksm.getName(), name, ksm.getName(), name), (Throwable)e);
        }
        TableMetadata tm = new TableMetadata(ksm, name, partitionKey, clusteringColumns, columns, options, clusteringOrder, cassandraVersion);
        TreeSet<ColumnMetadata> otherColumns = new TreeSet<ColumnMetadata>(columnMetadataComparator);
        if (cassandraVersion.getMajor() < 2) {
            String alias;
            int i;
            List keyAliases = row.getString(KEY_ALIASES) == null ? Collections.emptyList() : SimpleJSONParser.parseStringList(row.getString(KEY_ALIASES));
            for (i = 0; i < partitionKey.size(); ++i) {
                alias = keyAliases.size() > i ? (String)keyAliases.get(i) : (i == 0 ? DEFAULT_KEY_ALIAS : DEFAULT_KEY_ALIAS + (i + 1));
                partitionKey.set(i, ColumnMetadata.forAlias(tm, alias, keyValidator.types.get(i)));
            }
            for (i = 0; i < clusteringSize; ++i) {
                alias = columnAliases.size() > i ? columnAliases.get(i) : DEFAULT_COLUMN_ALIAS + (i + 1);
                clusteringColumns.set(i, ColumnMetadata.forAlias(tm, alias, comparator.types.get(i)));
                clusteringOrder.set(i, comparator.reversed.get(i) != false ? Order.DESC : Order.ASC);
            }
            if (isDense) {
                String alias2 = row.isNull(VALUE_ALIAS) ? DEFAULT_VALUE_ALIAS : row.getString(VALUE_ALIAS);
                DataType type = CassandraTypeParser.parseOne(row.getString(VALIDATOR));
                otherColumns.add(ColumnMetadata.forAlias(tm, alias2, type));
            }
        }
        block8: for (ColumnMetadata.Raw rawCol : rawCols.values()) {
            ColumnMetadata col = ColumnMetadata.fromRaw(tm, rawCol);
            switch (rawCol.kind) {
                case PARTITION_KEY: {
                    partitionKey.set(rawCol.componentIndex, col);
                    continue block8;
                }
                case CLUSTERING_KEY: {
                    clusteringColumns.set(rawCol.componentIndex, col);
                    clusteringOrder.set(rawCol.componentIndex, rawCol.isReversed ? Order.DESC : Order.ASC);
                    continue block8;
                }
            }
            otherColumns.add(col);
        }
        for (ColumnMetadata c : partitionKey) {
            columns.put(c.getName(), c);
        }
        for (ColumnMetadata c : clusteringColumns) {
            columns.put(c.getName(), c);
        }
        for (ColumnMetadata c : otherColumns) {
            columns.put(c.getName(), c);
        }
        ksm.add(tm);
        return tm;
    }

    private static int findClusteringSize(CassandraTypeParser.ParseResult comparator, Collection<ColumnMetadata.Raw> cols, List<String> columnAliases, VersionNumber cassandraVersion) {
        if (cassandraVersion.getMajor() >= 2) {
            int maxId = -1;
            for (ColumnMetadata.Raw col : cols) {
                if (col.kind != ColumnMetadata.Raw.Kind.CLUSTERING_KEY) continue;
                maxId = Math.max(maxId, col.componentIndex);
            }
            return maxId + 1;
        }
        int size = comparator.types.size();
        if (comparator.isComposite) {
            return !comparator.collections.isEmpty() || columnAliases.size() == size - 1 && comparator.types.get(size - 1).equals(DataType.text()) ? size - 1 : size;
        }
        return !columnAliases.isEmpty() || cols.isEmpty() ? size : 0;
    }

    private static <T> List<T> nullInitializedList(int size) {
        ArrayList<Object> l = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            l.add(null);
        }
        return l;
    }

    public String getName() {
        return this.name;
    }

    public KeyspaceMetadata getKeyspace() {
        return this.keyspace;
    }

    public ColumnMetadata getColumn(String name) {
        return this.columns.get(Metadata.handleId(name));
    }

    public List<ColumnMetadata> getColumns() {
        return new ArrayList<ColumnMetadata>(this.columns.values());
    }

    public List<ColumnMetadata> getPrimaryKey() {
        ArrayList<ColumnMetadata> pk = new ArrayList<ColumnMetadata>(this.partitionKey.size() + this.clusteringColumns.size());
        pk.addAll(this.partitionKey);
        pk.addAll(this.clusteringColumns);
        return pk;
    }

    public List<ColumnMetadata> getPartitionKey() {
        return Collections.unmodifiableList(this.partitionKey);
    }

    public List<ColumnMetadata> getClusteringColumns() {
        return Collections.unmodifiableList(this.clusteringColumns);
    }

    public List<Order> getClusteringOrder() {
        return this.clusteringOrder;
    }

    public Options getOptions() {
        return this.options;
    }

    void add(ColumnMetadata column) {
        this.columns.put(column.getName(), column);
    }

    public String exportAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.asCQLQuery(true));
        for (ColumnMetadata column : this.columns.values()) {
            ColumnMetadata.IndexMetadata index = column.getIndex();
            if (index == null) continue;
            sb.append('\n').append(index.asCQLQuery());
        }
        return sb.toString();
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(Metadata.escapeId(this.keyspace.getName())).append('.').append(Metadata.escapeId(this.name)).append(" (");
        this.newLine(sb, formatted);
        for (ColumnMetadata cm : this.columns.values()) {
            this.newLine(sb.append(this.spaces(4, formatted)).append(cm).append(','), formatted);
        }
        sb.append(this.spaces(4, formatted)).append("PRIMARY KEY (");
        if (this.partitionKey.size() == 1) {
            sb.append(this.partitionKey.get(0).getName());
        } else {
            sb.append('(');
            boolean first = true;
            for (ColumnMetadata cm : this.partitionKey) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(Metadata.escapeId(cm.getName()));
            }
            sb.append(')');
        }
        for (ColumnMetadata cm : this.clusteringColumns) {
            sb.append(", ").append(Metadata.escapeId(cm.getName()));
        }
        sb.append(')');
        this.newLine(sb, formatted);
        sb.append(") WITH ");
        if (this.options.isCompactStorage) {
            this.and(sb.append("COMPACT STORAGE"), formatted);
        }
        if (!Iterables.all(this.clusteringOrder, Order.isAscending)) {
            this.and(this.appendClusteringOrder(sb), formatted);
        }
        sb.append("read_repair_chance = ").append(this.options.readRepair);
        this.and(sb, formatted).append("dclocal_read_repair_chance = ").append(this.options.localReadRepair);
        if (this.cassandraVersion.getMajor() < 2 || this.cassandraVersion.getMajor() == 2 && this.cassandraVersion.getMinor() == 0) {
            this.and(sb, formatted).append("replicate_on_write = ").append(this.options.replicateOnWrite);
        }
        this.and(sb, formatted).append("gc_grace_seconds = ").append(this.options.gcGrace);
        this.and(sb, formatted).append("bloom_filter_fp_chance = ").append(this.options.bfFpChance);
        this.and(sb, formatted).append("caching = '").append(this.options.caching).append('\'');
        if (this.options.comment != null) {
            this.and(sb, formatted).append("comment = '").append(this.options.comment).append('\'');
        }
        this.and(sb, formatted).append("compaction = ").append(TableMetadata.formatOptionMap(this.options.compaction));
        this.and(sb, formatted).append("compression = ").append(TableMetadata.formatOptionMap(this.options.compression));
        if (this.cassandraVersion.getMajor() >= 2) {
            this.and(sb, formatted).append("default_time_to_live = ").append(this.options.defaultTTL);
            this.and(sb, formatted).append("speculative_retry = '").append(this.options.speculativeRetry).append('\'');
            this.and(sb, formatted).append("index_interval = ").append(this.options.indexInterval);
        }
        sb.append(';');
        return sb.toString();
    }

    private StringBuilder appendClusteringOrder(StringBuilder sb) {
        sb.append("CLUSTERING ORDER BY (");
        for (int i = 0; i < this.clusteringColumns.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.clusteringColumns.get(i).getName()).append(' ').append((Object)this.clusteringOrder.get(i));
        }
        return sb.append(')');
    }

    private static String formatOptionMap(Map<String, String> m) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (Map.Entry<String, String> entry : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append('\'').append(entry.getKey()).append('\'');
            sb.append(" : ");
            try {
                sb.append(Integer.parseInt(entry.getValue()));
            }
            catch (NumberFormatException e) {
                sb.append('\'').append(entry.getValue()).append('\'');
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    private StringBuilder and(StringBuilder sb, boolean formatted) {
        return this.newLine(sb, formatted).append(this.spaces(2, formatted)).append(" AND ");
    }

    private String spaces(int n, boolean formatted) {
        if (!formatted) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private StringBuilder newLine(StringBuilder sb, boolean formatted) {
        if (formatted) {
            sb.append('\n');
        }
        return sb;
    }

    public static class Options {
        private static final String COMMENT = "comment";
        private static final String READ_REPAIR = "read_repair_chance";
        private static final String LOCAL_READ_REPAIR = "local_read_repair_chance";
        private static final String REPLICATE_ON_WRITE = "replicate_on_write";
        private static final String GC_GRACE = "gc_grace_seconds";
        private static final String BF_FP_CHANCE = "bloom_filter_fp_chance";
        private static final String CACHING = "caching";
        private static final String COMPACTION_CLASS = "compaction_strategy_class";
        private static final String COMPACTION_OPTIONS = "compaction_strategy_options";
        private static final String MIN_COMPACTION_THRESHOLD = "min_compaction_threshold";
        private static final String MAX_COMPACTION_THRESHOLD = "max_compaction_threshold";
        private static final String POPULATE_CACHE_ON_FLUSH = "populate_io_cache_on_flush";
        private static final String COMPRESSION_PARAMS = "compression_parameters";
        private static final String MEMTABLE_FLUSH_PERIOD_MS = "memtable_flush_period_in_ms";
        private static final String DEFAULT_TTL = "default_time_to_live";
        private static final String SPECULATIVE_RETRY = "speculative_retry";
        private static final String INDEX_INTERVAL = "index_interval";
        private static final double DEFAULT_BF_FP_CHANCE = 0.01;
        private static final boolean DEFAULT_POPULATE_CACHE_ON_FLUSH = false;
        private static final int DEFAULT_MEMTABLE_FLUSH_PERIOD = 0;
        private static final int DEFAULT_DEFAULT_TTL = 0;
        private static final String DEFAULT_SPECULATIVE_RETRY = "NONE";
        private static final int DEFAULT_INDEX_INTERVAL = 128;
        private final boolean isCompactStorage;
        private final String comment;
        private final double readRepair;
        private final double localReadRepair;
        private final boolean replicateOnWrite;
        private final int gcGrace;
        private final double bfFpChance;
        private final String caching;
        private final boolean populateCacheOnFlush;
        private final int memtableFlushPeriodMs;
        private final int defaultTTL;
        private final String speculativeRetry;
        private final int indexInterval;
        private final Map<String, String> compaction = new HashMap<String, String>();
        private final Map<String, String> compression = new HashMap<String, String>();

        Options(Row row, boolean isCompactStorage, VersionNumber version) {
            this.isCompactStorage = isCompactStorage;
            this.comment = row.isNull(COMMENT) ? "" : row.getString(COMMENT);
            this.readRepair = row.getDouble(READ_REPAIR);
            this.localReadRepair = row.getDouble(LOCAL_READ_REPAIR);
            this.replicateOnWrite = version.getMajor() > 2 || version.getMajor() == 2 && version.getMinor() >= 1 || row.isNull(REPLICATE_ON_WRITE) ? true : row.getBool(REPLICATE_ON_WRITE);
            this.gcGrace = row.getInt(GC_GRACE);
            this.bfFpChance = row.isNull(BF_FP_CHANCE) ? 0.01 : row.getDouble(BF_FP_CHANCE);
            this.caching = row.getString(CACHING);
            this.populateCacheOnFlush = row.isNull(POPULATE_CACHE_ON_FLUSH) ? false : row.getBool(POPULATE_CACHE_ON_FLUSH);
            this.memtableFlushPeriodMs = version.getMajor() < 2 || row.isNull(MEMTABLE_FLUSH_PERIOD_MS) ? 0 : row.getInt(MEMTABLE_FLUSH_PERIOD_MS);
            this.defaultTTL = version.getMajor() < 2 || row.isNull(DEFAULT_TTL) ? 0 : row.getInt(DEFAULT_TTL);
            this.speculativeRetry = version.getMajor() < 2 || row.isNull(SPECULATIVE_RETRY) ? DEFAULT_SPECULATIVE_RETRY : row.getString(SPECULATIVE_RETRY);
            this.indexInterval = version.getMajor() < 2 || row.isNull(INDEX_INTERVAL) ? 128 : row.getInt(INDEX_INTERVAL);
            this.compaction.put("class", row.getString(COMPACTION_CLASS));
            this.compaction.putAll(SimpleJSONParser.parseStringMap(row.getString(COMPACTION_OPTIONS)));
            this.compression.putAll(SimpleJSONParser.parseStringMap(row.getString(COMPRESSION_PARAMS)));
        }

        public boolean isCompactStorage() {
            return this.isCompactStorage;
        }

        public String getComment() {
            return this.comment;
        }

        public double getReadRepairChance() {
            return this.readRepair;
        }

        public double getLocalReadRepairChance() {
            return this.localReadRepair;
        }

        public boolean getReplicateOnWrite() {
            return this.replicateOnWrite;
        }

        public int getGcGraceInSeconds() {
            return this.gcGrace;
        }

        public double getBloomFilterFalsePositiveChance() {
            return this.bfFpChance;
        }

        public String getCaching() {
            return this.caching;
        }

        public boolean getPopulateIOCacheOnFlush() {
            return this.populateCacheOnFlush;
        }

        public int getMemtableFlushPeriodInMs() {
            return this.memtableFlushPeriodMs;
        }

        public int getDefaultTimeToLive() {
            return this.defaultTTL;
        }

        public String getSpeculativeRetry() {
            return this.speculativeRetry;
        }

        public int getIndexInterval() {
            return this.indexInterval;
        }

        public Map<String, String> getCompaction() {
            return new HashMap<String, String>(this.compaction);
        }

        public Map<String, String> getCompression() {
            return new HashMap<String, String>(this.compression);
        }
    }

    public static enum Order {
        ASC,
        DESC;

        static final Predicate<Order> isAscending;

        static {
            isAscending = new Predicate<Order>(){

                public boolean apply(Order o) {
                    return o == ASC;
                }
            };
        }
    }
}

