/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.RegularStatement;
import java.nio.ByteBuffer;

public class SimpleStatement
extends RegularStatement {
    private final String query;
    private final ByteBuffer[] values;
    private volatile ByteBuffer routingKey;
    private volatile String keyspace;

    public SimpleStatement(String query) {
        this.query = query;
        this.values = null;
    }

    public SimpleStatement(String query, Object ... values) {
        if (values.length > 65535) {
            throw new IllegalArgumentException("Too many values, the maximum allowed is 65535");
        }
        this.query = query;
        this.values = SimpleStatement.convert(values);
    }

    private static ByteBuffer[] convert(Object[] values) {
        ByteBuffer[] serializedValues = new ByteBuffer[values.length];
        for (int i = 0; i < values.length; ++i) {
            try {
                serializedValues[i] = DataType.serializeValue(values[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Value %d of type %s does not correspond to any CQL3 type", i, values[i].getClass()));
            }
        }
        return serializedValues;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    @Override
    public ByteBuffer[] getValues() {
        return this.values;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    public SimpleStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public SimpleStatement setKeyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public SimpleStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    static ByteBuffer compose(ByteBuffer ... buffers) {
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer buffer : buffers) {
            ByteBuffer bb = buffer.duplicate();
            SimpleStatement.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }
}

