/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.codec.socks;

import com.datastax.shaded.netty.buffer.ChannelBuffer;
import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.handler.codec.replay.ReplayingDecoder;
import com.datastax.shaded.netty.handler.codec.socks.SocksCommonUtils;
import com.datastax.shaded.netty.handler.codec.socks.SocksInitRequest;
import com.datastax.shaded.netty.handler.codec.socks.SocksMessage;
import com.datastax.shaded.netty.handler.codec.socks.SocksRequest;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocksInitRequestDecoder
extends ReplayingDecoder<State> {
    private static final String name = "SOCKS_INIT_REQUEST_DECODER";
    private final List<SocksMessage.AuthScheme> authSchemes = new ArrayList<SocksMessage.AuthScheme>();
    private SocksMessage.ProtocolVersion version;
    private byte authSchemeNum;
    private SocksRequest msg = SocksCommonUtils.UNKNOWN_SOCKS_REQUEST;

    public static String getName() {
        return name;
    }

    public SocksInitRequestDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.ProtocolVersion.fromByte(buffer.readByte());
                if (this.version != SocksMessage.ProtocolVersion.SOCKS5) break;
                this.checkpoint(State.READ_AUTH_SCHEMES);
            }
            case READ_AUTH_SCHEMES: {
                this.authSchemes.clear();
                this.authSchemeNum = buffer.readByte();
                for (int i = 0; i < this.authSchemeNum; ++i) {
                    this.authSchemes.add(SocksMessage.AuthScheme.fromByte(buffer.readByte()));
                }
                this.msg = new SocksInitRequest(this.authSchemes);
            }
        }
        ctx.getPipeline().remove(this);
        return this.msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_SCHEMES;

    }
}

