/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.codec.string;

import com.datastax.shaded.netty.buffer.ChannelBuffers;
import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.ChannelHandler;
import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.handler.codec.oneone.OneToOneEncoder;
import java.nio.charset.Charset;

@ChannelHandler.Sharable
public class StringEncoder
extends OneToOneEncoder {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    @Deprecated
    public StringEncoder(String charsetName) {
        this(Charset.forName(charsetName));
    }

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (msg instanceof String) {
            return ChannelBuffers.copiedBuffer(ctx.getChannel().getConfig().getBufferFactory().getDefaultOrder(), (CharSequence)((String)msg), this.charset);
        }
        return msg;
    }
}

