/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;

public abstract class AbstractPoliciesTest {
    private static final boolean DEBUG = false;
    protected Map<InetAddress, Integer> coordinators = new HashMap<InetAddress, Integer>();
    protected PreparedStatement prepared;

    public static void createSchema(Session session) {
        AbstractPoliciesTest.createSchema(session, 1);
    }

    public static void createSchema(Session session, int replicationFactor) {
        session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "ks", replicationFactor));
        session.execute("USE ks");
        session.execute(String.format("CREATE TABLE %s (k int PRIMARY KEY, i int)", "test"));
    }

    public static void createMultiDCSchema(Session session) {
        AbstractPoliciesTest.createMultiDCSchema(session, 1, 1);
    }

    public static void createMultiDCSchema(Session session, int dc1RF, int dc2RF) {
        session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : '%s', %s }", "ks", "NetworkTopologyStrategy", String.format("'dc1' : %d, 'dc2' : %d", dc1RF, dc2RF)));
        session.execute("USE ks");
        session.execute(String.format("CREATE TABLE %s (k int PRIMARY KEY, i int)", "test"));
    }

    protected void addCoordinator(ResultSet rs) {
        InetAddress coordinator;
        Integer n = this.coordinators.get(coordinator = rs.getExecutionInfo().getQueriedHost().getAddress());
        this.coordinators.put(coordinator, n == null ? 1 : n + 1);
    }

    protected void resetCoordinators() {
        this.coordinators = new HashMap<InetAddress, Integer>();
    }

    private String queriedMapString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<InetAddress, Integer> entry : this.coordinators.entrySet()) {
            sb.append(entry.getKey()).append(" : ").append(entry.getValue()).append(", ");
        }
        return sb.append("}").toString();
    }

    protected void assertQueried(String host, int n) {
        try {
            Integer queried = this.coordinators.get(InetAddress.getByName(host));
            Assert.assertEquals((int)(queried == null ? 0 : queried), (int)n, (String)this.queriedMapString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertQueriedAtLeast(String host, int n) {
        try {
            Integer queried = this.coordinators.get(InetAddress.getByName(host));
            queried = queried == null ? 0 : queried;
            Assert.assertTrue((queried >= n ? 1 : 0) != 0, (String)("For " + host));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertOneNodeQueried(int n, String ... hosts) {
        try {
            boolean found = false;
            for (String host : hosts) {
                int queried;
                InetAddress addr = InetAddress.getByName(host);
                int n2 = queried = this.coordinators.containsKey(addr) ? this.coordinators.get(addr) : 0;
                if (n == queried) {
                    if (found) {
                        throw new AssertionError((Object)String.format("Found 2 nodes with " + n + " queries in " + this.queriedMapString(), new Object[0]));
                    }
                    found = true;
                    continue;
                }
                if (queried != 0) {
                    throw new AssertionError((Object)String.format("Host " + addr + " should have be queried: " + this.queriedMapString(), new Object[0]));
                }
            }
            if (!found) {
                throw new AssertionError((Object)("Found no host queried exactly " + n + " times in " + this.queriedMapString()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void failDebug(String message) {
        Assert.fail((String)message);
    }

    protected void init(CCMBridge.CCMCluster c, int n) {
        this.write(c, n, false, ConsistencyLevel.ONE);
        this.prepared = c.session.prepare("SELECT * FROM test WHERE k = ?").setConsistencyLevel(ConsistencyLevel.ONE);
    }

    protected void init(CCMBridge.CCMCluster c, int n, boolean batch) {
        this.write(c, n, batch, ConsistencyLevel.ONE);
        this.prepared = c.session.prepare("SELECT * FROM test WHERE k = ?").setConsistencyLevel(ConsistencyLevel.ONE);
    }

    protected void init(CCMBridge.CCMCluster c, int n, ConsistencyLevel cl) {
        this.write(c, n, false, cl);
        this.prepared = c.session.prepare("SELECT * FROM test WHERE k = ?").setConsistencyLevel(cl);
    }

    protected void write(CCMBridge.CCMCluster c, int n) {
        this.write(c, n, false, ConsistencyLevel.ONE);
    }

    protected void write(CCMBridge.CCMCluster c, int n, boolean batch) {
        this.write(c, n, batch, ConsistencyLevel.ONE);
    }

    protected void write(CCMBridge.CCMCluster c, int n, ConsistencyLevel cl) {
        this.write(c, n, false, cl);
    }

    protected void write(CCMBridge.CCMCluster c, int n, boolean batch, ConsistencyLevel cl) {
        for (int i = 0; i < n; ++i) {
            if (batch) {
                c.session.execute(QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.insertInto((String)"test").values(new String[]{"k", "i"}, new Object[]{0, 0})).setConsistencyLevel(cl));
                continue;
            }
            c.session.execute(new SimpleStatement(String.format("INSERT INTO %s(k, i) VALUES (0, 0)", "test")).setConsistencyLevel(cl));
        }
    }

    protected void query(CCMBridge.CCMCluster c, int n) {
        this.query(c, n, false, ConsistencyLevel.ONE);
    }

    protected void query(CCMBridge.CCMCluster c, int n, boolean usePrepared) {
        this.query(c, n, usePrepared, ConsistencyLevel.ONE);
    }

    protected void query(CCMBridge.CCMCluster c, int n, ConsistencyLevel cl) {
        this.query(c, n, false, cl);
    }

    protected void query(CCMBridge.CCMCluster c, int n, boolean usePrepared, ConsistencyLevel cl) {
        if (usePrepared) {
            BoundStatement bs = this.prepared.bind(new Object[]{0});
            for (int i = 0; i < n; ++i) {
                this.addCoordinator(c.session.execute((Statement)bs));
            }
        } else {
            ByteBuffer routingKey = ByteBuffer.allocate(4);
            routingKey.putInt(0, 0);
            for (int i = 0; i < n; ++i) {
                this.addCoordinator(c.session.execute(new SimpleStatement(String.format("SELECT * FROM %s WHERE k = 0", "test")).setRoutingKey(routingKey).setConsistencyLevel(cl)));
            }
        }
    }
}

