/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SessionManager;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AsyncQueryTest
extends CCMBridge.PerClassSingleNodeCluster {
    @Override
    protected Collection<String> getTableDefinitions() {
        return Lists.newArrayList();
    }

    @Test(groups={"short"})
    public void cancelQueryTest() throws InterruptedException {
        ResultSetFuture future = session.executeAsync("select release_version from system.local");
        future.cancel(true);
        Assert.assertTrue((boolean)future.isCancelled());
        TimeUnit.MILLISECONDS.sleep(100L);
        HostConnectionPool pool = AsyncQueryTest.getPool(session);
        for (Connection connection : pool.connections) {
            Assert.assertEquals((int)connection.inFlight.get(), (int)0);
        }
    }

    private static HostConnectionPool getPool(Session session) {
        Collection pools = ((SessionManager)session).pools.values();
        Assert.assertEquals((int)pools.size(), (int)1);
        return (HostConnectionPool)pools.iterator().next();
    }
}

