/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AuthenticationTest {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationTest.class);
    private CCMBridge cassandraCluster;

    @BeforeClass(groups={"short"})
    public void setupClusterWithAuthentication() throws InterruptedException {
        this.cassandraCluster = CCMBridge.create("test");
        this.cassandraCluster.populate(1);
        this.cassandraCluster.updateConfig("authenticator", "PasswordAuthenticator");
        this.cassandraCluster.start(1, "-Dcassandra.superuser_setup_delay_ms=0");
        TimeUnit.SECONDS.sleep(1L);
    }

    @AfterClass(groups={"short"})
    public void shutdownCluster() {
        if (null != this.cassandraCluster) {
            this.cassandraCluster.stop();
        }
    }

    @Test(groups={"short"})
    public void testAuthenticatedConnection() throws InterruptedException {
        try {
            Cluster.builder().addContactPoint(CCMBridge.IP_PREFIX + '1').withCredentials("cassandra", "cassandra").build().connect();
        }
        catch (NoHostAvailableException e) {
            for (Map.Entry entry : e.getErrors().entrySet()) {
                logger.error("Error connecting to " + entry.getKey(), (Throwable)entry.getValue());
            }
            throw new RuntimeException(e);
        }
    }

    @Test(groups={"short"}, expectedExceptions={AuthenticationException.class})
    public void testConnectionAttemptWithIncorrectCredentialsIsRefused() throws InterruptedException {
        try {
            Cluster.builder().addContactPoint(CCMBridge.IP_PREFIX + '1').withCredentials("bogus", "bogus").build().connect();
        }
        catch (NoHostAvailableException e) {
            for (Map.Entry entry : e.getErrors().entrySet()) {
                logger.info("Error connecting to " + entry.getKey() + ": " + entry.getValue());
            }
            throw new RuntimeException(e);
        }
    }

    @Test(groups={"short"}, expectedExceptions={AuthenticationException.class})
    public void testConnectionAttemptWithoutCredentialsIsRefused() throws InterruptedException {
        try {
            Cluster.builder().addContactPoint(CCMBridge.IP_PREFIX + '1').build().connect();
        }
        catch (NoHostAvailableException e) {
            for (Map.Entry entry : e.getErrors().entrySet()) {
                logger.info("Error connecting to " + entry.getKey() + ": " + entry.getValue());
            }
            throw new RuntimeException(e);
        }
    }
}

