/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import java.util.Collection;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BatchStatementTest
extends CCMBridge.PerClassSingleNodeCluster {
    @Override
    protected Collection<String> getTableDefinitions() {
        return Collections.singletonList("CREATE TABLE test (k text, v int, PRIMARY KEY (k, v))");
    }

    @Test(groups={"short"})
    public void simpleBatchTest() throws Throwable {
        try {
            PreparedStatement st = session.prepare("INSERT INTO test (k, v) VALUES (?, ?)");
            BatchStatement batch = new BatchStatement();
            batch.add((Statement)new SimpleStatement("INSERT INTO test (k, v) VALUES (?, ?)", new Object[]{"key1", 0}));
            batch.add((Statement)st.bind(new Object[]{"key1", 1}));
            batch.add((Statement)st.bind(new Object[]{"key2", 0}));
            session.execute((Statement)batch);
            ResultSet rs = session.execute("SELECT * FROM test");
            Row r = rs.one();
            Assert.assertEquals((String)r.getString("k"), (String)"key1");
            Assert.assertEquals((int)r.getInt("v"), (int)0);
            r = rs.one();
            Assert.assertEquals((String)r.getString("k"), (String)"key1");
            Assert.assertEquals((int)r.getInt("v"), (int)1);
            r = rs.one();
            Assert.assertEquals((String)r.getString("k"), (String)"key2");
            Assert.assertEquals((int)r.getInt("v"), (int)0);
            Assert.assertTrue((boolean)rs.isExhausted());
            session.execute("DELETE FROM test WHERE k='key1'");
            session.execute("DELETE FROM test WHERE k='key2'");
        }
        catch (UnsupportedFeatureException e) {
            if (cluster.getConfiguration().getProtocolOptions().getProtocolVersion() != 1) {
                throw e;
            }
        }
        catch (Throwable t) {
            this.errorOut();
            throw t;
        }
    }

    @Test(groups={"short"})
    public void casBatchTest() throws Throwable {
        TestUtils.versionCheck(2.0, 9, "This will only work with C* 2.0.9 (CASSANDRA-7337)");
        try {
            PreparedStatement st = session.prepare("INSERT INTO test (k, v) VALUES (?, ?) IF NOT EXISTS");
            BatchStatement batch = new BatchStatement();
            batch.add((Statement)new SimpleStatement("INSERT INTO test (k, v) VALUES (?, ?)", new Object[]{"key1", 0}));
            batch.add((Statement)st.bind(new Object[]{"key1", 1}));
            batch.add((Statement)st.bind(new Object[]{"key1", 2}));
            ResultSet rs = session.execute((Statement)batch);
            Row r = rs.one();
            Assert.assertTrue((!r.isNull("[applied]") ? 1 : 0) != 0);
            Assert.assertEquals((boolean)r.getBool("[applied]"), (boolean)true);
            rs = session.execute((Statement)batch);
            r = rs.one();
            Assert.assertTrue((!r.isNull("[applied]") ? 1 : 0) != 0);
            Assert.assertEquals((boolean)r.getBool("[applied]"), (boolean)false);
        }
        catch (UnsupportedFeatureException e) {
            if (cluster.getConfiguration().getProtocolOptions().getProtocolVersion() != 1) {
                throw e;
            }
        }
        catch (Throwable t) {
            this.errorOut();
            throw t;
        }
        finally {
            session.execute("DELETE FROM test WHERE k='key1'");
        }
    }
}

