/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class CCMBridge {
    private static final Logger logger = LoggerFactory.getLogger(CCMBridge.class);
    public static final String IP_PREFIX;
    private static final String CASSANDRA_VERSION_REGEXP = "\\d\\.\\d\\.\\d+(-\\w+)?";
    static final File CASSANDRA_DIR;
    static final String CASSANDRA_VERSION;
    private final Runtime runtime = Runtime.getRuntime();
    private final File ccmDir = Files.createTempDir();

    private CCMBridge() {
    }

    public static CCMBridge create(String name) {
        CCMBridge bridge = new CCMBridge();
        bridge.execute("ccm create %s -b -i %s %s", name, IP_PREFIX, CASSANDRA_VERSION);
        return bridge;
    }

    public static CCMBridge create(String name, int nbNodes) {
        CCMBridge bridge = new CCMBridge();
        bridge.execute("ccm create %s -n %d -s -i %s -b %s", name, nbNodes, IP_PREFIX, CASSANDRA_VERSION);
        return bridge;
    }

    public static CCMBridge create(String name, int nbNodesDC1, int nbNodesDC2) {
        CCMBridge bridge = new CCMBridge();
        bridge.execute("ccm create %s -n %d:%d -s -i %s -b %s", name, nbNodesDC1, nbNodesDC2, IP_PREFIX, CASSANDRA_VERSION);
        return bridge;
    }

    public static CCMCluster buildCluster(int nbNodes, Cluster.Builder builder) {
        return CCMCluster.create(nbNodes, builder);
    }

    public static CCMCluster buildCluster(int nbNodesDC1, int nbNodesDC2, Cluster.Builder builder) {
        return CCMCluster.create(nbNodesDC1, nbNodesDC2, builder);
    }

    public void start() {
        this.execute("ccm start --wait-other-notice --wait-for-binary-proto", new Object[0]);
    }

    public void stop() {
        this.execute("ccm stop", new Object[0]);
    }

    public void forceStop() {
        this.execute("ccm stop --not-gently", new Object[0]);
    }

    public void start(int n) {
        logger.info("Starting: " + IP_PREFIX + n);
        this.execute("ccm node%d start --wait-other-notice --wait-for-binary-proto", n);
    }

    public void start(int n, String option) {
        logger.info("Starting: " + IP_PREFIX + n + " with " + option);
        this.execute("ccm node%d start --wait-other-notice --wait-for-binary-proto --jvm_arg=%s", n, option);
    }

    public void stop(int n) {
        logger.info("Stopping: " + IP_PREFIX + n);
        this.execute("ccm node%d stop", n);
    }

    public void forceStop(int n) {
        logger.info("Force stopping: " + IP_PREFIX + n);
        this.execute("ccm node%d stop --not-gently", n);
    }

    public void remove() {
        this.stop();
        this.execute("ccm remove", new Object[0]);
    }

    public void ring() {
        this.ring(1);
    }

    public void ring(int n) {
        this.executeAndPrint("ccm node%d ring", n);
    }

    public void bootstrapNode(int n) {
        this.bootstrapNode(n, null);
    }

    public void bootstrapNode(int n, String dc) {
        if (dc == null) {
            this.execute("ccm add node%d -i %s%d -j %d -b", n, IP_PREFIX, n, 7000 + 100 * n);
        } else {
            this.execute("ccm add node%d -i %s%d -j %d -b -d %s", n, IP_PREFIX, n, 7000 + 100 * n, dc);
        }
        this.execute("ccm node%d start --wait-other-notice --wait-for-binary-proto", n);
    }

    public void decommissionNode(int n) {
        this.execute("ccm node%d decommission", n);
    }

    public void updateConfig(String name, String value) {
        this.execute("ccm updateconf %s:%s", name, value);
    }

    public void populate(int n) {
        this.execute("ccm populate -n %d -i %s", n, IP_PREFIX);
    }

    private void execute(String command, Object ... args) {
        try {
            String fullCommand = String.format(command, args) + " --config-dir=" + this.ccmDir;
            logger.debug("Executing: " + fullCommand);
            Process p = this.runtime.exec(fullCommand, null, CASSANDRA_DIR);
            int retValue = p.waitFor();
            if (retValue != 0) {
                BufferedReader outReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader errReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                String line = outReader.readLine();
                while (line != null) {
                    logger.info("out> " + line);
                    line = outReader.readLine();
                }
                line = errReader.readLine();
                while (line != null) {
                    logger.error("err> " + line);
                    line = errReader.readLine();
                }
                throw new RuntimeException();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void executeAndPrint(String command, Object ... args) {
        try {
            String fullCommand = String.format(command, args) + " --config-dir=" + this.ccmDir;
            logger.debug("Executing: " + fullCommand);
            Process p = this.runtime.exec(fullCommand, null, CASSANDRA_DIR);
            int retValue = p.waitFor();
            BufferedReader outReaderOutput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = outReaderOutput.readLine();
            while (line != null) {
                System.out.println(line);
                line = outReaderOutput.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        String version = System.getProperty("cassandra.version");
        if (version.matches(CASSANDRA_VERSION_REGEXP)) {
            CASSANDRA_DIR = null;
            CASSANDRA_VERSION = "-v " + version;
        } else {
            CASSANDRA_DIR = new File(version);
            CASSANDRA_VERSION = "";
        }
        String ip_prefix = System.getProperty("ipprefix");
        if (ip_prefix == null || ip_prefix.isEmpty()) {
            ip_prefix = "127.0.1.";
        }
        IP_PREFIX = ip_prefix;
    }

    public static class CCMCluster {
        public final Cluster cluster;
        public final Session session;
        public final CCMBridge cassandraCluster;
        private boolean erroredOut;

        public static CCMCluster create(int nbNodes, Cluster.Builder builder) {
            if (nbNodes == 0) {
                throw new IllegalArgumentException();
            }
            return new CCMCluster(CCMBridge.create("test", nbNodes), builder, nbNodes);
        }

        public static CCMCluster create(int nbNodesDC1, int nbNodesDC2, Cluster.Builder builder) {
            if (nbNodesDC1 == 0) {
                throw new IllegalArgumentException();
            }
            return new CCMCluster(CCMBridge.create("test", nbNodesDC1, nbNodesDC2), builder, nbNodesDC1 + nbNodesDC2);
        }

        private CCMCluster(CCMBridge cassandraCluster, Cluster.Builder builder, int totalNodes) {
            this.cassandraCluster = cassandraCluster;
            try {
                String[] contactPoints = new String[totalNodes];
                for (int i = 0; i < totalNodes; ++i) {
                    contactPoints[i] = IP_PREFIX + (i + 1);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.cluster = builder.addContactPoints(contactPoints).build();
                this.session = this.cluster.connect();
            }
            catch (NoHostAvailableException e) {
                for (Map.Entry entry : e.getErrors().entrySet()) {
                    logger.info("Error connecting to " + entry.getKey() + ": " + entry.getValue());
                }
                this.discard();
                throw new RuntimeException(e);
            }
        }

        public void errorOut() {
            this.erroredOut = true;
        }

        public void discard() {
            if (this.cluster != null) {
                this.cluster.close();
            }
            if (this.cassandraCluster == null) {
                logger.error("No cluster to discard");
            } else if (this.erroredOut) {
                this.cassandraCluster.stop();
                logger.info("Error during tests, kept C* logs in " + this.cassandraCluster.ccmDir);
            } else {
                this.cassandraCluster.remove();
                this.cassandraCluster.ccmDir.delete();
            }
        }
    }

    public static abstract class PerClassSingleNodeCluster {
        protected static CCMBridge cassandraCluster;
        private static boolean erroredOut;
        private static boolean schemaCreated;
        protected static Cluster cluster;
        protected static Session session;

        protected abstract Collection<String> getTableDefinitions();

        public void errorOut() {
            erroredOut = true;
        }

        public static void createCluster() {
            erroredOut = false;
            schemaCreated = false;
            cassandraCluster = CCMBridge.create("test", 1);
            try {
                cluster = Cluster.builder().addContactPoints(new String[]{IP_PREFIX + '1'}).build();
                session = cluster.connect();
            }
            catch (NoHostAvailableException e) {
                erroredOut = true;
                for (Map.Entry entry : e.getErrors().entrySet()) {
                    logger.info("Error connecting to " + entry.getKey() + ": " + entry.getValue());
                }
                throw new RuntimeException(e);
            }
        }

        @AfterClass(groups={"short", "long"})
        public static void discardCluster() {
            if (cluster != null) {
                cluster.close();
            }
            if (cassandraCluster == null) {
                logger.error("No cluster to discard");
            } else if (erroredOut) {
                cassandraCluster.stop();
                logger.info("Error during tests, kept C* logs in " + cassandraCluster.ccmDir);
            } else {
                cassandraCluster.remove();
                cassandraCluster.ccmDir.delete();
            }
        }

        @BeforeClass(groups={"short", "long"})
        public void beforeClass() {
            PerClassSingleNodeCluster.createCluster();
            this.maybeCreateSchema();
        }

        public void maybeCreateSchema() {
            try {
                if (schemaCreated) {
                    return;
                }
                try {
                    session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "ks", 1));
                }
                catch (AlreadyExistsException e) {
                    // empty catch block
                }
                session.execute("USE ks");
                for (String tableDef : this.getTableDefinitions()) {
                    try {
                        session.execute(tableDef);
                    }
                    catch (AlreadyExistsException alreadyExistsException) {}
                }
                schemaCreated = true;
            }
            catch (DriverException e) {
                erroredOut = true;
                throw e;
            }
        }
    }
}

