/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CaseSensitivityTest {
    private void assertExists(CCMBridge.CCMCluster c, String fetchName, String realName) {
        KeyspaceMetadata km = c.cluster.getMetadata().getKeyspace(fetchName);
        Assert.assertNotNull((Object)km);
        Assert.assertEquals((String)realName, (String)km.getName());
    }

    private void assertNotExists(CCMBridge.CCMCluster c, String name) {
        Assert.assertNull((Object)c.cluster.getMetadata().getKeyspace(name));
    }

    @Test(groups={"short"})
    public void testCaseInsensitiveKeyspace() throws Throwable {
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(1, Cluster.builder());
        Session s = c.session;
        try {
            String ksName = "MyKeyspace";
            s.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", ksName, 1));
            this.assertExists(c, ksName, "mykeyspace");
            this.assertExists(c, "mykeyspace", "mykeyspace");
            this.assertExists(c, "MYKEYSPACE", "mykeyspace");
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }

    @Test(groups={"short"})
    public void testCaseSensitiveKeyspace() throws Throwable {
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(1, Cluster.builder());
        Session s = c.session;
        try {
            String ksName = "\"MyKeyspace\"";
            s.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", ksName, 1));
            this.assertExists(c, ksName, "MyKeyspace");
            this.assertExists(c, Metadata.quote((String)"MyKeyspace"), "MyKeyspace");
            this.assertNotExists(c, "mykeyspace");
            this.assertNotExists(c, "MyKeyspace");
            this.assertNotExists(c, "MYKEYSPACE");
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }
}

