/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ColumnDefinitionsTest {
    @Test(groups={"unit"})
    public void caseTest() {
        ColumnDefinitions defs = new ColumnDefinitions(new ColumnDefinitions.Definition[]{new ColumnDefinitions.Definition("ks", "cf", "aColumn", DataType.text()), new ColumnDefinitions.Definition("ks", "cf", "fOO", DataType.text()), new ColumnDefinitions.Definition("ks", "cf", "anotherColumn", DataType.text())});
        Assert.assertTrue((boolean)defs.contains("foo"));
        Assert.assertTrue((boolean)defs.contains("fOO"));
        Assert.assertTrue((boolean)defs.contains("FOO"));
        defs = new ColumnDefinitions(new ColumnDefinitions.Definition[]{new ColumnDefinitions.Definition("ks", "cf", "aColumn", DataType.text()), new ColumnDefinitions.Definition("ks", "cf", "foo", DataType.text()), new ColumnDefinitions.Definition("ks", "cf", "anotherColumn", DataType.text()), new ColumnDefinitions.Definition("ks", "cf", "FOO", DataType.cint()), new ColumnDefinitions.Definition("ks", "cf", "with \" quote", DataType.text()), new ColumnDefinitions.Definition("ks", "cf", "\"in quote\"", DataType.text()), new ColumnDefinitions.Definition("ks", "cf", "in quote", DataType.cint())});
        Assert.assertTrue((boolean)defs.getType("foo").equals(DataType.text()));
        Assert.assertTrue((boolean)defs.getType("Foo").equals(DataType.text()));
        Assert.assertTrue((boolean)defs.getType("FOO").equals(DataType.text()));
        Assert.assertTrue((boolean)defs.getType("\"FOO\"").equals(DataType.cint()));
        Assert.assertTrue((boolean)defs.contains("with \" quote"));
        Assert.assertTrue((boolean)defs.getType("in quote").equals(DataType.cint()));
        Assert.assertTrue((boolean)defs.getType("\"in quote\"").equals(DataType.cint()));
        Assert.assertTrue((boolean)defs.getType("\"\"in quote\"\"").equals(DataType.text()));
    }

    @Test(groups={"unit"})
    public void multiDefinitionTest() {
        ColumnDefinitions defs = new ColumnDefinitions(new ColumnDefinitions.Definition[]{new ColumnDefinitions.Definition("ks", "cf1", "column", DataType.text()), new ColumnDefinitions.Definition("ks", "cf2", "column", DataType.cint()), new ColumnDefinitions.Definition("ks", "cf3", "column", DataType.cfloat())});
        Assert.assertTrue((boolean)defs.getType("column").equals(DataType.text()));
    }
}

