/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractPoliciesTest;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConsistencyTest
extends AbstractPoliciesTest {
    private static final Logger logger = LoggerFactory.getLogger(CCMBridge.class);

    @Test(groups={"long"})
    public void testRFOneTokenAware() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy()));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            List<String> acceptableErrorMessages;
            ConsistencyTest.createSchema(c.session, 1);
            this.init(c, 12, ConsistencyLevel.ONE);
            this.query(c, 12, ConsistencyLevel.ONE);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.resetCoordinators();
            TestUtils.stopAndWait(c, 2);
            List<ConsistencyLevel> acceptedList = Arrays.asList(ConsistencyLevel.ANY);
            List<ConsistencyLevel> failList = Arrays.asList(ConsistencyLevel.ONE, ConsistencyLevel.TWO, ConsistencyLevel.THREE, ConsistencyLevel.QUORUM, ConsistencyLevel.ALL, ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.EACH_QUORUM);
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.init(c, 12, cl);
                }
                catch (Exception e) {
                    Assert.fail((String)String.format("Test failed at CL.%s with message: %s", cl, e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.query(c, 12, cl);
                }
                catch (InvalidQueryException e) {
                    acceptableErrorMessages = Arrays.asList("ANY ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : failList) {
                try {
                    this.init(c, 12, cl);
                    Assert.fail((String)String.format("Test passed at CL.%s.", cl));
                }
                catch (InvalidQueryException e) {
                    acceptableErrorMessages = Arrays.asList("consistency level LOCAL_QUORUM not compatible with replication strategy (org.apache.cassandra.locator.SimpleStrategy)", "consistency level EACH_QUORUM not compatible with replication strategy (org.apache.cassandra.locator.SimpleStrategy)");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)String.format("Received: %s", e.getMessage()));
                }
                catch (UnavailableException e) {
                }
                catch (WriteTimeoutException e) {}
            }
            for (ConsistencyLevel cl : failList) {
                try {
                    this.query(c, 12, cl);
                    Assert.fail((String)String.format("Test passed at CL.%s.", cl));
                }
                catch (InvalidQueryException e) {
                    acceptableErrorMessages = Arrays.asList("consistency level LOCAL_QUORUM not compatible with replication strategy (org.apache.cassandra.locator.SimpleStrategy)", "EACH_QUORUM ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)String.format("Received: %s", e.getMessage()));
                }
                catch (ReadTimeoutException e) {
                }
                catch (UnavailableException e) {}
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void testRFTwoTokenAware() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy()));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            List<String> acceptableErrorMessages;
            ConsistencyTest.createSchema(c.session, 2);
            this.init(c, 12, ConsistencyLevel.TWO);
            this.query(c, 12, ConsistencyLevel.TWO);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.resetCoordinators();
            TestUtils.stopAndWait(c, 2);
            List<ConsistencyLevel> acceptedList = Arrays.asList(ConsistencyLevel.ANY, ConsistencyLevel.ONE);
            List<ConsistencyLevel> failList = Arrays.asList(ConsistencyLevel.TWO, ConsistencyLevel.QUORUM, ConsistencyLevel.THREE, ConsistencyLevel.ALL, ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.EACH_QUORUM);
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.init(c, 12, cl);
                }
                catch (Exception e) {
                    Assert.fail((String)String.format("Test failed at CL.%s with message: %s", cl, e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.query(c, 12, cl);
                }
                catch (InvalidQueryException e) {
                    acceptableErrorMessages = Arrays.asList("ANY ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : failList) {
                try {
                    this.init(c, 12, cl);
                    Assert.fail((String)String.format("Test passed at CL.%s.", cl));
                }
                catch (InvalidQueryException e) {
                    acceptableErrorMessages = Arrays.asList("consistency level LOCAL_QUORUM not compatible with replication strategy (org.apache.cassandra.locator.SimpleStrategy)", "consistency level EACH_QUORUM not compatible with replication strategy (org.apache.cassandra.locator.SimpleStrategy)");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)String.format("Received: %s", e.getMessage()));
                }
                catch (UnavailableException e) {
                }
                catch (WriteTimeoutException e) {}
            }
            for (ConsistencyLevel cl : failList) {
                try {
                    this.query(c, 12, cl);
                    Assert.fail((String)String.format("Test passed at CL.%s.", cl));
                }
                catch (InvalidQueryException e) {
                    acceptableErrorMessages = Arrays.asList("consistency level LOCAL_QUORUM not compatible with replication strategy (org.apache.cassandra.locator.SimpleStrategy)", "EACH_QUORUM ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)String.format("Received: %s", e.getMessage()));
                }
                catch (ReadTimeoutException e) {
                }
                catch (UnavailableException e) {}
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void testRFThreeTokenAware() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy()));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            ConsistencyTest.createSchema(c.session, 3);
            this.init(c, 12, ConsistencyLevel.TWO);
            this.query(c, 12, ConsistencyLevel.TWO);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.resetCoordinators();
            TestUtils.stopAndWait(c, 2);
            EnumSet<ConsistencyLevel> cls = EnumSet.allOf(ConsistencyLevel.class);
            cls.remove(ConsistencyLevel.SERIAL);
            cls.remove(ConsistencyLevel.LOCAL_SERIAL);
            List<ConsistencyLevel> acceptedList = Arrays.asList(ConsistencyLevel.ANY, ConsistencyLevel.ONE, ConsistencyLevel.TWO, ConsistencyLevel.QUORUM, ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.EACH_QUORUM);
            List<ConsistencyLevel> failList = Arrays.asList(ConsistencyLevel.THREE, ConsistencyLevel.ALL);
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.init(c, 12, cl);
                }
                catch (Exception e) {
                    Assert.fail((String)String.format("Test failed at CL.%s with message: %s", cl, e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.query(c, 12, cl);
                }
                catch (InvalidQueryException e) {
                    List<String> acceptableErrorMessages = Arrays.asList("ANY ConsistencyLevel is only supported for writes", "EACH_QUORUM ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)("Got unexpected message " + e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : failList) {
                try {
                    this.init(c, 12, cl);
                    Assert.fail((String)String.format("Test passed at CL.%s.", cl));
                }
                catch (UnavailableException e) {
                }
                catch (WriteTimeoutException e) {}
            }
            for (ConsistencyLevel cl : failList) {
                try {
                    this.query(c, 12, cl);
                    Assert.fail((String)String.format("Test passed at CL.%s.", cl));
                }
                catch (ReadTimeoutException e) {
                }
                catch (UnavailableException e) {}
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void testRFOneDowngradingCL() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy())).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            List<String> acceptableErrorMessages;
            ConsistencyTest.createSchema(c.session, 1);
            this.init(c, 12, ConsistencyLevel.ONE);
            this.query(c, 12, ConsistencyLevel.ONE);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.resetCoordinators();
            TestUtils.stopAndWait(c, 2);
            List<ConsistencyLevel> acceptedList = Arrays.asList(ConsistencyLevel.ANY);
            List<ConsistencyLevel> failList = Arrays.asList(ConsistencyLevel.ONE, ConsistencyLevel.TWO, ConsistencyLevel.THREE, ConsistencyLevel.QUORUM, ConsistencyLevel.ALL, ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.EACH_QUORUM);
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.init(c, 12, cl);
                }
                catch (Exception e) {
                    Assert.fail((String)String.format("Test failed at CL.%s with message: %s", cl, e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.query(c, 12, cl);
                }
                catch (InvalidQueryException e) {
                    acceptableErrorMessages = Arrays.asList("ANY ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : failList) {
                try {
                    this.init(c, 12, cl);
                    Assert.fail((String)String.format("Test passed at CL.%s.", cl));
                }
                catch (UnavailableException e) {
                }
                catch (WriteTimeoutException e) {}
            }
            for (ConsistencyLevel cl : failList) {
                try {
                    this.query(c, 12, cl);
                    Assert.fail((String)String.format("Test passed at CL.%s.", cl));
                }
                catch (InvalidQueryException e) {
                    acceptableErrorMessages = Arrays.asList("EACH_QUORUM ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)("Got unexpected message " + e.getMessage()));
                }
                catch (ReadTimeoutException e) {
                }
                catch (UnavailableException e) {}
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void testRFTwoDowngradingCL() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy())).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            ConsistencyTest.createSchema(c.session, 2);
            this.init(c, 12, ConsistencyLevel.TWO);
            this.query(c, 12, ConsistencyLevel.TWO);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.resetCoordinators();
            TestUtils.stopAndWait(c, 2);
            EnumSet<ConsistencyLevel> acceptedList = EnumSet.allOf(ConsistencyLevel.class);
            acceptedList.remove(ConsistencyLevel.SERIAL);
            acceptedList.remove(ConsistencyLevel.LOCAL_SERIAL);
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.init(c, 12, cl);
                }
                catch (Exception e) {
                    Assert.fail((String)String.format("Test failed at CL.%s with message: %s", cl, e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.query(c, 12, cl);
                }
                catch (InvalidQueryException e) {
                    List<String> acceptableErrorMessages = Arrays.asList("ANY ConsistencyLevel is only supported for writes", "EACH_QUORUM ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)("Got unexpected message " + e.getMessage()));
                }
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void testRFThreeRoundRobinDowngradingCL() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
        this.testRFThreeDowngradingCL(builder);
    }

    @Test(groups={"long"})
    public void testRFThreeTokenAwareDowngradingCL() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy())).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
        this.testRFThreeDowngradingCL(builder);
    }

    public void testRFThreeDowngradingCL(Cluster.Builder builder) throws Throwable {
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            ConsistencyTest.createSchema(c.session, 3);
            this.init(c, 12, ConsistencyLevel.ALL);
            this.query(c, 12, ConsistencyLevel.ALL);
            try {
                this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
                this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
                this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            }
            catch (AssertionError e) {
                this.assertQueried(CCMBridge.IP_PREFIX + '1', 4);
                this.assertQueried(CCMBridge.IP_PREFIX + '2', 4);
                this.assertQueried(CCMBridge.IP_PREFIX + '3', 4);
            }
            this.resetCoordinators();
            TestUtils.stopAndWait(c, 2);
            EnumSet<ConsistencyLevel> acceptedList = EnumSet.allOf(ConsistencyLevel.class);
            acceptedList.remove(ConsistencyLevel.SERIAL);
            acceptedList.remove(ConsistencyLevel.LOCAL_SERIAL);
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.init(c, 12, cl);
                }
                catch (Exception e) {
                    Assert.fail((String)String.format("Test failed at CL.%s with message: %s", cl, e.getMessage()));
                }
            }
            for (ConsistencyLevel cl : acceptedList) {
                try {
                    this.query(c, 12, cl);
                }
                catch (InvalidQueryException e) {
                    List<String> acceptableErrorMessages = Arrays.asList("ANY ConsistencyLevel is only supported for writes", "EACH_QUORUM ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)("Got unexpected message " + e.getMessage()));
                }
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void testRFThreeDowngradingCLTwoDCs() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy())).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, 3, builder);
        try {
            ConsistencyTest.createMultiDCSchema(c.session, 3, 3);
            this.init(c, 12, ConsistencyLevel.TWO);
            this.query(c, 12, ConsistencyLevel.TWO);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '5', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '6', 0);
            this.resetCoordinators();
            logger.info("Stopping node 3...");
            TestUtils.stopAndWait(c, 3);
            logger.info("Node 3 stopped.");
            List<ConsistencyLevel> acceptedList = Arrays.asList(ConsistencyLevel.ANY, ConsistencyLevel.ONE, ConsistencyLevel.TWO, ConsistencyLevel.QUORUM, ConsistencyLevel.THREE, ConsistencyLevel.ALL, ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.EACH_QUORUM);
            List<Object> failList = Arrays.asList(new Object[0]);
            for (ConsistencyLevel consistencyLevel : acceptedList) {
                logger.info("Test successful init(): " + consistencyLevel);
                try {
                    this.init(c, 12, consistencyLevel);
                }
                catch (Exception e) {
                    Assert.fail((String)String.format("Test failed at CL.%s with message: %s", consistencyLevel, e.getMessage()));
                }
            }
            for (ConsistencyLevel consistencyLevel : acceptedList) {
                logger.info("Test successful query(): " + consistencyLevel);
                try {
                    this.query(c, 12, consistencyLevel);
                }
                catch (InvalidQueryException e) {
                    List<String> acceptableErrorMessages = Arrays.asList("EACH_QUORUM ConsistencyLevel is only supported for writes", "ANY ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)String.format("Received: %s", e.getMessage()));
                }
            }
            for (ConsistencyLevel consistencyLevel : failList) {
                logger.info("Test failure init(): " + consistencyLevel);
                try {
                    this.init(c, 12, consistencyLevel);
                    Assert.fail((String)String.format("Test passed at CL.%s.", consistencyLevel));
                }
                catch (UnavailableException e) {
                }
                catch (WriteTimeoutException e) {}
            }
            for (ConsistencyLevel consistencyLevel : failList) {
                logger.info("Test failure query(): " + consistencyLevel);
                try {
                    this.query(c, 12, consistencyLevel);
                    Assert.fail((String)String.format("Test passed at CL.%s.", consistencyLevel));
                }
                catch (ReadTimeoutException e) {
                }
                catch (UnavailableException e) {}
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void testRFThreeDowngradingCLTwoDCsDCAware() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new DCAwareRoundRobinPolicy("dc2"))).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, 3, builder);
        try {
            ConsistencyTest.createMultiDCSchema(c.session, 3, 3);
            this.init(c, 12, ConsistencyLevel.TWO);
            this.query(c, 12, ConsistencyLevel.TWO);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '5', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '6', 0);
            this.resetCoordinators();
            c.cassandraCluster.stop(2);
            List<ConsistencyLevel> acceptedList = Arrays.asList(ConsistencyLevel.ANY, ConsistencyLevel.ONE, ConsistencyLevel.TWO, ConsistencyLevel.QUORUM, ConsistencyLevel.THREE, ConsistencyLevel.ALL, ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.EACH_QUORUM);
            List<Object> failList = Arrays.asList(new Object[0]);
            for (ConsistencyLevel consistencyLevel : acceptedList) {
                try {
                    this.init(c, 12, consistencyLevel);
                }
                catch (Exception e) {
                    Assert.fail((String)String.format("Test failed at CL.%s with message: %s", consistencyLevel, e.getMessage()));
                }
            }
            for (ConsistencyLevel consistencyLevel : acceptedList) {
                try {
                    this.query(c, 12, consistencyLevel);
                }
                catch (InvalidQueryException e) {
                    List<String> acceptableErrorMessages = Arrays.asList("EACH_QUORUM ConsistencyLevel is only supported for writes", "ANY ConsistencyLevel is only supported for writes");
                    Assert.assertTrue((boolean)acceptableErrorMessages.contains(e.getMessage()), (String)String.format("Received: %s", e.getMessage()));
                }
            }
            for (ConsistencyLevel consistencyLevel : failList) {
                try {
                    this.init(c, 12, consistencyLevel);
                    Assert.fail((String)String.format("Test passed at CL.%s.", consistencyLevel));
                }
                catch (UnavailableException e) {
                }
                catch (WriteTimeoutException e) {}
            }
            for (ConsistencyLevel consistencyLevel : failList) {
                try {
                    this.query(c, 12, consistencyLevel);
                    Assert.fail((String)String.format("Test passed at CL.%s.", consistencyLevel));
                }
                catch (ReadTimeoutException e) {
                }
                catch (UnavailableException e) {}
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }
}

