/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CustomTypeTest
extends CCMBridge.PerClassSingleNodeCluster {
    @Override
    protected Collection<String> getTableDefinitions() {
        return Collections.singleton("CREATE TABLE test (    k int,    c 'DynamicCompositeType(s => UTF8Type, i => Int32Type)',    v int,    PRIMARY KEY (k, c)) WITH COMPACT STORAGE");
    }

    private ByteBuffer serializeForDynamicType(Object ... params) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>();
        int size = 0;
        for (Object p : params) {
            if (p instanceof Integer) {
                ByteBuffer elt = ByteBuffer.allocate(9);
                elt.putShort((short)-32663);
                elt.putShort((short)4);
                elt.putInt((Integer)p);
                elt.put((byte)0);
                elt.flip();
                size += elt.remaining();
                l.add(elt);
                continue;
            }
            if (p instanceof String) {
                ByteBuffer bytes = ByteBuffer.wrap(((String)p).getBytes());
                ByteBuffer elt = ByteBuffer.allocate(4 + bytes.remaining() + 1);
                elt.putShort((short)-32653);
                elt.putShort((short)bytes.remaining());
                elt.put(bytes);
                elt.put((byte)0);
                elt.flip();
                size += elt.remaining();
                l.add(elt);
                continue;
            }
            throw new RuntimeException();
        }
        ByteBuffer res = ByteBuffer.allocate(size);
        for (ByteBuffer bb : l) {
            res.put(bb);
        }
        res.flip();
        return res;
    }

    @Test(groups={"short"})
    public void DynamicCompositeTypeTest() {
        session.execute("INSERT INTO test(k, c, v) VALUES (0, 's@foo:i@32', 1)");
        session.execute("INSERT INTO test(k, c, v) VALUES (0, 'i@42', 2)");
        session.execute("INSERT INTO test(k, c, v) VALUES (0, 'i@12:i@3', 3)");
        ResultSet rs = session.execute("SELECT * FROM test");
        Row r = rs.one();
        Assert.assertEquals((int)r.getInt("k"), (int)0);
        Assert.assertEquals((Object)r.getBytesUnsafe("c"), (Object)this.serializeForDynamicType(12, 3));
        Assert.assertEquals((int)r.getInt("v"), (int)3);
        r = rs.one();
        Assert.assertEquals((int)r.getInt("k"), (int)0);
        Assert.assertEquals((Object)r.getBytesUnsafe("c"), (Object)this.serializeForDynamicType(42));
        Assert.assertEquals((int)r.getInt("v"), (int)2);
        r = rs.one();
        Assert.assertEquals((int)r.getInt("k"), (int)0);
        Assert.assertEquals((Object)r.getBytesUnsafe("c"), (Object)this.serializeForDynamicType("foo", 32));
        Assert.assertEquals((int)r.getInt("v"), (int)1);
    }
}

