/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeTest;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TupleType;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataTypeIntegrationTest
extends CCMBridge.PerClassSingleNodeCluster {
    private static final Set<DataType> DATA_TYPE_PRIMITIVES = DataType.allPrimitiveTypes();
    private static final Set<DataType.Name> DATA_TYPE_NON_PRIMITIVE_NAMES = EnumSet.of(DataType.Name.MAP, DataType.Name.SET, DataType.Name.LIST);
    private static final String PRIMITIVE_INSERT_FORMAT = "INSERT INTO %1$s (k, v) VALUES (%2$s, %2$s);";
    private static final String BASIC_SELECT_FORMAT = "SELECT k, v FROM %1$s;";
    private static final String COLLECTION_INSERT_FORMAT = "INSERT INTO %1$s (k, v) VALUES (%2$s, %3$s);";
    private static final String MAP_INSERT_FORMAT = "INSERT INTO %1$s (k, v) VALUES (%3$s, {%2$s: %3$s});";
    private static final HashMap<DataType, Object> SAMPLE_DATA = DataTypeIntegrationTest.getSampleData();
    private static final HashMap<DataType, Object> SAMPLE_COLLECTIONS = DataTypeIntegrationTest.getSampleCollections();
    private static final Collection<String> PRIMITIVE_INSERT_STATEMENTS = DataTypeIntegrationTest.getPrimitiveInsertStatements();
    private static final HashMap<DataType, String> PRIMITIVE_SELECT_STATEMENTS = DataTypeIntegrationTest.getPrimitiveSelectStatements();
    private static final Collection<String> COLLECTION_INSERT_STATEMENTS = DataTypeIntegrationTest.getCollectionInsertStatements();
    private static final HashMap<DataType, String> COLLECTION_SELECT_STATEMENTS = DataTypeIntegrationTest.getCollectionSelectStatements();

    @Override
    protected Collection<String> getTableDefinitions() {
        ArrayList<String> tableDefinitions = new ArrayList<String>();
        for (DataType dataType : DATA_TYPE_PRIMITIVES) {
            if (DataTypeTest.exclude(dataType)) continue;
            tableDefinitions.add(String.format("CREATE TABLE %1$s (k %2$s PRIMARY KEY, v %1$s)", dataType, dataType));
        }
        for (DataType.Name dataTypeName : DATA_TYPE_NON_PRIMITIVE_NAMES) {
            if (dataTypeName == DataType.Name.MAP) {
                for (DataType typeArgument1 : DATA_TYPE_PRIMITIVES) {
                    if (DataTypeTest.exclude(typeArgument1)) continue;
                    for (DataType typeArgument2 : DATA_TYPE_PRIMITIVES) {
                        if (DataTypeTest.exclude(typeArgument2)) continue;
                        tableDefinitions.add(String.format("CREATE TABLE %1$s_%2$s_%3$s (k %3$s PRIMARY KEY, v %1$s<%2$s, %3$s>)", dataTypeName, typeArgument1, typeArgument2));
                    }
                }
                continue;
            }
            for (DataType typeArgument : DATA_TYPE_PRIMITIVES) {
                if (DataTypeTest.exclude(typeArgument)) continue;
                tableDefinitions.add(String.format("CREATE TABLE %1$s_%2$s (k %2$s PRIMARY KEY, v %1$s<%2$s>)", dataTypeName, typeArgument));
            }
        }
        return tableDefinitions;
    }

    protected static HashMap<DataType, Object> getSampleData() {
        HashMap<DataType, Object> sampleData = new HashMap<DataType, Object>();
        block20: for (DataType dataType : DATA_TYPE_PRIMITIVES) {
            switch (dataType.getName()) {
                case ASCII: {
                    sampleData.put(dataType, new String("ascii"));
                    continue block20;
                }
                case BIGINT: {
                    sampleData.put(dataType, Long.MAX_VALUE);
                    continue block20;
                }
                case BLOB: {
                    ByteBuffer bb = ByteBuffer.allocate(58);
                    bb.putShort((short)-13570);
                    bb.flip();
                    sampleData.put(dataType, bb);
                    continue block20;
                }
                case BOOLEAN: {
                    sampleData.put(dataType, Boolean.TRUE);
                    continue block20;
                }
                case COUNTER: {
                    continue block20;
                }
                case DECIMAL: {
                    sampleData.put(dataType, new BigDecimal("12.3E+7"));
                    continue block20;
                }
                case DOUBLE: {
                    sampleData.put(dataType, Double.MAX_VALUE);
                    continue block20;
                }
                case FLOAT: {
                    sampleData.put(dataType, Float.valueOf(Float.MAX_VALUE));
                    continue block20;
                }
                case INET: {
                    try {
                        sampleData.put(dataType, InetAddress.getByName("123.123.123.123"));
                    }
                    catch (UnknownHostException e) {}
                    continue block20;
                }
                case INT: {
                    sampleData.put(dataType, Integer.MAX_VALUE);
                    continue block20;
                }
                case TEXT: {
                    sampleData.put(dataType, new String("text"));
                    continue block20;
                }
                case TIMESTAMP: {
                    sampleData.put(dataType, new Date(872835240000L));
                    continue block20;
                }
                case TIMEUUID: {
                    sampleData.put(dataType, UUID.fromString("FE2B4360-28C6-11E2-81C1-0800200C9A66"));
                    continue block20;
                }
                case UUID: {
                    sampleData.put(dataType, UUID.fromString("067e6162-3b6f-4ae2-a171-2470b63dff00"));
                    continue block20;
                }
                case VARCHAR: {
                    sampleData.put(dataType, new String("varchar"));
                    continue block20;
                }
                case VARINT: {
                    sampleData.put(dataType, new BigInteger(Integer.toString(Integer.MAX_VALUE) + "000"));
                    continue block20;
                }
            }
            throw new RuntimeException("Missing handling of " + dataType);
        }
        return sampleData;
    }

    protected static Object getCollectionSample(DataType.Name collectionType, DataType dataType) {
        if (collectionType == DataType.Name.LIST) {
            ArrayList<Object> theList = new ArrayList<Object>();
            theList.add(SAMPLE_DATA.get(dataType));
            theList.add(SAMPLE_DATA.get(dataType));
            return theList;
        }
        if (collectionType == DataType.Name.SET) {
            return ImmutableSet.of((Object)SAMPLE_DATA.get(dataType));
        }
        if (collectionType == DataType.Name.MAP) {
            return new HashMap<Object, Object>().put(SAMPLE_DATA.get(dataType), SAMPLE_DATA.get(dataType));
        }
        if (collectionType == DataType.Name.TUPLE) {
            TupleType t = TupleType.of((DataType[])new DataType[]{dataType});
            return t.newValue(new Object[]{SAMPLE_DATA.get(dataType)});
        }
        throw new IllegalArgumentException("Missing handling of non-primitive type" + collectionType);
    }

    protected static HashMap<DataType, Object> getSampleCollections() {
        HashMap<DataType, Object> sampleCollections = new HashMap<DataType, Object>();
        block5: for (DataType.Name dataTypeName : DATA_TYPE_NON_PRIMITIVE_NAMES) {
            switch (dataTypeName) {
                case LIST: {
                    HashMap<DataType, AbstractCollection> setAndListCollection;
                    int i;
                    for (DataType typeArgument : DATA_TYPE_PRIMITIVES) {
                        if (DataTypeTest.exclude(typeArgument)) continue;
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (i = 0; i < 5; ++i) {
                            list.add(SAMPLE_DATA.get(typeArgument));
                        }
                        setAndListCollection = new HashMap<DataType, AbstractCollection>();
                        setAndListCollection.put(typeArgument, list);
                        sampleCollections.put(DataType.list((DataType)typeArgument), setAndListCollection);
                    }
                    continue block5;
                }
                case SET: {
                    HashMap<DataType, AbstractCollection> setAndListCollection;
                    int i;
                    for (DataType typeArgument : DATA_TYPE_PRIMITIVES) {
                        if (DataTypeTest.exclude(typeArgument)) continue;
                        HashSet<Object> set = new HashSet<Object>();
                        for (i = 0; i < 5; ++i) {
                            set.add(SAMPLE_DATA.get(typeArgument));
                        }
                        setAndListCollection = new HashMap();
                        setAndListCollection.put(typeArgument, set);
                        sampleCollections.put(DataType.set((DataType)typeArgument), setAndListCollection);
                    }
                    continue block5;
                }
                case MAP: {
                    for (DataType typeArgument1 : DATA_TYPE_PRIMITIVES) {
                        if (DataTypeTest.exclude(typeArgument1)) continue;
                        for (DataType typeArgument2 : DATA_TYPE_PRIMITIVES) {
                            if (DataTypeTest.exclude(typeArgument2)) continue;
                            HashMap<DataType, Object> map = new HashMap<DataType, Object>();
                            map.put(typeArgument1, SAMPLE_DATA.get(typeArgument2));
                            HashMap<DataType, HashMap<DataType, Object>> mapCollection = new HashMap<DataType, HashMap<DataType, Object>>();
                            mapCollection.put(typeArgument1, map);
                            sampleCollections.put(DataType.map((DataType)typeArgument1, (DataType)typeArgument2), mapCollection);
                        }
                    }
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Missing handling of " + dataTypeName);
                }
            }
        }
        return sampleCollections;
    }

    private static String helperStringifiedData(DataType dataType) {
        String value = SAMPLE_DATA.get(dataType).toString();
        switch (dataType.getName()) {
            case BLOB: {
                value = "0xCAFE";
                break;
            }
            case INET: {
                InetAddress v1 = (InetAddress)SAMPLE_DATA.get(dataType);
                value = String.format("'%s'", v1.getHostAddress());
                break;
            }
            case TIMESTAMP: {
                Date v2 = (Date)SAMPLE_DATA.get(dataType);
                value = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(v2);
            }
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                value = String.format("'%s'", value);
                break;
            }
        }
        return value;
    }

    private static Collection<String> getPrimitiveInsertStatements() {
        ArrayList<String> insertStatements = new ArrayList<String>();
        for (DataType dataType : SAMPLE_DATA.keySet()) {
            String value = DataTypeIntegrationTest.helperStringifiedData(dataType);
            insertStatements.add(String.format(PRIMITIVE_INSERT_FORMAT, dataType, value));
        }
        return insertStatements;
    }

    private static HashMap<DataType, String> getPrimitiveSelectStatements() {
        HashMap<DataType, String> selectStatements = new HashMap<DataType, String>();
        for (DataType dataType : SAMPLE_DATA.keySet()) {
            selectStatements.put(dataType, String.format(BASIC_SELECT_FORMAT, dataType));
        }
        return selectStatements;
    }

    private static String helperGenerateTableName(DataType dataType) {
        String tableName = dataType.getName().toString();
        for (DataType typeArgument : dataType.getTypeArguments()) {
            tableName = tableName + "_" + typeArgument;
        }
        return tableName;
    }

    private static Collection<String> getCollectionInsertStatements() {
        ArrayList<String> insertStatements = new ArrayList<String>();
        for (DataType dataType : SAMPLE_COLLECTIONS.keySet()) {
            String value;
            String key;
            List typeArgument;
            HashMap sampleValueMap = (HashMap)SAMPLE_COLLECTIONS.get(dataType);
            String tableName = DataTypeIntegrationTest.helperGenerateTableName(dataType);
            if (dataType.getName() == DataType.Name.MAP) {
                typeArgument = dataType.getTypeArguments();
                key = DataTypeIntegrationTest.helperStringifiedData((DataType)typeArgument.get(0));
                value = DataTypeIntegrationTest.helperStringifiedData((DataType)typeArgument.get(1));
                insertStatements.add(String.format(MAP_INSERT_FORMAT, tableName, key, value));
                continue;
            }
            if (dataType.getName() == DataType.Name.LIST) {
                typeArgument = (DataType)sampleValueMap.keySet().iterator().next();
                key = DataTypeIntegrationTest.helperStringifiedData((DataType)typeArgument);
                value = "[";
                for (int i = 0; i < 5; ++i) {
                    value = value + key + ',';
                }
                value = value.substring(0, value.length() - 1) + ']';
                insertStatements.add(String.format(COLLECTION_INSERT_FORMAT, tableName, key, value));
                continue;
            }
            typeArgument = (DataType)sampleValueMap.keySet().iterator().next();
            key = DataTypeIntegrationTest.helperStringifiedData((DataType)typeArgument);
            value = '{' + key + '}';
            insertStatements.add(String.format(COLLECTION_INSERT_FORMAT, tableName, key, value));
        }
        return insertStatements;
    }

    private static HashMap<DataType, String> getCollectionSelectStatements() {
        HashMap<DataType, String> selectStatements = new HashMap<DataType, String>();
        for (DataType dataType : SAMPLE_COLLECTIONS.keySet()) {
            String tableName = DataTypeIntegrationTest.helperGenerateTableName(dataType);
            selectStatements.put(dataType, String.format(BASIC_SELECT_FORMAT, tableName));
        }
        return selectStatements;
    }

    public void primitiveInsertTest() throws Throwable {
        for (String execute_string : PRIMITIVE_INSERT_STATEMENTS) {
            ResultSet rs = session.execute(execute_string);
            Assert.assertTrue((boolean)rs.isExhausted());
        }
        Assert.assertEquals((int)SAMPLE_DATA.size(), (int)15);
        Assert.assertEquals((int)PRIMITIVE_INSERT_STATEMENTS.size(), (int)SAMPLE_DATA.size());
    }

    public void primitiveSelectTest() throws Throwable {
        for (DataType dataType : PRIMITIVE_SELECT_STATEMENTS.keySet()) {
            String execute_string = PRIMITIVE_SELECT_STATEMENTS.get(dataType);
            Row row = session.execute(execute_string).one();
            Object value = SAMPLE_DATA.get(dataType);
            Assert.assertEquals((Object)TestUtils.getValue(row, "k", dataType), (Object)value);
            Assert.assertEquals((Object)TestUtils.getValue(row, "v", dataType), (Object)value);
        }
        Assert.assertEquals((int)SAMPLE_DATA.size(), (int)15);
        Assert.assertEquals((int)PRIMITIVE_SELECT_STATEMENTS.keySet().size(), (int)SAMPLE_DATA.size());
    }

    @Test(groups={"long"})
    public void primitiveTests() throws Throwable {
        this.primitiveInsertTest();
        this.primitiveSelectTest();
    }

    @Test(groups={"short"})
    public void primitiveInsertWithValueTest() throws Throwable {
        TestUtils.versionCheck(2.0, 0, "This feature requires protocol v2");
        for (DataType dt : DataType.allPrimitiveTypes()) {
            if (DataTypeTest.exclude(dt)) continue;
            session.execute(String.format(PRIMITIVE_INSERT_FORMAT, dt, "?"), new Object[]{SAMPLE_DATA.get(dt), SAMPLE_DATA.get(dt)});
        }
        this.primitiveSelectTest();
    }

    public void collectionInsertTest() throws Throwable {
        for (String execute_string : COLLECTION_INSERT_STATEMENTS) {
            ResultSet rs = session.execute(execute_string);
            Assert.assertTrue((boolean)rs.isExhausted());
        }
        Assert.assertEquals((int)SAMPLE_COLLECTIONS.size(), (int)255);
        Assert.assertEquals((int)COLLECTION_INSERT_STATEMENTS.size(), (int)SAMPLE_COLLECTIONS.size());
    }

    public void collectionSelectTest() throws Throwable {
        for (DataType dataType : COLLECTION_SELECT_STATEMENTS.keySet()) {
            String execute_string = COLLECTION_SELECT_STATEMENTS.get(dataType);
            Row row = session.execute(execute_string).one();
            HashMap sampleValueMap = (HashMap)SAMPLE_COLLECTIONS.get(dataType);
            DataType typeArgument1 = (DataType)dataType.getTypeArguments().get(0);
            if (dataType.getName() == DataType.Name.MAP) {
                DataType typeArgument2 = (DataType)dataType.getTypeArguments().get(1);
                HashMap sampleMap = (HashMap)sampleValueMap.get(typeArgument1);
                Object mapKey = SAMPLE_DATA.get(sampleMap.keySet().iterator().next());
                Object mapValue = sampleMap.values().iterator().next();
                HashMap expectedMap = new HashMap();
                expectedMap.put(mapKey, mapValue);
                Assert.assertEquals((Object)TestUtils.getValue(row, "k", typeArgument2), (Object)SAMPLE_DATA.get(typeArgument2));
                Assert.assertEquals((Object)TestUtils.getValue(row, "v", dataType), expectedMap);
                continue;
            }
            Object expectedValue = sampleValueMap.get(typeArgument1);
            Assert.assertEquals((Object)TestUtils.getValue(row, "k", typeArgument1), (Object)SAMPLE_DATA.get(typeArgument1));
            Assert.assertEquals((Object)TestUtils.getValue(row, "v", dataType), expectedValue);
        }
        Assert.assertEquals((int)SAMPLE_COLLECTIONS.size(), (int)255);
        Assert.assertEquals((int)COLLECTION_SELECT_STATEMENTS.keySet().size(), (int)SAMPLE_COLLECTIONS.size());
    }

    @Test(groups={"long"})
    public void collectionTest() throws Throwable {
        this.collectionInsertTest();
        this.collectionSelectTest();
    }

    @Test(groups={"doc"})
    public void printTableDefinitions() {
        String objective = "Table Definitions";
        System.out.println(String.format("Printing %s...", objective));
        for (String definition : this.getTableDefinitions()) {
            System.out.println(definition);
        }
        System.out.println(String.format("\nEnd of %s\n\n", objective));
    }

    @Test(groups={"doc"})
    public void printSampleData() {
        String objective = "Sample Data";
        System.out.println(String.format("Printing %s...", objective));
        for (DataType dataType : SAMPLE_DATA.keySet()) {
            Object sampleValue = SAMPLE_DATA.get(dataType);
            System.out.println(String.format("%1$-10s %2$s", dataType, sampleValue));
        }
        System.out.println(String.format("\nEnd of %s\n\n", objective));
    }

    @Test(groups={"doc"})
    public void printSampleCollections() {
        String objective = "Sample Collections";
        System.out.println(String.format("Printing %s...", objective));
        for (DataType dataType : SAMPLE_COLLECTIONS.keySet()) {
            DataType typeArgument;
            HashMap sampleValueMap = (HashMap)SAMPLE_COLLECTIONS.get(dataType);
            if (dataType.getName() == DataType.Name.MAP) {
                typeArgument = (DataType)sampleValueMap.keySet().iterator().next();
                HashMap sampleMap = (HashMap)sampleValueMap.get(typeArgument);
                Object mapKey = SAMPLE_DATA.get(typeArgument);
                Object mapValue = sampleMap.get(typeArgument);
                System.out.println(String.format("%1$-30s {%2$s : %3$s}", dataType, mapKey, mapValue));
                continue;
            }
            typeArgument = (DataType)sampleValueMap.keySet().iterator().next();
            Object sampleValue = sampleValueMap.get(typeArgument);
            System.out.println(String.format("%1$-30s %2$s", dataType, sampleValue));
        }
        System.out.println(String.format("\nEnd of %s\n\n", objective));
    }

    @Test(groups={"doc"})
    public void printPrimitiveInsertStatements() {
        String objective = "Primitive Insert Statements";
        System.out.println(String.format("Printing %s...", objective));
        for (String execute_string : PRIMITIVE_INSERT_STATEMENTS) {
            System.out.println(execute_string);
        }
        System.out.println(String.format("\nEnd of %s\n\n", objective));
    }

    @Test(groups={"doc"})
    public void printPrimitiveSelectStatements() {
        String objective = "Primitive Select Statements";
        System.out.println(String.format("Printing %s...", objective));
        for (String execute_string : PRIMITIVE_SELECT_STATEMENTS.values()) {
            System.out.println(execute_string);
        }
        System.out.println(String.format("\nEnd of %s\n\n", objective));
    }

    @Test(groups={"doc"})
    public void printCollectionInsertStatements() {
        String objective = "Collection Insert Statements";
        System.out.println(String.format("Printing %s...", objective));
        for (String execute_string : COLLECTION_INSERT_STATEMENTS) {
            System.out.println(execute_string);
        }
        System.out.println(String.format("\nEnd of %s\n\n", objective));
    }

    @Test(groups={"doc"})
    public void printCollectionSelectStatements() {
        String objective = "Collection Select Statements";
        System.out.println(String.format("Printing %s...", objective));
        for (String execute_string : COLLECTION_SELECT_STATEMENTS.values()) {
            System.out.println(execute_string);
        }
        System.out.println(String.format("\nEnd of %s\n\n", objective));
    }
}

