/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.utils.Bytes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataTypeTest {
    static boolean exclude(DataType t) {
        return t.getName() == DataType.Name.COUNTER;
    }

    private static String[] getCQLStringTestData(DataType dt) {
        switch (dt.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return new String[]{"'foo'", "'fo''o'"};
            }
            case BIGINT: 
            case TIMESTAMP: {
                return new String[]{"42", "91294377723", "-133"};
            }
            case BLOB: {
                return new String[]{"0x2450", "0x"};
            }
            case BOOLEAN: {
                return new String[]{"true", "false"};
            }
            case DECIMAL: {
                return new String[]{"1.23E+8"};
            }
            case DOUBLE: {
                return new String[]{"2.39324324", "-12.0"};
            }
            case FLOAT: {
                return new String[]{"2.39", "-12.0"};
            }
            case INET: {
                return new String[]{"128.2.12.3"};
            }
            case INT: {
                return new String[]{"-2", "42"};
            }
            case TIMEUUID: {
                return new String[]{"fe2b4360-28c6-11e2-81c1-0800200c9a66"};
            }
            case UUID: {
                return new String[]{"fe2b4360-28c6-11e2-81c1-0800200c9a66", "067e6162-3b6f-4ae2-a171-2470b63dff00"};
            }
            case VARINT: {
                return new String[]{"12387290982347987032483422342432"};
            }
        }
        throw new RuntimeException("Missing handling of " + dt);
    }

    private static Object[] getTestData(DataType dt) {
        switch (dt.getName()) {
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return new Object[]{"foo", "fo'o"};
            }
            case BIGINT: {
                return new Object[]{42L, 91294377723L, -133L};
            }
            case TIMESTAMP: {
                return new Object[]{new Date(42L), new Date(91294377723L), new Date(-133L)};
            }
            case BLOB: {
                return new Object[]{Bytes.fromHexString((String)"0x2450"), ByteBuffer.allocate(0)};
            }
            case BOOLEAN: {
                return new Object[]{true, false};
            }
            case DECIMAL: {
                return new Object[]{new BigDecimal("1.23E+8")};
            }
            case DOUBLE: {
                return new Object[]{2.39324324, -12.0};
            }
            case FLOAT: {
                return new Object[]{Float.valueOf(2.39f), Float.valueOf(-12.0f)};
            }
            case INET: {
                try {
                    return new Object[]{InetAddress.getByName("128.2.12.3")};
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException();
                }
            }
            case INT: {
                return new Object[]{-2, 42};
            }
            case TIMEUUID: {
                return new Object[]{UUID.fromString("FE2B4360-28C6-11E2-81C1-0800200C9A66")};
            }
            case UUID: {
                return new Object[]{UUID.fromString("FE2B4360-28C6-11E2-81C1-0800200C9A66"), UUID.fromString("067e6162-3b6f-4ae2-a171-2470b63dff00")};
            }
            case VARINT: {
                return new Object[]{new BigInteger("12387290982347987032483422342432")};
            }
        }
        throw new RuntimeException("Missing handling of " + dt);
    }

    @Test(groups={"unit"})
    public void parseNativeTest() {
        for (DataType dt : DataType.allPrimitiveTypes()) {
            if (DataTypeTest.exclude(dt)) continue;
            String[] s = DataTypeTest.getCQLStringTestData(dt);
            Object[] o = DataTypeTest.getTestData(dt);
            for (int i = 0; i < s.length; ++i) {
                Assert.assertEquals((Object)dt.parse(s[i]), (Object)o[i], (String)String.format("For input %d of %s, ", i, dt, s[i], o[i]));
            }
        }
    }

    @Test(groups={"unit"})
    public void formatNativeTest() {
        for (DataType dt : DataType.allPrimitiveTypes()) {
            if (DataTypeTest.exclude(dt)) continue;
            String[] s = DataTypeTest.getCQLStringTestData(dt);
            Object[] o = DataTypeTest.getTestData(dt);
            for (int i = 0; i < s.length; ++i) {
                Assert.assertEquals((String)dt.format(o[i]), (String)s[i], (String)String.format("For input %d of %s, ", i, dt, o[i], s[i]));
            }
        }
    }

    @Test(groups={"unit"})
    public void parseFormatListTest() {
        String toParse = "['Foo', 'Bar', 'Foo''bar']";
        List<String> toFormat = Arrays.asList("Foo", "Bar", "Foo'bar");
        DataType dt = DataType.list((DataType)DataType.text());
        Assert.assertEquals((Object)dt.parse(toParse), toFormat);
        Assert.assertEquals((String)dt.format(toFormat), (String)toParse);
    }

    @Test(groups={"unit"})
    public void parseFormatSetTest() {
        String toParse = "{'Foo', 'Bar', 'Foo''bar'}";
        LinkedHashSet<String> toFormat = new LinkedHashSet<String>(){
            {
                this.add("Foo");
                this.add("Bar");
                this.add("Foo'bar");
            }
        };
        DataType dt = DataType.set((DataType)DataType.text());
        Assert.assertEquals((Object)dt.parse(toParse), (Object)toFormat);
        Assert.assertEquals((String)dt.format((Object)toFormat), (String)toParse);
    }

    @Test(groups={"unit"})
    public void parseFormatMapTest() {
        String toParse = "{'Foo':3, 'Bar':42, 'Foo''bar':-24}";
        LinkedHashMap<String, Integer> toFormat = new LinkedHashMap<String, Integer>(){
            {
                this.put("Foo", 3);
                this.put("Bar", 42);
                this.put("Foo'bar", -24);
            }
        };
        DataType dt = DataType.map((DataType)DataType.text(), (DataType)DataType.cint());
        Assert.assertEquals((Object)dt.parse(toParse), (Object)toFormat);
        Assert.assertEquals((String)dt.format((Object)toFormat), (String)toParse);
    }

    @Test(groups={"unit"})
    public void parseFormatUDTTest() {
        String toParse = "{t:'fo''o', i:3, l:['a', 'b'], s:{3:{a:0x01}}}";
        final UserType udt1 = new UserType("ks", "t", Arrays.asList(new UserType.Field("a", DataType.blob())));
        UserType udt2 = new UserType("ks", "t", Arrays.asList(new UserType.Field("t", DataType.text()), new UserType.Field("i", DataType.cint()), new UserType.Field("l", DataType.list((DataType)DataType.text())), new UserType.Field("s", DataType.map((DataType)DataType.cint(), (DataType)udt1))));
        UDTValue toFormat = udt2.newValue();
        toFormat.setString("t", "fo'o");
        toFormat.setInt("i", 3);
        toFormat.setList("l", Arrays.asList("a", "b"));
        toFormat.setMap("s", (Map)new HashMap<Integer, UDTValue>(){
            {
                this.put(3, udt1.newValue().setBytes("a", ByteBuffer.wrap(new byte[]{1})));
            }
        });
        Assert.assertEquals((Object)udt2.parse(toParse), (Object)toFormat);
        Assert.assertEquals((String)udt2.format((Object)toFormat), (String)toParse);
    }

    @Test(groups={"unit"})
    public void parseFormatTupleTest() {
        String toParse = "(1, 'foo', 1.0)";
        TupleType t = TupleType.of((DataType[])new DataType[]{DataType.cint(), DataType.text(), DataType.cfloat()});
        TupleValue toFormat = t.newValue(new Object[]{1, "foo", Float.valueOf(1.0f)});
        Assert.assertEquals((Object)t.parse(toParse), (Object)toFormat);
        Assert.assertEquals((String)t.format((Object)toFormat), (String)toParse);
    }

    @Test(groups={"unit"})
    public void serializeDeserializeTest() {
        for (int v = 1; v <= 2; ++v) {
            this.serializeDeserializeTest(v);
        }
    }

    public void serializeDeserializeTest(int version) {
        for (DataType dt : DataType.allPrimitiveTypes()) {
            if (DataTypeTest.exclude(dt)) continue;
            Object value = TestUtils.getFixedValue(dt);
            Assert.assertEquals((Object)dt.deserialize(dt.serialize(value, version), version), (Object)value);
        }
        try {
            DataType.bigint().serialize((Object)4, version);
            Assert.fail((String)"This should not have worked");
        }
        catch (InvalidTypeException e) {
            // empty catch block
        }
        try {
            ByteBuffer badValue = ByteBuffer.allocate(4);
            DataType.bigint().deserialize(badValue, version);
            Assert.fail((String)"This should not have worked");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }

    @Test(groups={"unit"})
    public void serializeDeserializeCollectionsTest() {
        for (int v = 1; v <= 2; ++v) {
            this.serializeDeserializeCollectionsTest(v);
        }
    }

    public void serializeDeserializeCollectionsTest(int version) {
        List<String> l = Arrays.asList("foo", "bar");
        DataType dt = DataType.list((DataType)DataType.text());
        Assert.assertEquals((Object)dt.deserialize(dt.serialize(l, version), version), l);
        try {
            DataType.list((DataType)DataType.bigint()).serialize(l, version);
            Assert.fail((String)"This should not have worked");
        }
        catch (InvalidTypeException e) {
            // empty catch block
        }
    }
}

