/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExceptionsTest {
    @Test(groups={"short"})
    public void alreadyExistsException() throws Throwable {
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(1, builder);
        try {
            String keyspace = "TestKeyspace";
            String table = "TestTable";
            String[] cqlCommands = new String[]{String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace, 1), "USE " + keyspace, String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", table)};
            c.session.execute(cqlCommands[0]);
            c.session.execute(cqlCommands[1]);
            c.session.execute(cqlCommands[2]);
            try {
                c.session.execute(cqlCommands[0]);
            }
            catch (AlreadyExistsException e) {
                String expected = String.format("Keyspace %s already exists", keyspace.toLowerCase());
                Assert.assertEquals((String)e.getMessage(), (String)expected);
                Assert.assertEquals((String)e.getKeyspace(), (String)keyspace.toLowerCase());
                Assert.assertEquals((String)e.getTable(), null);
                Assert.assertEquals((boolean)e.wasTableCreation(), (boolean)false);
            }
            c.session.execute(cqlCommands[1]);
            try {
                c.session.execute(cqlCommands[2]);
            }
            catch (AlreadyExistsException e) {
                Assert.assertEquals((String)e.getKeyspace(), (String)keyspace.toLowerCase());
                Assert.assertEquals((String)e.getTable(), (String)table.toLowerCase());
                Assert.assertEquals((boolean)e.wasTableCreation(), (boolean)true);
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            c.discard();
        }
    }

    @Test(groups={"unit"})
    public void driverInternalError() throws Exception {
        String errorMessage = "Test Message";
        try {
            throw new DriverInternalError(errorMessage);
        }
        catch (DriverInternalError e1) {
            try {
                throw new DriverInternalError((Throwable)e1);
            }
            catch (DriverInternalError e2) {
                Assert.assertTrue((boolean)e2.getMessage().contains(errorMessage));
                DriverInternalError copy = (DriverInternalError)((Object)e2.copy());
                Assert.assertEquals((String)copy.getMessage(), (String)e2.getMessage());
                return;
            }
        }
    }

    @Test(groups={"unit"})
    public void invalidConfigurationInQueryException() throws Exception {
        String errorMessage = "Test Message";
        try {
            throw new InvalidConfigurationInQueryException(errorMessage);
        }
        catch (InvalidConfigurationInQueryException e) {
            Assert.assertEquals((String)e.getMessage(), (String)errorMessage);
            return;
        }
    }

    @Test(groups={"unit"})
    public void invalidQueryException() throws Exception {
        String errorMessage = "Test Message";
        try {
            throw new InvalidQueryException(errorMessage);
        }
        catch (InvalidQueryException e) {
            Assert.assertEquals((String)e.getMessage(), (String)errorMessage);
            InvalidQueryException copy = (InvalidQueryException)((Object)e.copy());
            Assert.assertEquals((String)copy.getMessage(), (String)e.getMessage());
            return;
        }
    }

    @Test(groups={"unit"})
    public void invalidTypeException() throws Exception {
        String errorMessage = "Test Message";
        try {
            throw new InvalidTypeException(errorMessage);
        }
        catch (InvalidTypeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)errorMessage);
            InvalidTypeException copy = (InvalidTypeException)((Object)e.copy());
            Assert.assertEquals((String)copy.getMessage(), (String)e.getMessage());
            return;
        }
    }

    @Test(groups={"short"})
    public void noHostAvailableException() throws Exception {
        try {
            Cluster.builder().addContactPoints(new String[]{"255.255.255.255"}).build();
        }
        catch (NoHostAvailableException e) {
            Assert.assertEquals((int)e.getErrors().size(), (int)1);
            Assert.assertTrue((boolean)((Throwable)e.getErrors().values().iterator().next()).toString().contains("[/255.255.255.255] Cannot connect"));
            NoHostAvailableException copy = (NoHostAvailableException)((Object)e.copy());
            Assert.assertEquals((String)copy.getMessage(), (String)e.getMessage());
            Assert.assertEquals((Map)copy.getErrors(), (Map)e.getErrors());
        }
    }

    @Test(groups={"long"})
    public void readTimeoutException() throws Throwable {
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            String keyspace = "TestKeyspace";
            String table = "TestTable";
            int replicationFactor = 3;
            String key = "1";
            c.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace, replicationFactor));
            c.session.execute("USE " + keyspace);
            c.session.execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", table));
            c.session.execute(new SimpleStatement(String.format("INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", table, key, "foo", 42, Float.valueOf(24.03f))).setConsistencyLevel(ConsistencyLevel.ALL));
            c.session.execute(new SimpleStatement(String.format("SELECT * FROM %s", table)).setConsistencyLevel(ConsistencyLevel.ALL));
            c.cassandraCluster.forceStop(2);
            try {
                c.session.execute(new SimpleStatement(String.format("SELECT * FROM %s", table)).setConsistencyLevel(ConsistencyLevel.ALL));
            }
            catch (ReadTimeoutException e) {
                Assert.assertEquals((Object)e.getConsistencyLevel(), (Object)ConsistencyLevel.ALL);
                Assert.assertEquals((int)e.getReceivedAcknowledgements(), (int)2);
                Assert.assertEquals((int)e.getRequiredAcknowledgements(), (int)3);
                Assert.assertEquals((boolean)e.wasDataRetrieved(), (boolean)true);
                ReadTimeoutException copy = (ReadTimeoutException)((Object)e.copy());
                Assert.assertEquals((String)copy.getMessage(), (String)e.getMessage());
                Assert.assertEquals((boolean)copy.wasDataRetrieved(), (boolean)e.wasDataRetrieved());
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            c.discard();
        }
    }

    @Test(groups={"unit"})
    public void syntaxError() throws Exception {
        String errorMessage = "Test Message";
        try {
            throw new SyntaxError(errorMessage);
        }
        catch (SyntaxError e) {
            Assert.assertEquals((String)e.getMessage(), (String)errorMessage);
            SyntaxError copy = (SyntaxError)((Object)e.copy());
            Assert.assertEquals((String)copy.getMessage(), (String)e.getMessage());
            return;
        }
    }

    @Test(groups={"unit"})
    public void traceRetrievalException() throws Exception {
        String errorMessage = "Test Message";
        try {
            throw new TraceRetrievalException(errorMessage);
        }
        catch (TraceRetrievalException e) {
            Assert.assertEquals((String)e.getMessage(), (String)errorMessage);
            TraceRetrievalException copy = (TraceRetrievalException)((Object)e.copy());
            Assert.assertEquals((String)copy.getMessage(), (String)e.getMessage());
            return;
        }
    }

    @Test(groups={"unit"})
    public void truncateException() throws Exception {
        String errorMessage = "Test Message";
        try {
            throw new TruncateException(errorMessage);
        }
        catch (TruncateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)errorMessage);
            TruncateException copy = (TruncateException)((Object)e.copy());
            Assert.assertEquals((String)copy.getMessage(), (String)e.getMessage());
            return;
        }
    }

    @Test(groups={"unit"})
    public void unauthorizedException() throws Exception {
        String errorMessage = "Test Message";
        try {
            throw new UnauthorizedException(errorMessage);
        }
        catch (UnauthorizedException e) {
            Assert.assertEquals((String)e.getMessage(), (String)errorMessage);
            UnauthorizedException copy = (UnauthorizedException)((Object)e.copy());
            Assert.assertEquals((String)copy.getMessage(), (String)e.getMessage());
            return;
        }
    }

    @Test(groups={"long"})
    public void unavailableException() throws Throwable {
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            String expectedError;
            String keyspace = "TestKeyspace";
            String table = "TestTable";
            int replicationFactor = 3;
            String key = "1";
            c.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace, replicationFactor));
            c.session.execute("USE " + keyspace);
            c.session.execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", table));
            c.session.execute(new SimpleStatement(String.format("INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", table, key, "foo", 42, Float.valueOf(24.03f))).setConsistencyLevel(ConsistencyLevel.ALL));
            c.session.execute(new SimpleStatement(String.format("SELECT * FROM %s", table)).setConsistencyLevel(ConsistencyLevel.ALL));
            c.cassandraCluster.stop(2);
            TestUtils.waitForDownWithWait(CCMBridge.IP_PREFIX + '2', c.cluster, 10);
            try {
                c.session.execute(new SimpleStatement(String.format("SELECT * FROM %s", table)).setConsistencyLevel(ConsistencyLevel.ALL));
            }
            catch (UnavailableException e) {
                expectedError = String.format("Not enough replica available for query at consistency %s (%d required but only %d alive)", "ALL", 3, 2);
                Assert.assertEquals((String)e.getMessage(), (String)expectedError);
                Assert.assertEquals((Object)e.getConsistencyLevel(), (Object)ConsistencyLevel.ALL);
                Assert.assertEquals((int)e.getRequiredReplicas(), (int)replicationFactor);
                Assert.assertEquals((int)e.getAliveReplicas(), (int)(replicationFactor - 1));
            }
            try {
                c.session.execute(new SimpleStatement(String.format("INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", table, key, "foo", 42, Float.valueOf(24.03f))).setConsistencyLevel(ConsistencyLevel.ALL));
            }
            catch (UnavailableException e) {
                expectedError = String.format("Not enough replica available for query at consistency %s (%d required but only %d alive)", "ALL", 3, 2);
                Assert.assertEquals((String)e.getMessage(), (String)expectedError);
                Assert.assertEquals((Object)e.getConsistencyLevel(), (Object)ConsistencyLevel.ALL);
                Assert.assertEquals((int)e.getRequiredReplicas(), (int)replicationFactor);
                Assert.assertEquals((int)e.getAliveReplicas(), (int)(replicationFactor - 1));
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void writeTimeoutException() throws Throwable {
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            String keyspace = "TestKeyspace";
            String table = "TestTable";
            int replicationFactor = 3;
            String key = "1";
            c.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace, replicationFactor));
            c.session.execute("USE " + keyspace);
            c.session.execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", table));
            c.session.execute(new SimpleStatement(String.format("INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", table, key, "foo", 42, Float.valueOf(24.03f))).setConsistencyLevel(ConsistencyLevel.ALL));
            c.session.execute(new SimpleStatement(String.format("SELECT * FROM %s", table)).setConsistencyLevel(ConsistencyLevel.ALL));
            c.cassandraCluster.forceStop(2);
            try {
                c.session.execute(new SimpleStatement(String.format("INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", table, key, "foo", 42, Float.valueOf(24.03f))).setConsistencyLevel(ConsistencyLevel.ALL));
            }
            catch (WriteTimeoutException e) {
                Assert.assertEquals((Object)e.getConsistencyLevel(), (Object)ConsistencyLevel.ALL);
                Assert.assertEquals((int)e.getReceivedAcknowledgements(), (int)2);
                Assert.assertEquals((int)e.getRequiredAcknowledgements(), (int)3);
                Assert.assertEquals((Object)e.getWriteType(), (Object)WriteType.SIMPLE);
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            c.discard();
        }
    }
}

