/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import java.util.Collection;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FetchingTest
extends CCMBridge.PerClassSingleNodeCluster {
    @Override
    protected Collection<String> getTableDefinitions() {
        return Collections.singletonList("CREATE TABLE test (k text, v int, PRIMARY KEY (k, v))");
    }

    @Test(groups={"short"})
    public void simplePagingTest() throws Throwable {
        try {
            String key = "paging_test";
            for (int i = 0; i < 100; ++i) {
                session.execute(String.format("INSERT INTO test (k, v) VALUES ('%s', %d)", key, i));
            }
            SimpleStatement st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", key));
            st.setFetchSize(5);
            ResultSet rs = session.execute((Statement)st);
            Assert.assertFalse((boolean)rs.isFullyFetched());
            for (int i = 0; i < 100; ++i) {
                Assert.assertFalse((boolean)rs.isExhausted());
                Assert.assertEquals((int)rs.getAvailableWithoutFetching(), (int)(5 - i % 5));
                Assert.assertEquals((int)rs.one().getInt(0), (int)i);
            }
            Assert.assertTrue((boolean)rs.isExhausted());
            Assert.assertTrue((boolean)rs.isFullyFetched());
        }
        catch (UnsupportedFeatureException e) {
            if (cluster.getConfiguration().getProtocolOptions().getProtocolVersion() != 1) {
                throw e;
            }
        }
        catch (Throwable e) {
            this.errorOut();
            throw e;
        }
    }
}

