/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.nio.ByteBuffer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LargeDataTest {
    private void testWideRows(CCMBridge.CCMCluster c, int key) throws Throwable {
        for (int i = 0; i < 1000000; ++i) {
            c.session.execute(QueryBuilder.insertInto((String)"wide_rows").value("k", (Object)key).value("i", (Object)i).setConsistencyLevel(ConsistencyLevel.QUORUM));
        }
        ResultSet rs = c.session.execute((Statement)QueryBuilder.select((String[])new String[]{"i"}).from("wide_rows").where(QueryBuilder.eq((String)"k", (Object)key)));
        int i = 0;
        for (Row row : rs) {
            Assert.assertTrue((row.getInt("i") == i++ ? 1 : 0) != 0);
        }
    }

    private void testWideBatchRows(CCMBridge.CCMCluster c, int key) throws Throwable {
        Batch q = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]);
        for (int i = 0; i < 10000; ++i) {
            q = q.add((RegularStatement)QueryBuilder.insertInto((String)"wide_batch_rows").value("k", (Object)key).value("i", (Object)i));
        }
        c.session.execute(q.setConsistencyLevel(ConsistencyLevel.QUORUM));
        ResultSet rs = c.session.execute((Statement)QueryBuilder.select((String[])new String[]{"i"}).from("wide_batch_rows").where(QueryBuilder.eq((String)"k", (Object)key)));
        int i = 0;
        for (Row row : rs) {
            Assert.assertTrue((row.getInt("i") == i++ ? 1 : 0) != 0);
        }
    }

    private void testByteRows(CCMBridge.CCMCluster c, int key) throws Throwable {
        ByteBuffer bb = ByteBuffer.allocate(58);
        bb.putShort((short)-13570);
        bb.flip();
        for (int i = 0; i < 1000000; ++i) {
            c.session.execute(QueryBuilder.insertInto((String)"wide_byte_rows").value("k", (Object)key).value("i", (Object)bb).setConsistencyLevel(ConsistencyLevel.QUORUM));
        }
        ResultSet rs = c.session.execute((Statement)QueryBuilder.select((String[])new String[]{"i"}).from("wide_byte_rows").where(QueryBuilder.eq((String)"k", (Object)key)));
        for (Row row : rs) {
            Assert.assertEquals((Object)row.getBytes("i"), (Object)bb);
        }
    }

    private void testLargeText(CCMBridge.CCMCluster c, int key) throws Throwable {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 1000000; ++i) {
            b.append(i);
        }
        c.session.execute(QueryBuilder.insertInto((String)"large_text").value("k", (Object)key).value("txt", (Object)b.toString()).setConsistencyLevel(ConsistencyLevel.QUORUM));
        Row row = c.session.execute((Statement)QueryBuilder.select().all().from("large_text").where(QueryBuilder.eq((String)"k", (Object)key))).one();
        Assert.assertTrue((boolean)b.toString().equals(row.getString("txt")));
    }

    private static String createColumnName(int i) {
        String[] letters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
        int currentI = i;
        StringBuilder columnName = new StringBuilder();
        do {
            columnName.append(letters[currentI % 10]);
        } while ((currentI /= 10) != 0);
        return columnName.toString();
    }

    private void testWideTable(CCMBridge.CCMCluster c, int key) throws Throwable {
        Insert insertStatement = QueryBuilder.insertInto((String)"wide_table").value("k", (Object)key);
        for (int i = 0; i < 330; ++i) {
            insertStatement = insertStatement.value(LargeDataTest.createColumnName(i), (Object)i);
        }
        c.session.execute(insertStatement.setConsistencyLevel(ConsistencyLevel.QUORUM));
        Row row = c.session.execute((Statement)QueryBuilder.select().all().from("wide_table").where(QueryBuilder.eq((String)"k", (Object)key))).one();
        for (int i = 0; i < 330; ++i) {
            Assert.assertTrue((row.getInt(LargeDataTest.createColumnName(i)) == i ? 1 : 0) != 0);
        }
    }

    @Test(groups={"integration"})
    public void wideRows() throws Throwable {
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(1, builder);
        c.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        c.session.execute("USE large_data");
        c.session.execute(String.format("CREATE TABLE %s (k INT, i INT, PRIMARY KEY(k, i))", "wide_rows"));
        try {
            this.testWideRows(c, 0);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }

    @Test(groups={"integration"})
    public void wideBatchRows() throws Throwable {
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(1, builder);
        c.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        c.session.execute("USE large_data");
        c.session.execute(String.format("CREATE TABLE %s (k INT, i INT, PRIMARY KEY(k, i))", "wide_batch_rows"));
        try {
            this.testWideBatchRows(c, 0);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }

    @Test(groups={"integration"})
    public void wideByteRows() throws Throwable {
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(1, builder);
        c.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        c.session.execute("USE large_data");
        c.session.execute(String.format("CREATE TABLE %s (k INT, i BLOB, PRIMARY KEY(k, i))", "wide_byte_rows"));
        try {
            this.testByteRows(c, 0);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }

    @Test(groups={"integration"})
    public void largeText() throws Throwable {
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(1, builder);
        c.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        c.session.execute("USE large_data");
        c.session.execute(String.format("CREATE TABLE %s (k int PRIMARY KEY, txt text)", "large_text"));
        try {
            this.testLargeText(c, 0);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }

    @Test(groups={"integration"})
    public void wideTable() throws Throwable {
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(1, builder);
        c.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 1));
        c.session.execute("USE large_data");
        StringBuilder tableDeclaration = new StringBuilder();
        tableDeclaration.append("CREATE TABLE wide_table (");
        tableDeclaration.append("k INT PRIMARY KEY");
        for (int i = 0; i < 330; ++i) {
            tableDeclaration.append(String.format(", %s INT", LargeDataTest.createColumnName(i)));
        }
        tableDeclaration.append(')');
        c.session.execute(tableDeclaration.toString());
        try {
            this.testWideTable(c, 0);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }

    @Test(groups={"duration"})
    public void mixedDurationTest() throws Throwable {
        int i;
        Cluster.Builder builder = Cluster.builder();
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        c.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "large_data", 3));
        c.session.execute("USE large_data");
        c.session.execute(String.format("CREATE TABLE %s (k INT, i INT, PRIMARY KEY(k, i))", "wide_rows"));
        c.session.execute(String.format("CREATE TABLE %s (k INT, i INT, PRIMARY KEY(k, i))", "wide_batch_rows"));
        c.session.execute(String.format("CREATE TABLE %s (k INT, i BLOB, PRIMARY KEY(k, i))", "wide_byte_rows"));
        c.session.execute(String.format("CREATE TABLE %s (k int PRIMARY KEY, txt text)", "large_text"));
        StringBuilder tableDeclaration = new StringBuilder();
        tableDeclaration.append("CREATE TABLE wide_table (");
        tableDeclaration.append("k INT PRIMARY KEY");
        for (i = 0; i < 330; ++i) {
            tableDeclaration.append(String.format(", %s INT", LargeDataTest.createColumnName(i)));
        }
        tableDeclaration.append(')');
        c.session.execute(tableDeclaration.toString());
        try {
            block13: for (i = 0; i < 10; ++i) {
                switch ((int)(Math.random() * 5.0)) {
                    case 0: {
                        this.testWideRows(c, 0);
                        continue block13;
                    }
                    case 1: {
                        this.testWideBatchRows(c, 0);
                        continue block13;
                    }
                    case 2: {
                        this.testByteRows(c, 0);
                        continue block13;
                    }
                    case 3: {
                        this.testLargeText(c, 0);
                        continue block13;
                    }
                    case 4: {
                        this.testWideTable(c, 0);
                        continue block13;
                    }
                }
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }
}

