/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class LoadBalancingPolicyBootstrapTest {
    CountingPolicy policy;
    CCMBridge.CCMCluster c;

    @BeforeClass(groups={"short"})
    private void setup() {
        this.policy = new CountingPolicy((LoadBalancingPolicy)new RoundRobinPolicy());
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)this.policy);
        this.c = CCMBridge.buildCluster(2, builder);
    }

    @Test(groups={"short"})
    public void notificationsTest() throws Exception {
        Assert.assertEquals((int)this.policy.adds, (int)2, (String)("adds\n" + this.policy.history));
        Assert.assertEquals((int)this.policy.suspecteds, (int)0, (String)("suspecteds\n" + this.policy.history));
        Assert.assertEquals((int)this.policy.removes, (int)0, (String)("removes\n" + this.policy.history));
        Assert.assertEquals((int)this.policy.ups, (int)0, (String)("ups\n" + this.policy.history));
        Assert.assertEquals((int)this.policy.downs, (int)0, (String)("downs\n" + this.policy.history));
    }

    @AfterClass(groups={"short"})
    private void tearDown() {
        this.c.discard();
    }

    static class CountingPolicy
    implements LoadBalancingPolicy {
        private final LoadBalancingPolicy delegate;
        int adds;
        int suspecteds;
        int removes;
        int ups;
        int downs;
        final StringWriter history = new StringWriter();
        private final PrintWriter out = new PrintWriter(this.history);

        CountingPolicy(LoadBalancingPolicy delegate) {
            this.delegate = delegate;
        }

        public void onAdd(Host host) {
            this.out.printf("add %s%n", host);
            ++this.adds;
            this.delegate.onAdd(host);
        }

        public void onSuspected(Host host) {
            this.out.printf("suspect %s%n", host);
            ++this.suspecteds;
            this.delegate.onSuspected(host);
        }

        public void onUp(Host host) {
            this.out.printf("up %s%n", host);
            ++this.ups;
            this.delegate.onUp(host);
        }

        public void onDown(Host host) {
            this.out.printf("down %s%n", host);
            ++this.downs;
            this.delegate.onDown(host);
        }

        public void onRemove(Host host) {
            this.out.printf("remove %s%n", host);
            ++this.removes;
            this.delegate.onRemove(host);
        }

        public void init(Cluster cluster, Collection<Host> hosts) {
            this.delegate.init(cluster, hosts);
        }

        public HostDistance distance(Host host) {
            return this.delegate.distance(host);
        }

        public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
            return this.delegate.newQueryPlan(loggedKeyspace, statement);
        }
    }
}

