/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.Iterators;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LoadBalancingPolicyRefreshTest {
    @Test(groups={"short"})
    public void refreshTest() throws Throwable {
        UpdatablePolicy policy = new UpdatablePolicy();
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)policy);
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, builder);
        try {
            Session s = c.session;
            Host[] hosts = new Host[2];
            for (Host h : c.cluster.getMetadata().getAllHosts()) {
                if (h.getAddress().equals(InetAddress.getByName(CCMBridge.IP_PREFIX + '1'))) {
                    hosts[0] = h;
                    continue;
                }
                hosts[1] = h;
            }
            Assert.assertTrue((boolean)s.getState().getConnectedHosts().contains(hosts[0]), (String)("Connected hosts: " + s.getState().getConnectedHosts()));
            Assert.assertTrue((!s.getState().getConnectedHosts().contains(hosts[1]) ? 1 : 0) != 0, (String)("Connected hosts: " + s.getState().getConnectedHosts()));
            policy.changeTheHost(hosts[1]);
            Assert.assertTrue((!s.getState().getConnectedHosts().contains(hosts[0]) ? 1 : 0) != 0, (String)("Connected hosts: " + s.getState().getConnectedHosts()));
            Assert.assertTrue((boolean)s.getState().getConnectedHosts().contains(hosts[1]), (String)("Connected hosts: " + s.getState().getConnectedHosts()));
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }

    private static class UpdatablePolicy
    implements LoadBalancingPolicy {
        private Cluster cluster;
        private Host theHost;

        private UpdatablePolicy() {
        }

        public void changeTheHost(Host theNewHost) {
            this.theHost = theNewHost;
            this.cluster.getConfiguration().getPoolingOptions().refreshConnectedHosts();
        }

        public void init(Cluster cluster, Collection<Host> hosts) {
            this.cluster = cluster;
            try {
                for (Host h : hosts) {
                    if (!h.getAddress().equals(InetAddress.getByName(CCMBridge.IP_PREFIX + '1'))) continue;
                    this.theHost = h;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public HostDistance distance(Host host) {
            return host == this.theHost ? HostDistance.LOCAL : HostDistance.IGNORED;
        }

        public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
            return Iterators.singletonIterator((Object)this.theHost);
        }

        public void onAdd(Host h) {
        }

        public void onRemove(Host h) {
        }

        public void onUp(Host h) {
        }

        public void onDown(Host h) {
        }

        public void onSuspected(Host h) {
        }
    }
}

