/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractPoliciesTest;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LoadBalancingPolicyTest
extends AbstractPoliciesTest {
    @Test(groups={"long"})
    public void roundRobinTest() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy());
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, builder);
        try {
            LoadBalancingPolicyTest.createSchema(c.session);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 6);
            this.resetCoordinators();
            c.cassandraCluster.bootstrapNode(3);
            TestUtils.waitFor(CCMBridge.IP_PREFIX + '3', c.cluster);
            Thread.sleep(50000L);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 4);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 4);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 4);
            this.resetCoordinators();
            c.cassandraCluster.decommissionNode(1);
            TestUtils.waitForDecommission(CCMBridge.IP_PREFIX + '1', c.cluster);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 6);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void whiteListPolicyTest() throws Throwable {
        List<InetSocketAddress> whiteList = Arrays.asList(new InetSocketAddress(InetAddress.getByName(CCMBridge.IP_PREFIX + '2'), 9042));
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new WhiteListPolicy((LoadBalancingPolicy)new RoundRobinPolicy(), whiteList));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            LoadBalancingPolicyTest.createSchema(c.session);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + "1", 0);
            this.assertQueried(CCMBridge.IP_PREFIX + "2", 12);
            this.assertQueried(CCMBridge.IP_PREFIX + "3", 0);
            this.resetCoordinators();
            c.cassandraCluster.decommissionNode(2);
            TestUtils.waitForDecommission(CCMBridge.IP_PREFIX + "2", c.cluster);
            try {
                this.query(c, 12);
                Assert.fail((String)"Should work, we've only whitelisted node 2 and it's been removed");
            }
            catch (NoHostAvailableException e) {
                // empty catch block
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void roundRobinWith2DCsTest() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy());
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, 2, builder);
        try {
            LoadBalancingPolicyTest.createSchema(c.session);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 3);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 3);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 3);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 3);
            this.resetCoordinators();
            c.cassandraCluster.bootstrapNode(5, "dc2");
            c.cassandraCluster.decommissionNode(1);
            TestUtils.waitFor(CCMBridge.IP_PREFIX + '5', c.cluster);
            TestUtils.waitForDecommission(CCMBridge.IP_PREFIX + '1', c.cluster);
            Thread.sleep(50000L);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 3);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 3);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 3);
            this.assertQueried(CCMBridge.IP_PREFIX + '5', 3);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void DCAwareRoundRobinTest() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new DCAwareRoundRobinPolicy("dc2"));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, 2, builder);
        try {
            LoadBalancingPolicyTest.createMultiDCSchema(c.session);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 6);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void DCAwareRoundRobinTest2() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new DCAwareRoundRobinPolicy("dc1"));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, 2, builder);
        try {
            LoadBalancingPolicyTest.createMultiDCSchema(c.session);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 0);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void dcAwareRoundRobinTestWithOneRemoteHost() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new DCAwareRoundRobinPolicy("dc2", 1));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, 2, builder);
        try {
            LoadBalancingPolicyTest.createMultiDCSchema(c.session);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '5', 0);
            this.resetCoordinators();
            c.cassandraCluster.bootstrapNode(5, "dc3");
            TestUtils.waitFor(CCMBridge.IP_PREFIX + '5', c.cluster);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '5', 0);
            this.resetCoordinators();
            c.cassandraCluster.decommissionNode(3);
            c.cassandraCluster.decommissionNode(4);
            TestUtils.waitForDecommission(CCMBridge.IP_PREFIX + '3', c.cluster);
            TestUtils.waitForDecommission(CCMBridge.IP_PREFIX + '4', c.cluster);
            c.cassandraCluster.decommissionNode(5);
            TestUtils.waitForDecommission(CCMBridge.IP_PREFIX + '5', c.cluster, 120);
            this.query(c, 12);
            this.assertOneNodeQueried(12, CCMBridge.IP_PREFIX + '1', CCMBridge.IP_PREFIX + '2', CCMBridge.IP_PREFIX + '3');
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '5', 0);
            this.resetCoordinators();
            c.cassandraCluster.decommissionNode(1);
            TestUtils.waitForDecommission(CCMBridge.IP_PREFIX + '1', c.cluster);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '4', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '5', 0);
            this.resetCoordinators();
            c.cassandraCluster.forceStop(2);
            TestUtils.waitForDown(CCMBridge.IP_PREFIX + '2', c.cluster);
            try {
                this.query(c, 12);
                Assert.fail();
            }
            catch (NoHostAvailableException e) {
                // empty catch block
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void tokenAwareTest() throws Throwable {
        this.tokenAwareTest(false);
    }

    @Test(groups={"long"})
    public void tokenAwarePreparedTest() throws Throwable {
        this.tokenAwareTest(true);
    }

    @Test(groups={"long"})
    public void tokenAwareCompositeKeyTest() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy()));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, builder);
        Session session = c.session;
        try {
            String COMPOSITE_TABLE = "composite";
            session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", "ks", 2));
            session.execute("USE ks");
            session.execute(String.format("CREATE TABLE %s (k1 int, k2 int, i int, PRIMARY KEY ((k1, k2)))", COMPOSITE_TABLE));
            PreparedStatement ps = session.prepare("INSERT INTO " + COMPOSITE_TABLE + "(k1, k2, i) VALUES (?, ?, ?)");
            session.execute((Statement)ps.bind(new Object[]{1, 2, 3}));
            ResultSet rs = session.execute("SELECT * FROM " + COMPOSITE_TABLE + " WHERE k1 = 1 AND k2 = 2");
            Assert.assertTrue((!rs.isExhausted() ? 1 : 0) != 0);
            Row r = rs.one();
            Assert.assertTrue((boolean)rs.isExhausted());
            Assert.assertEquals((int)r.getInt("i"), (int)3);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }

    public void tokenAwareTest(boolean usePrepared) throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy()));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            LoadBalancingPolicyTest.createSchema(c.session);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.resetCoordinators();
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.resetCoordinators();
            c.cassandraCluster.stop(2);
            TestUtils.waitForDownWithWait(CCMBridge.IP_PREFIX + '2', c.cluster, 10);
            try {
                this.query(c, 12, usePrepared);
                Assert.fail();
            }
            catch (ReadTimeoutException e) {
                Assert.assertEquals((int)1, (int)e.getRequiredAcknowledgements());
                Assert.assertEquals((int)0, (int)e.getReceivedAcknowledgements());
            }
            catch (UnavailableException e) {
                Assert.assertEquals((int)1, (int)e.getRequiredReplicas());
                Assert.assertEquals((int)0, (int)e.getAliveReplicas());
            }
            this.resetCoordinators();
            c.cassandraCluster.start(2);
            TestUtils.waitFor(CCMBridge.IP_PREFIX + '2', c.cluster);
            Thread.sleep(2000L);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
            this.resetCoordinators();
            c.cassandraCluster.decommissionNode(2);
            TestUtils.waitForDecommission(CCMBridge.IP_PREFIX + '2', c.cluster);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 12);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void tokenAwareWithRF2Test() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new RoundRobinPolicy()));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, builder);
        try {
            LoadBalancingPolicyTest.createSchema(c.session, 2);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 0);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }
}

