/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractReplicationStrategyTest;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ReplicationStrategy;
import com.datastax.driver.core.Token;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class NetworkTopologyStrategyTest
extends AbstractReplicationStrategyTest {
    private static final String DC1 = "DC1";
    private static final String DC2 = "DC2";
    private static final String DC3 = "DC3";
    private static final String RACK11 = "RACK11";
    private static final String RACK12 = "RACK12";
    private static final String RACK21 = "RACK21";
    private static final String RACK22 = "RACK22";
    private static final String RACK31 = "RACK31";
    private static final Token TOKEN01 = NetworkTopologyStrategyTest.token("-9000000000000000000");
    private static final Token TOKEN02 = NetworkTopologyStrategyTest.token("-8000000000000000000");
    private static final Token TOKEN03 = NetworkTopologyStrategyTest.token("-7000000000000000000");
    private static final Token TOKEN04 = NetworkTopologyStrategyTest.token("-6000000000000000000");
    private static final Token TOKEN05 = NetworkTopologyStrategyTest.token("-5000000000000000000");
    private static final Token TOKEN06 = NetworkTopologyStrategyTest.token("-4000000000000000000");
    private static final Token TOKEN07 = NetworkTopologyStrategyTest.token("-3000000000000000000");
    private static final Token TOKEN08 = NetworkTopologyStrategyTest.token("-2000000000000000000");
    private static final Token TOKEN09 = NetworkTopologyStrategyTest.token("-1000000000000000000");
    private static final Token TOKEN10 = NetworkTopologyStrategyTest.token("0");
    private static final Token TOKEN11 = NetworkTopologyStrategyTest.token("1000000000000000000");
    private static final Token TOKEN12 = NetworkTopologyStrategyTest.token("2000000000000000000");
    private static final Token TOKEN13 = NetworkTopologyStrategyTest.token("3000000000000000000");
    private static final Token TOKEN14 = NetworkTopologyStrategyTest.token("4000000000000000000");
    private static final Token TOKEN15 = NetworkTopologyStrategyTest.token("5000000000000000000");
    private static final Token TOKEN16 = NetworkTopologyStrategyTest.token("6000000000000000000");
    private static final Token TOKEN17 = NetworkTopologyStrategyTest.token("7000000000000000000");
    private static final Token TOKEN18 = NetworkTopologyStrategyTest.token("8000000000000000000");
    private static final Token TOKEN19 = NetworkTopologyStrategyTest.token("9000000000000000000");
    private static final String IP1 = "127.0.0.101";
    private static final String IP2 = "127.0.0.102";
    private static final String IP3 = "127.0.0.103";
    private static final String IP4 = "127.0.0.104";
    private static final String IP5 = "127.0.0.105";
    private static final String IP6 = "127.0.0.106";
    private static final String IP7 = "127.0.0.107";
    private static final String IP8 = "127.0.0.108";
    private static final ReplicationStrategy exampleStrategy = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf("DC1", 2), NetworkTopologyStrategyTest.rf("DC2", 2));
    private static final ReplicationStrategy exampleStrategyTooManyReplicas = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf("DC1", 4), NetworkTopologyStrategyTest.rf("DC2", 4));
    private static final List<Token> exampleRing = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN02).add((Object)TOKEN03).add((Object)TOKEN04).add((Object)TOKEN05).add((Object)TOKEN06).add((Object)TOKEN07).add((Object)TOKEN08).add((Object)TOKEN09).add((Object)TOKEN10).add((Object)TOKEN11).add((Object)TOKEN12).add((Object)TOKEN13).add((Object)TOKEN14).add((Object)TOKEN15).add((Object)TOKEN16).add((Object)TOKEN17).add((Object)TOKEN18).build();
    private static final Map<Token, Host> exampleTokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)NetworkTopologyStrategyTest.host("127.0.0.101", "DC1", "RACK11")).put((Object)TOKEN02, (Object)NetworkTopologyStrategyTest.host("127.0.0.101", "DC1", "RACK11")).put((Object)TOKEN03, (Object)NetworkTopologyStrategyTest.host("127.0.0.105", "DC1", "RACK12")).put((Object)TOKEN04, (Object)NetworkTopologyStrategyTest.host("127.0.0.103", "DC1", "RACK11")).put((Object)TOKEN05, (Object)NetworkTopologyStrategyTest.host("127.0.0.101", "DC1", "RACK11")).put((Object)TOKEN06, (Object)NetworkTopologyStrategyTest.host("127.0.0.105", "DC1", "RACK12")).put((Object)TOKEN07, (Object)NetworkTopologyStrategyTest.host("127.0.0.102", "DC2", "RACK21")).put((Object)TOKEN08, (Object)NetworkTopologyStrategyTest.host("127.0.0.106", "DC2", "RACK22")).put((Object)TOKEN09, (Object)NetworkTopologyStrategyTest.host("127.0.0.103", "DC1", "RACK11")).put((Object)TOKEN10, (Object)NetworkTopologyStrategyTest.host("127.0.0.104", "DC2", "RACK21")).put((Object)TOKEN11, (Object)NetworkTopologyStrategyTest.host("127.0.0.105", "DC1", "RACK12")).put((Object)TOKEN12, (Object)NetworkTopologyStrategyTest.host("127.0.0.104", "DC2", "RACK21")).put((Object)TOKEN13, (Object)NetworkTopologyStrategyTest.host("127.0.0.104", "DC2", "RACK21")).put((Object)TOKEN14, (Object)NetworkTopologyStrategyTest.host("127.0.0.102", "DC2", "RACK21")).put((Object)TOKEN15, (Object)NetworkTopologyStrategyTest.host("127.0.0.106", "DC2", "RACK22")).put((Object)TOKEN16, (Object)NetworkTopologyStrategyTest.host("127.0.0.103", "DC1", "RACK11")).put((Object)TOKEN17, (Object)NetworkTopologyStrategyTest.host("127.0.0.102", "DC2", "RACK21")).put((Object)TOKEN18, (Object)NetworkTopologyStrategyTest.host("127.0.0.106", "DC2", "RACK22")).build();

    private static ReplicationFactorDefinition rf(String dc, int replicationFactor) {
        return new ReplicationFactorDefinition(dc, replicationFactor);
    }

    private static ReplicationStrategy networkTopologyStrategy(ReplicationFactorDefinition ... rfs) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"class", (Object)"NetworkTopologyStrategy");
        for (ReplicationFactorDefinition rf : rfs) {
            builder.put((Object)rf.dc, (Object)String.valueOf(rf.replicationFactor));
        }
        return ReplicationStrategy.create((Map)builder.build());
    }

    @Test(groups={"unit"})
    public void networkTopologyWithSimpleDCLayoutTest1() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN04).add((Object)TOKEN14).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN04, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN14, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN19, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).build();
        ReplicationStrategy strategy = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf(DC1, 1), NetworkTopologyStrategyTest.rf(DC2, 1));
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN04, IP2, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP1, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP2, IP1);
    }

    @Test(groups={"unit"})
    public void networkTopologyWithSimpleDCLayoutTest2() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN03).add((Object)TOKEN05).add((Object)TOKEN07).add((Object)TOKEN13).add((Object)TOKEN15).add((Object)TOKEN17).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN03, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN05, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN07, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).put((Object)TOKEN13, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN15, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN17, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN19, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).build();
        ReplicationStrategy strategy = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf(DC1, 1), NetworkTopologyStrategyTest.rf(DC2, 1));
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP2, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP4, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP1, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP2, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP4, IP1);
    }

    @Test(groups={"unit"})
    public void networkTopologyWithSimple3DCLayoutTest() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN05).add((Object)TOKEN09).add((Object)TOKEN11).add((Object)TOKEN15).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN05, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN09, (Object)NetworkTopologyStrategyTest.host(IP3, DC3, RACK31)).put((Object)TOKEN11, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN15, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN19, (Object)NetworkTopologyStrategyTest.host(IP3, DC3, RACK31)).build();
        ReplicationStrategy strategy = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf(DC1, 1), NetworkTopologyStrategyTest.rf(DC2, 1), NetworkTopologyStrategyTest.rf(DC3, 1));
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP2, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP2, IP3, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN09, IP3, IP1, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN11, IP1, IP2, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP2, IP3, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP3, IP1, IP2);
    }

    @Test(groups={"unit"})
    public void networkTopologyWithUnbalancedRingTest() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN03).add((Object)TOKEN05).add((Object)TOKEN07).add((Object)TOKEN09).add((Object)TOKEN11).add((Object)TOKEN13).add((Object)TOKEN15).add((Object)TOKEN17).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN03, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN05, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN07, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN09, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).put((Object)TOKEN11, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN13, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN15, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN17, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN19, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).build();
        ReplicationStrategy strategy = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf(DC1, 2), NetworkTopologyStrategyTest.rf(DC2, 2));
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP2, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP1, IP2, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP2, IP3, IP4, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP3, IP4, IP1, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN09, IP4, IP1, IP2, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN11, IP1, IP2, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP1, IP2, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP2, IP3, IP4, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP3, IP4, IP1, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP4, IP1, IP2, IP3);
    }

    @Test(groups={"unit"})
    public void networkTopologyWithDCMultirackLayoutTest() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN02).add((Object)TOKEN03).add((Object)TOKEN04).add((Object)TOKEN05).add((Object)TOKEN06).add((Object)TOKEN07).add((Object)TOKEN08).add((Object)TOKEN12).add((Object)TOKEN13).add((Object)TOKEN14).add((Object)TOKEN15).add((Object)TOKEN16).add((Object)TOKEN17).add((Object)TOKEN18).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN02, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN03, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK12)).put((Object)TOKEN04, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK22)).put((Object)TOKEN05, (Object)NetworkTopologyStrategyTest.host(IP5, DC1, RACK11)).put((Object)TOKEN06, (Object)NetworkTopologyStrategyTest.host(IP6, DC2, RACK21)).put((Object)TOKEN07, (Object)NetworkTopologyStrategyTest.host(IP7, DC1, RACK12)).put((Object)TOKEN08, (Object)NetworkTopologyStrategyTest.host(IP8, DC2, RACK22)).put((Object)TOKEN12, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN13, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN14, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK12)).put((Object)TOKEN15, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK22)).put((Object)TOKEN16, (Object)NetworkTopologyStrategyTest.host(IP5, DC1, RACK11)).put((Object)TOKEN17, (Object)NetworkTopologyStrategyTest.host(IP6, DC2, RACK21)).put((Object)TOKEN18, (Object)NetworkTopologyStrategyTest.host(IP7, DC1, RACK12)).put((Object)TOKEN19, (Object)NetworkTopologyStrategyTest.host(IP8, DC2, RACK22)).build();
        ReplicationStrategy strategy = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf(DC1, 2), NetworkTopologyStrategyTest.rf(DC2, 2));
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP2, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN02, IP2, IP3, IP4, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP3, IP4, IP5, IP6);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN04, IP4, IP5, IP6, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP5, IP6, IP7, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP6, IP7, IP8, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP7, IP8, IP1, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN08, IP8, IP1, IP2, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN12, IP1, IP2, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP2, IP3, IP4, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP3, IP4, IP5, IP6);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP4, IP5, IP6, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN16, IP5, IP6, IP7, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP6, IP7, IP8, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN18, IP7, IP8, IP1, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP8, IP1, IP2, IP3);
    }

    @Test(groups={"unit"})
    public void networkTopologyWithMultirackHostSkippingTest1() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN02).add((Object)TOKEN03).add((Object)TOKEN04).add((Object)TOKEN05).add((Object)TOKEN06).add((Object)TOKEN07).add((Object)TOKEN08).add((Object)TOKEN12).add((Object)TOKEN13).add((Object)TOKEN14).add((Object)TOKEN15).add((Object)TOKEN16).add((Object)TOKEN17).add((Object)TOKEN18).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN02, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN03, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN04, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).put((Object)TOKEN05, (Object)NetworkTopologyStrategyTest.host(IP5, DC1, RACK12)).put((Object)TOKEN06, (Object)NetworkTopologyStrategyTest.host(IP6, DC2, RACK22)).put((Object)TOKEN07, (Object)NetworkTopologyStrategyTest.host(IP7, DC1, RACK12)).put((Object)TOKEN08, (Object)NetworkTopologyStrategyTest.host(IP8, DC2, RACK22)).put((Object)TOKEN12, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN13, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN14, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN15, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).put((Object)TOKEN16, (Object)NetworkTopologyStrategyTest.host(IP5, DC1, RACK12)).put((Object)TOKEN17, (Object)NetworkTopologyStrategyTest.host(IP6, DC2, RACK22)).put((Object)TOKEN18, (Object)NetworkTopologyStrategyTest.host(IP7, DC1, RACK12)).put((Object)TOKEN19, (Object)NetworkTopologyStrategyTest.host(IP8, DC2, RACK22)).build();
        ReplicationStrategy strategy = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf(DC1, 3), NetworkTopologyStrategyTest.rf(DC2, 3));
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP2, IP5, IP3, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN02, IP2, IP3, IP5, IP6, IP4, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP3, IP4, IP5, IP6, IP7, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN04, IP4, IP5, IP6, IP8, IP1, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP5, IP6, IP1, IP7, IP2, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP6, IP7, IP1, IP2, IP8, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP7, IP8, IP1, IP2, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN08, IP8, IP1, IP2, IP4, IP5, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN12, IP1, IP2, IP5, IP3, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP2, IP3, IP5, IP6, IP4, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP3, IP4, IP5, IP6, IP7, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP4, IP5, IP6, IP8, IP1, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN16, IP5, IP6, IP1, IP7, IP2, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP6, IP7, IP1, IP2, IP8, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN18, IP7, IP8, IP1, IP2, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP8, IP1, IP2, IP4, IP5, IP3);
    }

    @Test(groups={"unit"})
    public void networkTopologyWithMultirackHostSkippingTest2() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN02).add((Object)TOKEN03).add((Object)TOKEN04).add((Object)TOKEN05).add((Object)TOKEN06).add((Object)TOKEN07).add((Object)TOKEN08).add((Object)TOKEN12).add((Object)TOKEN13).add((Object)TOKEN14).add((Object)TOKEN15).add((Object)TOKEN16).add((Object)TOKEN17).add((Object)TOKEN18).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN02, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN03, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN04, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN05, (Object)NetworkTopologyStrategyTest.host(IP5, DC1, RACK12)).put((Object)TOKEN06, (Object)NetworkTopologyStrategyTest.host(IP5, DC1, RACK12)).put((Object)TOKEN07, (Object)NetworkTopologyStrategyTest.host(IP7, DC1, RACK12)).put((Object)TOKEN08, (Object)NetworkTopologyStrategyTest.host(IP7, DC1, RACK12)).put((Object)TOKEN12, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN13, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN14, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).put((Object)TOKEN15, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).put((Object)TOKEN16, (Object)NetworkTopologyStrategyTest.host(IP6, DC2, RACK22)).put((Object)TOKEN17, (Object)NetworkTopologyStrategyTest.host(IP6, DC2, RACK22)).put((Object)TOKEN18, (Object)NetworkTopologyStrategyTest.host(IP8, DC2, RACK22)).put((Object)TOKEN19, (Object)NetworkTopologyStrategyTest.host(IP8, DC2, RACK22)).build();
        ReplicationStrategy strategy = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf(DC1, 3), NetworkTopologyStrategyTest.rf(DC2, 3));
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP5, IP3, IP2, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN02, IP1, IP5, IP3, IP2, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP3, IP5, IP7, IP2, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN04, IP3, IP5, IP7, IP2, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP5, IP2, IP6, IP4, IP1, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP5, IP2, IP6, IP4, IP1, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP7, IP2, IP6, IP4, IP1, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN08, IP7, IP2, IP6, IP4, IP1, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN12, IP2, IP6, IP4, IP1, IP5, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP2, IP6, IP4, IP1, IP5, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP4, IP6, IP8, IP1, IP5, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP4, IP6, IP8, IP1, IP5, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN16, IP6, IP1, IP5, IP3, IP2, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP6, IP1, IP5, IP3, IP2, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN18, IP8, IP1, IP5, IP3, IP2, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP8, IP1, IP5, IP3, IP2, IP4);
    }

    @Test(groups={"unit"})
    public void networkTopologyWithMultirackHostSkippingTest3() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN02).add((Object)TOKEN03).add((Object)TOKEN04).add((Object)TOKEN05).add((Object)TOKEN06).add((Object)TOKEN07).add((Object)TOKEN08).add((Object)TOKEN12).add((Object)TOKEN13).add((Object)TOKEN14).add((Object)TOKEN15).add((Object)TOKEN16).add((Object)TOKEN17).add((Object)TOKEN18).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN02, (Object)NetworkTopologyStrategyTest.host(IP1, DC1, RACK11)).put((Object)TOKEN03, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN04, (Object)NetworkTopologyStrategyTest.host(IP3, DC1, RACK11)).put((Object)TOKEN05, (Object)NetworkTopologyStrategyTest.host(IP5, DC1, RACK12)).put((Object)TOKEN06, (Object)NetworkTopologyStrategyTest.host(IP5, DC1, RACK12)).put((Object)TOKEN07, (Object)NetworkTopologyStrategyTest.host(IP7, DC1, RACK12)).put((Object)TOKEN08, (Object)NetworkTopologyStrategyTest.host(IP7, DC1, RACK12)).put((Object)TOKEN12, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN13, (Object)NetworkTopologyStrategyTest.host(IP2, DC2, RACK21)).put((Object)TOKEN14, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).put((Object)TOKEN15, (Object)NetworkTopologyStrategyTest.host(IP4, DC2, RACK21)).put((Object)TOKEN16, (Object)NetworkTopologyStrategyTest.host(IP6, DC2, RACK22)).put((Object)TOKEN17, (Object)NetworkTopologyStrategyTest.host(IP6, DC2, RACK22)).put((Object)TOKEN18, (Object)NetworkTopologyStrategyTest.host(IP8, DC2, RACK22)).put((Object)TOKEN19, (Object)NetworkTopologyStrategyTest.host(IP8, DC2, RACK22)).build();
        ReplicationStrategy strategy = NetworkTopologyStrategyTest.networkTopologyStrategy(NetworkTopologyStrategyTest.rf(DC1, 4), NetworkTopologyStrategyTest.rf(DC2, 4));
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP5, IP3, IP7, IP2, IP6, IP4, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN02, IP1, IP5, IP3, IP7, IP2, IP6, IP4, IP8);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP3, IP5, IP7, IP2, IP6, IP4, IP8, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN04, IP3, IP5, IP7, IP2, IP6, IP4, IP8, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP5, IP2, IP6, IP4, IP8, IP1, IP7, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP5, IP2, IP6, IP4, IP8, IP1, IP7, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP7, IP2, IP6, IP4, IP8, IP1, IP3, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN08, IP7, IP2, IP6, IP4, IP8, IP1, IP3, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN12, IP2, IP6, IP4, IP8, IP1, IP5, IP3, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP2, IP6, IP4, IP8, IP1, IP5, IP3, IP7);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP4, IP6, IP8, IP1, IP5, IP3, IP7, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP4, IP6, IP8, IP1, IP5, IP3, IP7, IP2);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN16, IP6, IP1, IP5, IP3, IP7, IP2, IP8, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP6, IP1, IP5, IP3, IP7, IP2, IP8, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN18, IP8, IP1, IP5, IP3, IP7, IP2, IP4, IP6);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP8, IP1, IP5, IP3, IP7, IP2, IP4, IP6);
    }

    @Test(groups={"unit"})
    public void networkTopologyStrategyExampleTopologyTest() {
        Map replicaMap = exampleStrategy.computeTokenToReplicaMap(exampleTokenToPrimary, exampleRing);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP5, IP2, IP6);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN02, IP1, IP5, IP2, IP6);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP5, IP3, IP2, IP6);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN04, IP3, IP5, IP2, IP6);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP1, IP5, IP2, IP6);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP5, IP2, IP6, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP2, IP6, IP3, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN08, IP6, IP3, IP4, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN09, IP3, IP4, IP5, IP6);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN10, IP4, IP5, IP6, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN11, IP5, IP4, IP6, IP3);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN12, IP4, IP6, IP3, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP4, IP6, IP3, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP2, IP6, IP3, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP6, IP3, IP2, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN16, IP3, IP2, IP6, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP2, IP6, IP1, IP5);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN18, IP6, IP1, IP5, IP2);
    }

    @Test(groups={"unit"})
    public void networkTopologyStrategyExampleTopologyTooManyReplicasTest() {
        Map replicaMap = exampleStrategyTooManyReplicas.computeTokenToReplicaMap(exampleTokenToPrimary, exampleRing);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP5, IP3, IP2, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN02, IP1, IP5, IP3, IP2, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP5, IP3, IP1, IP2, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN04, IP3, IP5, IP1, IP2, IP6, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP1, IP5, IP2, IP6, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP5, IP2, IP6, IP3, IP4, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP2, IP6, IP3, IP4, IP5, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN08, IP6, IP3, IP4, IP5, IP2, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN09, IP3, IP4, IP5, IP6, IP2, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN10, IP4, IP5, IP6, IP2, IP3, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN11, IP5, IP4, IP6, IP2, IP3, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN12, IP4, IP6, IP2, IP3, IP5, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP4, IP6, IP2, IP3, IP5, IP1);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP2, IP6, IP3, IP5, IP1, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP6, IP3, IP2, IP5, IP1, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN16, IP3, IP2, IP6, IP5, IP1, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP2, IP6, IP1, IP5, IP3, IP4);
        NetworkTopologyStrategyTest.assertReplicaPlacement(replicaMap, TOKEN18, IP6, IP1, IP5, IP3, IP2, IP4);
    }

    private static class ReplicationFactorDefinition {
        public final String dc;
        public final int replicationFactor;

        public ReplicationFactorDefinition(String dc, int replicationFactor) {
            this.dc = dc;
            this.replicationFactor = replicationFactor;
        }
    }
}

