/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreparedStatementTest
extends CCMBridge.PerClassSingleNodeCluster {
    private static final String ALL_NATIVE_TABLE = "all_native";
    private static final String ALL_LIST_TABLE = "all_list";
    private static final String ALL_SET_TABLE = "all_set";
    private static final String ALL_MAP_TABLE = "all_map";
    private static final String SIMPLE_TABLE = "test";
    private static final String SIMPLE_TABLE2 = "test2";

    private boolean exclude(DataType t) {
        return t.getName() == DataType.Name.COUNTER;
    }

    @Override
    protected Collection<String> getTableDefinitions() {
        ArrayList<String> defs = new ArrayList<String>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(ALL_NATIVE_TABLE).append(" (k text PRIMARY KEY");
        for (DataType type : DataType.allPrimitiveTypes()) {
            if (this.exclude(type)) continue;
            sb.append(", c_").append(type).append(' ').append(type);
        }
        sb.append(')');
        defs.add(sb.toString());
        sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(ALL_LIST_TABLE).append(" (k text PRIMARY KEY");
        for (DataType type : DataType.allPrimitiveTypes()) {
            if (this.exclude(type)) continue;
            sb.append(", c_list_").append(type).append(" list<").append(type).append('>');
        }
        sb.append(')');
        defs.add(sb.toString());
        sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(ALL_SET_TABLE).append(" (k text PRIMARY KEY");
        for (DataType type : DataType.allPrimitiveTypes()) {
            if (this.exclude(type)) continue;
            sb.append(", c_set_").append(type).append(" set<").append(type).append('>');
        }
        sb.append(')');
        defs.add(sb.toString());
        sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(ALL_MAP_TABLE).append(" (k text PRIMARY KEY");
        for (DataType keyType : DataType.allPrimitiveTypes()) {
            if (this.exclude(keyType)) continue;
            for (DataType valueType : DataType.allPrimitiveTypes()) {
                if (this.exclude(valueType)) continue;
                sb.append(", c_map_").append(keyType).append('_').append(valueType).append(" map<").append(keyType).append(',').append(valueType).append('>');
            }
        }
        sb.append(')');
        defs.add(sb.toString());
        defs.add(String.format("CREATE TABLE %s (k text PRIMARY KEY, i int)", SIMPLE_TABLE));
        defs.add(String.format("CREATE TABLE %s (k text PRIMARY KEY, v text)", SIMPLE_TABLE2));
        return defs;
    }

    @Test(groups={"short"})
    public void preparedNativeTest() {
        for (DataType type : DataType.allPrimitiveTypes()) {
            if (this.exclude(type)) continue;
            String name = "c_" + type;
            PreparedStatement ps = session.prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_native', ?)", ALL_NATIVE_TABLE, name));
            BoundStatement bs = ps.bind();
            session.execute((Statement)TestUtils.setBoundValue(bs, name, type, TestUtils.getFixedValue(type)));
            Row row = session.execute(String.format("SELECT %s FROM %s WHERE k='prepared_native'", name, ALL_NATIVE_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue(row, name, type), (Object)TestUtils.getFixedValue(type), (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void preparedNativeTest2() {
        for (DataType type : DataType.allPrimitiveTypes()) {
            if (this.exclude(type)) continue;
            String name = "c_" + type;
            PreparedStatement ps = session.prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_native', ?)", ALL_NATIVE_TABLE, name));
            BoundStatement bs = ps.bind();
            session.execute((Statement)TestUtils.setBoundValue(bs, name, type, TestUtils.getFixedValue2(type)));
            Row row = session.execute(String.format("SELECT %s FROM %s WHERE k='prepared_native'", name, ALL_NATIVE_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue(row, name, type), (Object)TestUtils.getFixedValue2(type), (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareListTest() {
        for (DataType rawType : DataType.allPrimitiveTypes()) {
            if (this.exclude(rawType)) continue;
            String name = "c_list_" + rawType;
            DataType type = DataType.list((DataType)rawType);
            List value = (List)TestUtils.getFixedValue(type);
            PreparedStatement ps = session.prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_list', ?)", ALL_LIST_TABLE, name));
            BoundStatement bs = ps.bind();
            session.execute((Statement)TestUtils.setBoundValue(bs, name, type, value));
            Row row = session.execute(String.format("SELECT %s FROM %s WHERE k='prepared_list'", name, ALL_LIST_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue(row, name, type), (Object)value, (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareListTest2() {
        for (DataType rawType : DataType.allPrimitiveTypes()) {
            if (this.exclude(rawType)) continue;
            String name = "c_list_" + rawType;
            DataType type = DataType.list((DataType)rawType);
            List value = (List)TestUtils.getFixedValue2(type);
            PreparedStatement ps = session.prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_list', ?)", ALL_LIST_TABLE, name));
            BoundStatement bs = ps.bind();
            session.execute((Statement)TestUtils.setBoundValue(bs, name, type, value));
            Row row = session.execute(String.format("SELECT %s FROM %s WHERE k='prepared_list'", name, ALL_LIST_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue(row, name, type), (Object)value, (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareSetTest() {
        for (DataType rawType : DataType.allPrimitiveTypes()) {
            if (this.exclude(rawType)) continue;
            String name = "c_set_" + rawType;
            DataType type = DataType.set((DataType)rawType);
            Set value = (Set)TestUtils.getFixedValue(type);
            PreparedStatement ps = session.prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_set', ?)", ALL_SET_TABLE, name));
            BoundStatement bs = ps.bind();
            session.execute((Statement)TestUtils.setBoundValue(bs, name, type, value));
            Row row = session.execute(String.format("SELECT %s FROM %s WHERE k='prepared_set'", name, ALL_SET_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue(row, name, type), (Object)value, (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareSetTest2() {
        for (DataType rawType : DataType.allPrimitiveTypes()) {
            if (this.exclude(rawType)) continue;
            String name = "c_set_" + rawType;
            DataType type = DataType.set((DataType)rawType);
            Set value = (Set)TestUtils.getFixedValue2(type);
            PreparedStatement ps = session.prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_set', ?)", ALL_SET_TABLE, name));
            BoundStatement bs = ps.bind();
            session.execute((Statement)TestUtils.setBoundValue(bs, name, type, value));
            Row row = session.execute(String.format("SELECT %s FROM %s WHERE k='prepared_set'", name, ALL_SET_TABLE)).one();
            Assert.assertEquals((Object)TestUtils.getValue(row, name, type), (Object)value, (String)("For type " + type));
        }
    }

    @Test(groups={"short"})
    public void prepareMapTest() {
        for (DataType rawKeyType : DataType.allPrimitiveTypes()) {
            if (this.exclude(rawKeyType)) continue;
            for (DataType rawValueType : DataType.allPrimitiveTypes()) {
                if (this.exclude(rawValueType)) continue;
                String name = "c_map_" + rawKeyType + '_' + rawValueType;
                DataType type = DataType.map((DataType)rawKeyType, (DataType)rawValueType);
                Map value = (Map)TestUtils.getFixedValue(type);
                PreparedStatement ps = session.prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_map', ?)", ALL_MAP_TABLE, name));
                BoundStatement bs = ps.bind();
                session.execute((Statement)TestUtils.setBoundValue(bs, name, type, value));
                Row row = session.execute(String.format("SELECT %s FROM %s WHERE k='prepared_map'", name, ALL_MAP_TABLE)).one();
                Assert.assertEquals((Object)TestUtils.getValue(row, name, type), (Object)value, (String)("For type " + type));
            }
        }
    }

    @Test(groups={"short"})
    public void prepareMapTest2() {
        for (DataType rawKeyType : DataType.allPrimitiveTypes()) {
            if (this.exclude(rawKeyType)) continue;
            for (DataType rawValueType : DataType.allPrimitiveTypes()) {
                if (this.exclude(rawValueType)) continue;
                String name = "c_map_" + rawKeyType + '_' + rawValueType;
                DataType type = DataType.map((DataType)rawKeyType, (DataType)rawValueType);
                Map value = (Map)TestUtils.getFixedValue2(type);
                PreparedStatement ps = session.prepare(String.format("INSERT INTO %s(k, %s) VALUES ('prepared_map', ?)", ALL_MAP_TABLE, name));
                BoundStatement bs = ps.bind();
                session.execute((Statement)TestUtils.setBoundValue(bs, name, type, value));
                Row row = session.execute(String.format("SELECT %s FROM %s WHERE k='prepared_map'", name, ALL_MAP_TABLE)).one();
                Assert.assertEquals((Object)TestUtils.getValue(row, name, type), (Object)value, (String)("For type " + type));
            }
        }
    }

    private void reprepareOnNewlyUpNodeTest(String ks, Session session) throws Exception {
        ks = ks == null ? "" : ks + '.';
        session.execute("INSERT INTO " + ks + "test (k, i) VALUES ('123', 17)");
        session.execute("INSERT INTO " + ks + "test (k, i) VALUES ('124', 18)");
        PreparedStatement ps = session.prepare("SELECT * FROM " + ks + "test WHERE k = ?");
        Assert.assertEquals((int)session.execute((Statement)ps.bind(new Object[]{"123"})).one().getInt("i"), (int)17);
        cassandraCluster.stop();
        TestUtils.waitForDown(CCMBridge.IP_PREFIX + '1', cluster);
        cassandraCluster.start();
        TestUtils.waitFor(CCMBridge.IP_PREFIX + '1', cluster, 120);
        try {
            Assert.assertEquals((int)session.execute((Statement)ps.bind(new Object[]{"124"})).one().getInt("i"), (int)18);
        }
        catch (NoHostAvailableException e) {
            System.out.println(">> " + e.getErrors());
            throw e;
        }
    }

    @Test(groups={"long"})
    public void reprepareOnNewlyUpNodeTest() throws Exception {
        this.reprepareOnNewlyUpNodeTest(null, session);
    }

    @Test(groups={"long"})
    public void reprepareOnNewlyUpNodeNoKeyspaceTest() throws Exception {
        this.reprepareOnNewlyUpNodeTest("ks", cluster.connect());
    }

    @Test(groups={"short"})
    public void prepareWithNullValuesTest() throws Exception {
        PreparedStatement ps = session.prepare("INSERT INTO test2(k, v) VALUES (?, ?)");
        session.execute((Statement)ps.bind(new Object[]{"prepWithNull1", null}));
        BoundStatement bs = ps.bind();
        bs.setString("k", "prepWithNull2");
        bs.setString("v", null);
        session.execute((Statement)bs);
        ResultSet rs = session.execute("SELECT * FROM test2 WHERE k IN ('prepWithNull1', 'prepWithNull2')");
        Row r1 = rs.one();
        Row r2 = rs.one();
        Assert.assertTrue((boolean)rs.isExhausted());
        Assert.assertEquals((String)r1.getString("k"), (String)"prepWithNull1");
        Assert.assertEquals((String)r1.getString("v"), null);
        Assert.assertEquals((String)r2.getString("k"), (String)"prepWithNull2");
        Assert.assertEquals((String)r2.getString("v"), null);
    }

    @Test(groups={"short"})
    public void prepareStatementInheritPropertiesTest() {
        SimpleStatement toPrepare = new SimpleStatement("SELECT * FROM test WHERE k=?");
        toPrepare.setConsistencyLevel(ConsistencyLevel.QUORUM);
        toPrepare.enableTracing();
        PreparedStatement prepared = session.prepare((RegularStatement)toPrepare);
        BoundStatement bs = prepared.bind(new Object[]{"someValue"});
        Assert.assertEquals((Object)ConsistencyLevel.QUORUM, (Object)bs.getConsistencyLevel());
        Assert.assertTrue((boolean)bs.isTracing());
    }

    @Test(groups={"docs"})
    public void printTableDefinitions() {
        for (String definition : this.getTableDefinitions()) {
            System.out.println(definition);
        }
    }

    @Test(groups={"short"})
    public void batchTest() throws Exception {
        block2: {
            try {
                PreparedStatement ps1 = session.prepare("INSERT INTO test2(k, v) VALUES (?, ?)");
                PreparedStatement ps2 = session.prepare("INSERT INTO test2(k, v) VALUES (?, 'bar')");
                BatchStatement bs = new BatchStatement();
                bs.add((Statement)ps1.bind(new Object[]{"one", "foo"}));
                bs.add((Statement)ps2.bind(new Object[]{"two"}));
                bs.add((Statement)new SimpleStatement("INSERT INTO test2 (k, v) VALUES ('three', 'foobar')"));
                session.execute((Statement)bs);
                List all = session.execute("SELECT * FROM test2").all();
                Assert.assertEquals((String)"three", (String)((Row)all.get(0)).getString("k"));
                Assert.assertEquals((String)"foobar", (String)((Row)all.get(0)).getString("v"));
                Assert.assertEquals((String)"one", (String)((Row)all.get(1)).getString("k"));
                Assert.assertEquals((String)"foo", (String)((Row)all.get(1)).getString("v"));
                Assert.assertEquals((String)"two", (String)((Row)all.get(2)).getString("k"));
                Assert.assertEquals((String)"bar", (String)((Row)all.get(2)).getString("v"));
            }
            catch (UnsupportedFeatureException e) {
                if (cluster.getConfiguration().getProtocolOptions().getProtocolVersion() == 1) break block2;
                throw e;
            }
        }
    }

    @Test(groups={"short"}, expectedExceptions={IllegalStateException.class})
    public void unboundVariableInBoundStatementTest() {
        PreparedStatement ps = session.prepare("INSERT INTO test (k, i) VALUES (?, ?)");
        BoundStatement bs = ps.bind(new Object[]{"k"});
        Assert.assertFalse((boolean)bs.isSet("i"));
        session.execute((Statement)bs);
    }

    @Test(groups={"short"}, expectedExceptions={IllegalStateException.class})
    public void unboundVariableInBatchStatementTest() {
        PreparedStatement ps = session.prepare("INSERT INTO test (k, i) VALUES (?, ?)");
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)ps.bind(new Object[]{"k"}));
        session.execute((Statement)batch);
    }
}

