/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ReplicationStrategy;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReplicationStrategyTest {
    @Test(groups={"unit"})
    public void createSimpleReplicationStrategyTest() throws Exception {
        ReplicationStrategy strategy = ReplicationStrategy.create((Map)ImmutableMap.builder().put((Object)"class", (Object)"SimpleStrategy").put((Object)"replication_factor", (Object)"3").build());
        Assert.assertNotNull((Object)strategy);
        Assert.assertTrue((boolean)(strategy instanceof ReplicationStrategy.SimpleStrategy));
    }

    @Test(groups={"unit"})
    public void createNetworkTopologyStrategyTest() throws Exception {
        ReplicationStrategy strategy = ReplicationStrategy.create((Map)ImmutableMap.builder().put((Object)"class", (Object)"NetworkTopologyStrategy").put((Object)"dc1", (Object)"2").put((Object)"dc2", (Object)"2").build());
        Assert.assertNotNull((Object)strategy);
        Assert.assertTrue((boolean)(strategy instanceof ReplicationStrategy.NetworkTopologyStrategy));
    }

    @Test(groups={"unit"})
    public void createSimpleReplicationStrategyWithoutFactorTest() throws Exception {
        ReplicationStrategy strategy = ReplicationStrategy.create((Map)ImmutableMap.builder().put((Object)"class", (Object)"SimpleStrategy").build());
        Assert.assertNull((Object)strategy);
    }

    @Test(groups={"unit"})
    public void createUnknownStrategyTest() throws Exception {
        ReplicationStrategy strategy = ReplicationStrategy.create((Map)ImmutableMap.builder().put((Object)"class", (Object)"FooStrategy").put((Object)"foo_factor", (Object)"3").build());
        Assert.assertNull((Object)strategy);
    }

    @Test(groups={"unit"})
    public void createUnspecifiedStrategyTest() throws Exception {
        ReplicationStrategy strategy = ReplicationStrategy.create((Map)ImmutableMap.builder().put((Object)"foo", (Object)"bar").build());
        Assert.assertNull((Object)strategy);
    }
}

