/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractPoliciesTest;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import com.datastax.driver.core.policies.AlwaysIgnoreRetryPolicy;
import com.datastax.driver.core.policies.AlwaysRetryRetryPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryPolicyTest
extends AbstractPoliciesTest {
    @Test(groups={"unit"})
    public void RetryDecisionTest() throws Throwable {
        TestRetryPolicy.testRetryDecision();
    }

    @Test(groups={"long"})
    public void defaultRetryPolicy() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy());
        this.defaultPolicyTest(builder);
    }

    @Test(groups={"long"})
    public void defaultLoggingPolicy() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE));
        this.defaultPolicyTest(builder);
    }

    @Test(groups={"long"})
    public void fallthroughRetryPolicy() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE);
        this.defaultPolicyTest(builder);
    }

    @Test(groups={"long"})
    public void fallthroughLoggingPolicy() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE));
        this.defaultPolicyTest(builder);
    }

    public void defaultPolicyTest(Cluster.Builder builder) throws Throwable {
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, builder);
        try {
            int i;
            RetryPolicyTest.createSchema(c.session);
            Thread.sleep(5000L);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 6);
            this.resetCoordinators();
            boolean successfulQuery = false;
            boolean readTimeoutOnce = false;
            boolean unavailableOnce = false;
            boolean restartOnce = false;
            for (int i2 = 0; i2 < 10000; ++i2) {
                try {
                    if (!readTimeoutOnce) {
                        c.cassandraCluster.forceStop(2);
                    }
                    if (readTimeoutOnce && !unavailableOnce) {
                        TestUtils.waitForDownWithWait(CCMBridge.IP_PREFIX + '2', c.cluster, 5);
                    }
                    if (unavailableOnce && !restartOnce) {
                        c.cassandraCluster.start(2);
                        restartOnce = true;
                    }
                    this.query(c, 12);
                    if (!restartOnce) continue;
                    successfulQuery = true;
                    continue;
                }
                catch (UnavailableException e) {
                    Assert.assertEquals((String)"Not enough replica available for query at consistency ONE (1 required but only 0 alive)", (String)e.getMessage());
                    unavailableOnce = true;
                    continue;
                }
                catch (ReadTimeoutException e) {
                    Assert.assertEquals((String)"Cassandra timeout during read query at consistency ONE (1 responses were required but only 0 replica responded)", (String)e.getMessage());
                    readTimeoutOnce = true;
                }
            }
            Assert.assertTrue((boolean)successfulQuery, (String)"Hit testing race condition. [Never completed successfully.] (Shouldn't be an issue.):\n");
            Assert.assertTrue((boolean)readTimeoutOnce, (String)"Hit testing race condition. [Never encountered a ReadTimeoutException.] (Shouldn't be an issue.):\n");
            Assert.assertTrue((boolean)unavailableOnce, (String)"Hit testing race condition. [Never encountered an UnavailableException.] (Shouldn't be an issue.):\n");
            this.assertQueriedAtLeast(CCMBridge.IP_PREFIX + '1', 1);
            this.assertQueriedAtLeast(CCMBridge.IP_PREFIX + '2', 1);
            this.resetCoordinators();
            successfulQuery = false;
            boolean writeTimeoutOnce = false;
            unavailableOnce = false;
            restartOnce = false;
            for (i = 0; i < 100; ++i) {
                try {
                    if (!writeTimeoutOnce) {
                        c.cassandraCluster.forceStop(2);
                    }
                    if (writeTimeoutOnce && !unavailableOnce) {
                        TestUtils.waitForDownWithWait(CCMBridge.IP_PREFIX + '2', c.cluster, 5);
                    }
                    if (unavailableOnce && !restartOnce) {
                        c.cassandraCluster.start(2);
                        TestUtils.waitFor(CCMBridge.IP_PREFIX + "2", c.cluster);
                        restartOnce = true;
                    }
                    this.write(c, 12);
                    if (!restartOnce) continue;
                    successfulQuery = true;
                    continue;
                }
                catch (UnavailableException e) {
                    Assert.assertEquals((String)"Not enough replica available for query at consistency ONE (1 required but only 0 alive)", (String)e.getMessage());
                    unavailableOnce = true;
                    continue;
                }
                catch (WriteTimeoutException e) {
                    Assert.assertEquals((String)"Cassandra timeout during write query at consistency ONE (1 replica were required but only 0 acknowledged the write)", (String)e.getMessage());
                    writeTimeoutOnce = true;
                }
            }
            Assert.assertTrue((boolean)successfulQuery, (String)"Hit testing race condition. [Never completed successfully.] (Shouldn't be an issue.):\n");
            Assert.assertTrue((boolean)writeTimeoutOnce, (String)"Hit testing race condition. [Never encountered a ReadTimeoutException.] (Shouldn't be an issue.):\n");
            Assert.assertTrue((boolean)unavailableOnce, (String)"Hit testing race condition. [Never encountered an UnavailableException.] (Shouldn't be an issue.):\n");
            successfulQuery = false;
            writeTimeoutOnce = false;
            unavailableOnce = false;
            restartOnce = false;
            for (i = 0; i < 100; ++i) {
                try {
                    if (!writeTimeoutOnce) {
                        c.cassandraCluster.forceStop(2);
                    }
                    if (writeTimeoutOnce && !unavailableOnce) {
                        TestUtils.waitForDownWithWait(CCMBridge.IP_PREFIX + '2', c.cluster, 5);
                    }
                    if (unavailableOnce && !restartOnce) {
                        c.cassandraCluster.start(2);
                        TestUtils.waitFor(CCMBridge.IP_PREFIX + "2", c.cluster);
                        restartOnce = true;
                    }
                    this.write(c, 12, true);
                    if (!restartOnce) continue;
                    successfulQuery = true;
                    continue;
                }
                catch (UnavailableException e) {
                    Assert.assertEquals((String)"Not enough replica available for query at consistency ONE (1 required but only 0 alive)", (String)e.getMessage());
                    unavailableOnce = true;
                    continue;
                }
                catch (WriteTimeoutException e) {
                    Assert.assertEquals((String)"Cassandra timeout during write query at consistency ONE (1 replica were required but only 0 acknowledged the write)", (String)e.getMessage());
                    writeTimeoutOnce = true;
                }
            }
            Assert.assertTrue((boolean)successfulQuery, (String)"Hit testing race condition. [Never completed successfully.] (Shouldn't be an issue.):\n");
            Assert.assertTrue((boolean)writeTimeoutOnce, (String)"Hit testing race condition. [Never encountered a ReadTimeoutException.] (Shouldn't be an issue.):\n");
            Assert.assertTrue((boolean)unavailableOnce, (String)"Hit testing race condition. [Never encountered an UnavailableException.] (Shouldn't be an issue.):\n");
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void downgradingConsistencyRetryPolicy() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE);
        this.downgradingConsistencyRetryPolicy(builder);
    }

    @Test(groups={"long"})
    public void downgradingConsistencyLoggingPolicy() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE));
        this.downgradingConsistencyRetryPolicy(builder);
    }

    public void downgradingConsistencyRetryPolicy(Cluster.Builder builder) throws Throwable {
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(3, builder);
        try {
            RetryPolicyTest.createSchema(c.session, 3);
            Thread.sleep(5000L);
            this.init(c, 12, ConsistencyLevel.ALL);
            this.query(c, 12, ConsistencyLevel.ALL);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 4);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 4);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 4);
            this.resetCoordinators();
            c.cassandraCluster.stop(2);
            TestUtils.waitForDownWithWait(CCMBridge.IP_PREFIX + '2', c.cluster, 10);
            this.query(c, 12, ConsistencyLevel.ALL);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 6);
            this.resetCoordinators();
            c.cassandraCluster.stop(1);
            TestUtils.waitForDownWithWait(CCMBridge.IP_PREFIX + '1', c.cluster, 10);
            try {
                this.query(c, 12, ConsistencyLevel.ALL);
            }
            catch (ReadTimeoutException e) {
                Assert.assertEquals((String)"Cassandra timeout during read query at consistency TWO (2 responses were required but only 1 replica responded)", (String)e.getMessage());
            }
            Thread.sleep(15000L);
            this.resetCoordinators();
            try {
                this.query(c, 12, ConsistencyLevel.TWO);
            }
            catch (Exception e) {
                Assert.fail((String)"Only 1 node is up and CL.TWO should downgrade and pass.");
            }
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 12);
            this.resetCoordinators();
            try {
                this.query(c, 12, ConsistencyLevel.ALL);
            }
            catch (Exception e) {
                Assert.fail((String)"Only 1 node is up and CL.ALL should downgrade and pass.");
            }
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 12);
            this.resetCoordinators();
            this.query(c, 12, ConsistencyLevel.QUORUM);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 12);
            this.resetCoordinators();
            this.query(c, 12, ConsistencyLevel.TWO);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 12);
            this.resetCoordinators();
            this.query(c, 12, ConsistencyLevel.ONE);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '3', 12);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void alwaysIgnoreRetryPolicyTest() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)AlwaysIgnoreRetryPolicy.INSTANCE));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, builder);
        try {
            int i;
            RetryPolicyTest.createSchema(c.session);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 6);
            this.resetCoordinators();
            c.cassandraCluster.forceStop(2);
            for (i = 0; i < 10; ++i) {
                this.query(c, 12);
            }
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 120);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.resetCoordinators();
            c.cassandraCluster.start(2);
            TestUtils.waitFor(CCMBridge.IP_PREFIX + '2', c.cluster);
            for (i = 0; i < 10; ++i) {
                this.query(c, 12);
            }
            this.assertQueriedAtLeast(CCMBridge.IP_PREFIX + '1', 1);
            this.assertQueriedAtLeast(CCMBridge.IP_PREFIX + '2', 1);
            this.resetCoordinators();
            for (i = 0; i < 100; ++i) {
                this.init(c, 12);
            }
            c.cassandraCluster.forceStop(2);
            for (i = 0; i < 100; ++i) {
                this.init(c, 12);
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    @Test(groups={"long"})
    public void alwaysRetryRetryPolicyTest() throws Throwable {
        Cluster.Builder builder = Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)AlwaysRetryRetryPolicy.INSTANCE));
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(2, builder);
        try {
            int i;
            RetryPolicyTest.createSchema(c.session);
            this.init(c, 12);
            this.query(c, 12);
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 6);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 6);
            this.resetCoordinators();
            c.cassandraCluster.forceStop(2);
            Thread t1 = new Thread(new QueryRunnable(c, 12));
            t1.start();
            t1.join(10000L);
            if (t1.isAlive()) {
                t1.interrupt();
            }
            this.assertQueried(CCMBridge.IP_PREFIX + '1', 0);
            this.assertQueried(CCMBridge.IP_PREFIX + '2', 0);
            this.resetCoordinators();
            c.cassandraCluster.start(2);
            TestUtils.waitFor(CCMBridge.IP_PREFIX + '2', c.cluster);
            for (i = 0; i < 10; ++i) {
                this.query(c, 12);
            }
            this.assertQueriedAtLeast(CCMBridge.IP_PREFIX + '1', 1);
            this.assertQueriedAtLeast(CCMBridge.IP_PREFIX + '2', 1);
            this.resetCoordinators();
            for (i = 0; i < 100; ++i) {
                this.init(c, 12);
            }
            c.cassandraCluster.forceStop(2);
            Thread t2 = new Thread(new InitRunnable(c, 12));
            t2.start();
            t2.join(10000L);
            if (t2.isAlive()) {
                t2.interrupt();
            }
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            this.resetCoordinators();
            c.discard();
        }
    }

    private class InitRunnable
    implements Runnable {
        private CCMBridge.CCMCluster c;
        private int i;

        public InitRunnable(CCMBridge.CCMCluster c, int i) {
            this.c = c;
            this.i = i;
        }

        @Override
        public void run() {
            try {
                RetryPolicyTest.this.init(this.c, this.i);
                Assert.fail();
            }
            catch (DriverInternalError e) {
            }
            catch (NoHostAvailableException noHostAvailableException) {
                // empty catch block
            }
        }
    }

    private class QueryRunnable
    implements Runnable {
        private CCMBridge.CCMCluster c;
        private int i;

        public QueryRunnable(CCMBridge.CCMCluster c, int i) {
            this.c = c;
            this.i = i;
        }

        @Override
        public void run() {
            RetryPolicyTest.this.query(this.c, this.i);
        }
    }

    public static class TestRetryPolicy
    implements RetryPolicy {
        public RetryPolicy.RetryDecision onReadTimeout(Statement query, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
            return RetryPolicy.RetryDecision.rethrow();
        }

        public RetryPolicy.RetryDecision onWriteTimeout(Statement query, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
            return RetryPolicy.RetryDecision.rethrow();
        }

        public RetryPolicy.RetryDecision onUnavailable(Statement query, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
            return RetryPolicy.RetryDecision.rethrow();
        }

        public static void testRetryDecision() {
            Assert.assertEquals((Object)RetryPolicy.RetryDecision.retry((ConsistencyLevel)ConsistencyLevel.ONE).getType(), (Object)RetryPolicy.RetryDecision.Type.RETRY);
            Assert.assertEquals((Object)RetryPolicy.RetryDecision.retry((ConsistencyLevel)ConsistencyLevel.ONE).getRetryConsistencyLevel(), (Object)ConsistencyLevel.ONE);
            Assert.assertEquals((Object)RetryPolicy.RetryDecision.rethrow().getType(), (Object)RetryPolicy.RetryDecision.Type.RETHROW);
            Assert.assertEquals((Object)RetryPolicy.RetryDecision.ignore().getType(), (Object)RetryPolicy.RetryDecision.Type.IGNORE);
            Assert.assertEquals((String)RetryPolicy.RetryDecision.retry((ConsistencyLevel)ConsistencyLevel.ONE).toString(), (String)("Retry at " + ConsistencyLevel.ONE));
            Assert.assertEquals((String)RetryPolicy.RetryDecision.rethrow().toString(), (String)"Rethrow");
            Assert.assertEquals((String)RetryPolicy.RetryDecision.ignore().toString(), (String)"Ignore");
        }
    }
}

