/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.VersionNumber;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SchemaTest
extends CCMBridge.PerClassSingleNodeCluster {
    private static final Map<String, String> cql3 = new HashMap<String, String>();
    private static final Map<String, String> compact = new HashMap<String, String>();
    private static String withOptions;

    @Override
    protected Collection<String> getTableDefinitions() {
        String sparse = "CREATE TABLE ks.sparse (\n    k text,\n    c1 int,\n    c2 float,\n    l list<text>,\n    v int,\n    PRIMARY KEY (k, c1, c2)\n);";
        String st = "CREATE TABLE ks.static (\n    k text,\n    i int,\n    m map<text, timeuuid>,\n    v int,\n    PRIMARY KEY (k)\n);";
        String counters = "CREATE TABLE ks.counters (\n    k text,\n    c counter,\n    PRIMARY KEY (k)\n);";
        String compactStatic = "CREATE TABLE ks.compact_static (\n    k text,\n    i int,\n    t timeuuid,\n    v int,\n    PRIMARY KEY (k)\n) WITH COMPACT STORAGE;";
        String compactDynamic = "CREATE TABLE ks.compact_dynamic (\n    k text,\n    c int,\n    v timeuuid,\n    PRIMARY KEY (k, c)\n) WITH COMPACT STORAGE;";
        String compactComposite = "CREATE TABLE ks.compact_composite (\n    k text,\n    c1 int,\n    c2 float,\n    c3 double,\n    v timeuuid,\n    PRIMARY KEY (k, c1, c2, c3)\n) WITH COMPACT STORAGE;";
        cql3.put("sparse", sparse);
        cql3.put("static", st);
        cql3.put("counters", counters);
        compact.put("compact_static", compactStatic);
        compact.put("compact_dynamic", compactDynamic);
        compact.put("compact_composite", compactComposite);
        withOptions = "CREATE TABLE ks.with_options (\n    k text,\n    v1 int,\n    v2 int,\n    i int,\n    PRIMARY KEY (k, v1, v2)\n) WITH CLUSTERING ORDER BY (v1 DESC, v2 ASC)\n   AND read_repair_chance = 0.5\n   AND dclocal_read_repair_chance = 0.6\n   AND replicate_on_write = true\n   AND gc_grace_seconds = 42\n   AND bloom_filter_fp_chance = 0.01\n   AND caching = 'ALL'\n   AND comment = 'My awesome table'\n   AND compaction = { 'class' : 'org.apache.cassandra.db.compaction.LeveledCompactionStrategy', 'sstable_size_in_mb' : 15 }\n   AND compression = { 'sstable_compression' : 'org.apache.cassandra.io.compress.SnappyCompressor', 'chunk_length_kb' : 128 };";
        ArrayList<String> allDefs = new ArrayList<String>();
        allDefs.addAll(cql3.values());
        allDefs.addAll(compact.values());
        allDefs.add(withOptions);
        return allDefs;
    }

    private static String stripOptions(String def, boolean keepFirst) {
        if (keepFirst) {
            return def.split("\n   AND ")[0] + ';';
        }
        return def.split(" WITH ")[0] + ';';
    }

    @Test(groups={"short"})
    public void schemaExportTest() {
        String def;
        String table;
        KeyspaceMetadata metadata = cluster.getMetadata().getKeyspace("ks");
        for (Map.Entry<String, String> tableEntry : cql3.entrySet()) {
            table = tableEntry.getKey();
            def = tableEntry.getValue();
            Assert.assertEquals((String)SchemaTest.stripOptions(metadata.getTable(table).exportAsString(), false), (String)def);
        }
        for (Map.Entry<String, String> tableEntry : compact.entrySet()) {
            table = tableEntry.getKey();
            def = tableEntry.getValue();
            Assert.assertEquals((String)SchemaTest.stripOptions(metadata.getTable(table).exportAsString(), true), (String)def);
        }
    }

    @Test(groups={"short"})
    public void schemaExportOptionsTest() {
        TableMetadata metadata = cluster.getMetadata().getKeyspace("ks").getTable("with_options");
        String withOpts = withOptions;
        VersionNumber version = cluster.getMetadata().getHost(new InetSocketAddress(CCMBridge.IP_PREFIX + "1", 9042)).getCassandraVersion();
        if (version.getMajor() == 2) {
            withOpts = withOpts.substring(0, withOpts.length() - 1) + '\n';
            withOpts = withOpts + "   AND default_time_to_live = 0\n   AND speculative_retry = '99.0PERCENTILE'\n";
            if (version.getMinor() == 0) {
                withOpts = withOpts + "   AND index_interval = 128;";
            } else {
                withOpts = withOpts + "   AND min_index_interval = 128\n   AND max_index_interval = 2048;";
                withOpts = withOpts.replace("caching = 'ALL'", "caching = { 'keys' : 'ALL', 'rows_per_partition' : 'ALL' }").replace("   AND replicate_on_write = true\n", "");
            }
        }
        Assert.assertEquals((String)metadata.exportAsString(), (String)withOpts);
    }
}

