/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SessionTest
extends CCMBridge.PerClassSingleNodeCluster {
    private static final String TABLE1 = "test1";
    private static final String TABLE2 = "test2";
    private static final String TABLE3 = "test3";
    private static final String COUNTER_TABLE = "counters";

    @Override
    protected Collection<String> getTableDefinitions() {
        return Arrays.asList(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", TABLE1), String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", TABLE2), String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", TABLE3), String.format("CREATE TABLE %s (k text PRIMARY KEY, c counter)", COUNTER_TABLE));
    }

    @Test(groups={"short"})
    public void executeTest() throws Exception {
        String key = "execute_test";
        ResultSet rs = session.execute(String.format(Locale.US, "INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", TABLE1, key, "foo", 42, Float.valueOf(24.03f)));
        Assert.assertTrue((boolean)rs.isExhausted());
        SessionTest.checkExecuteResultSet(session.execute(String.format("SELECT * FROM %s", TABLE1)), key);
        SessionTest.checkExecuteResultSet(session.execute(new SimpleStatement(String.format("SELECT * FROM %s", TABLE1)).setConsistencyLevel(ConsistencyLevel.ONE)), key);
        SessionTest.checkExecuteResultSet(session.executeAsync(String.format("SELECT * FROM %s", TABLE1)).getUninterruptibly(), key);
        SessionTest.checkExecuteResultSet(session.executeAsync(new SimpleStatement(String.format("SELECT * FROM %s", TABLE1)).setConsistencyLevel(ConsistencyLevel.ONE)).getUninterruptibly(), key);
    }

    @Test(groups={"short"})
    public void executePreparedTest() throws Exception {
        String key = "execute_prepared_test";
        ResultSet rs = session.execute(String.format(Locale.US, "INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", TABLE2, key, "foo", 42, Float.valueOf(24.03f)));
        Assert.assertTrue((boolean)rs.isExhausted());
        PreparedStatement p = session.prepare(String.format("SELECT * FROM %s WHERE k = ?", TABLE2));
        BoundStatement bs = p.bind(new Object[]{key});
        SessionTest.checkExecuteResultSet(session.execute((Statement)bs), key);
        SessionTest.checkExecuteResultSet(session.execute(bs.setConsistencyLevel(ConsistencyLevel.ONE)), key);
        SessionTest.checkExecuteResultSet(session.executeAsync((Statement)bs).getUninterruptibly(), key);
        SessionTest.checkExecuteResultSet(session.executeAsync(bs.setConsistencyLevel(ConsistencyLevel.ONE)).getUninterruptibly(), key);
    }

    private static void checkExecuteResultSet(ResultSet rs, String key) {
        Assert.assertTrue((!rs.isExhausted() ? 1 : 0) != 0);
        Row row = rs.one();
        Assert.assertTrue((boolean)rs.isExhausted());
        Assert.assertEquals((String)row.getString("k"), (String)key);
        Assert.assertEquals((String)row.getString("t"), (String)"foo");
        Assert.assertEquals((int)row.getInt("i"), (int)42);
        Assert.assertEquals((float)row.getFloat("f"), (float)24.03f, (float)0.1f);
    }

    @Test(groups={"short"})
    public void executePreparedCounterTest() throws Exception {
        PreparedStatement p = session.prepare("UPDATE counters SET c = c + ? WHERE k = ?");
        session.execute((Statement)p.bind(new Object[]{1L, "row"}));
        session.execute((Statement)p.bind(new Object[]{1L, "row"}));
        ResultSet rs = session.execute("SELECT * FROM counters");
        List rows = rs.all();
        Assert.assertEquals((int)rows.size(), (int)1);
        Assert.assertEquals((long)((Row)rows.get(0)).getLong("c"), (long)2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void compressionTest() throws Exception {
        cluster.getConfiguration().getProtocolOptions().setCompression(ProtocolOptions.Compression.SNAPPY);
        try {
            Session compressedSession = cluster.connect("ks");
            String key = "execute_compressed_test";
            ResultSet rs = compressedSession.execute(String.format(Locale.US, "INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)", TABLE3, key, "foo", 42, Float.valueOf(24.03f)));
            Assert.assertTrue((boolean)rs.isExhausted());
            String SELECT_ALL = String.format("SELECT * FROM %s WHERE k = '%s'", TABLE3, key);
            SessionTest.checkExecuteResultSet(compressedSession.execute(SELECT_ALL), key);
            SessionTest.checkExecuteResultSet(compressedSession.execute(new SimpleStatement(SELECT_ALL).setConsistencyLevel(ConsistencyLevel.ONE)), key);
            SessionTest.checkExecuteResultSet(compressedSession.executeAsync(SELECT_ALL).getUninterruptibly(), key);
            SessionTest.checkExecuteResultSet(compressedSession.executeAsync(new SimpleStatement(SELECT_ALL).setConsistencyLevel(ConsistencyLevel.ONE)).getUninterruptibly(), key);
        }
        finally {
            cluster.getConfiguration().getProtocolOptions().setCompression(ProtocolOptions.Compression.NONE);
        }
    }

    @Test(groups={"short"})
    public void getStateTest() throws Exception {
        Session.State state = session.getState();
        Host host = (Host)state.getConnectedHosts().iterator().next();
        String hostAddress = String.format("/%s1", CCMBridge.IP_PREFIX);
        Assert.assertEquals((int)state.getConnectedHosts().size(), (int)1);
        Assert.assertEquals((String)host.getAddress().toString(), (String)hostAddress);
        Assert.assertEquals((String)host.getDatacenter(), (String)"datacenter1");
        Assert.assertEquals((String)host.getRack(), (String)"rack1");
        Assert.assertEquals((String)host.getSocketAddress().toString(), (String)(hostAddress + ":9042"));
        Assert.assertEquals((int)state.getOpenConnections(host), (int)2);
        Assert.assertEquals((int)state.getInFlightQueries(host), (int)0);
        Assert.assertEquals((Object)state.getSession(), (Object)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"long"})
    public void sessionMemoryLeakTest() throws Exception {
        Thread.sleep(10L);
        Cluster cluster = Cluster.builder().addContactPoints(new String[]{CCMBridge.IP_PREFIX + '1'}).build();
        Assert.assertEquals((int)cluster.manager.sessions.size(), (int)0);
        Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)0);
        Session session = cluster.connect();
        Assert.assertEquals((int)cluster.manager.sessions.size(), (int)1);
        Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)3);
        session.close();
        Assert.assertEquals((int)cluster.manager.sessions.size(), (int)0);
        Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)1);
        Thread.sleep(10L);
        try {
            for (int i = 0; i < 10000; ++i) {
                Assert.assertEquals((int)cluster.manager.sessions.size(), (int)0);
                Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)1);
                session = cluster.connect();
                Assert.assertEquals((int)cluster.manager.sessions.size(), (int)1);
                Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)3);
                session.close();
                Thread.sleep(10L);
                Assert.assertEquals((int)cluster.manager.sessions.size(), (int)0);
                Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)1);
            }
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void connectionLeakTest() throws Exception {
        Thread.sleep(10L);
        Cluster cluster = Cluster.builder().addContactPoints(new String[]{CCMBridge.IP_PREFIX + '1'}).build();
        Assert.assertEquals((int)cluster.manager.sessions.size(), (int)0);
        Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)0);
        Session session = cluster.connect();
        Assert.assertEquals((int)cluster.manager.sessions.size(), (int)1);
        Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)3);
        session.close();
        Assert.assertEquals((int)cluster.manager.sessions.size(), (int)0);
        Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)1);
        try {
            cassandraCluster.bootstrapNode(2);
            Assert.assertEquals((int)cluster.manager.sessions.size(), (int)0);
            Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)1);
            Session thisSession = cluster.connect();
            Assert.assertEquals((int)cluster.manager.sessions.size(), (int)1);
            Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)5);
            thisSession.close();
            Assert.assertEquals((int)cluster.manager.sessions.size(), (int)0);
            Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)1);
        }
        finally {
            cassandraCluster.decommissionNode(2);
            Assert.assertEquals((int)cluster.manager.sessions.size(), (int)0);
            Assert.assertEquals((int)((Integer)cluster.getMetrics().getOpenConnections().getValue()), (int)1);
            cluster.close();
        }
    }

    @Test(groups={"short"})
    public void closeDuringClusterInitTest() throws InterruptedException {
        for (int i = 0; i < 500; ++i) {
            final Cluster cluster = Cluster.builder().addContactPoint(CCMBridge.IP_PREFIX + "1").build();
            final Session session = cluster.newSession();
            ExecutorService executor = Executors.newFixedThreadPool(2);
            final CountDownLatch startLatch = new CountDownLatch(1);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                        cluster.init();
                    }
                    catch (InterruptedException e) {
                        Assert.fail((String)"unexpected interruption", (Throwable)e);
                    }
                }
            });
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                        TimeUnit.MILLISECONDS.sleep(10L);
                        session.close();
                    }
                    catch (InterruptedException e) {
                        Assert.fail((String)"unexpected interruption", (Throwable)e);
                    }
                }
            });
            startLatch.countDown();
            executor.shutdown();
            boolean normalShutdown = executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((boolean)normalShutdown);
            cluster.close();
        }
    }
}

