/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractReplicationStrategyTest;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ReplicationStrategy;
import com.datastax.driver.core.Token;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class SimpleStrategyTest
extends AbstractReplicationStrategyTest {
    private static final Token TOKEN01 = SimpleStrategyTest.token("-9000000000000000000");
    private static final Token TOKEN02 = SimpleStrategyTest.token("-8000000000000000000");
    private static final Token TOKEN03 = SimpleStrategyTest.token("-7000000000000000000");
    private static final Token TOKEN04 = SimpleStrategyTest.token("-6000000000000000000");
    private static final Token TOKEN05 = SimpleStrategyTest.token("-5000000000000000000");
    private static final Token TOKEN06 = SimpleStrategyTest.token("-4000000000000000000");
    private static final Token TOKEN07 = SimpleStrategyTest.token("-3000000000000000000");
    private static final Token TOKEN08 = SimpleStrategyTest.token("-2000000000000000000");
    private static final Token TOKEN09 = SimpleStrategyTest.token("-1000000000000000000");
    private static final Token TOKEN10 = SimpleStrategyTest.token("0");
    private static final Token TOKEN11 = SimpleStrategyTest.token("1000000000000000000");
    private static final Token TOKEN12 = SimpleStrategyTest.token("2000000000000000000");
    private static final Token TOKEN13 = SimpleStrategyTest.token("3000000000000000000");
    private static final Token TOKEN14 = SimpleStrategyTest.token("4000000000000000000");
    private static final Token TOKEN15 = SimpleStrategyTest.token("5000000000000000000");
    private static final Token TOKEN16 = SimpleStrategyTest.token("6000000000000000000");
    private static final Token TOKEN17 = SimpleStrategyTest.token("7000000000000000000");
    private static final Token TOKEN18 = SimpleStrategyTest.token("8000000000000000000");
    private static final Token TOKEN19 = SimpleStrategyTest.token("9000000000000000000");
    private static final String IP1 = "127.0.0.101";
    private static final String IP2 = "127.0.0.102";
    private static final String IP3 = "127.0.0.103";
    private static final String IP4 = "127.0.0.104";
    private static final String IP5 = "127.0.0.105";
    private static final String IP6 = "127.0.0.106";
    private static final ReplicationStrategy exampleStrategy = SimpleStrategyTest.simpleStrategy(3);
    private static final ReplicationStrategy exampleStrategyTooManyReplicas = SimpleStrategyTest.simpleStrategy(8);
    private static final List<Token> exampleRing = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN02).add((Object)TOKEN03).add((Object)TOKEN04).add((Object)TOKEN05).add((Object)TOKEN06).add((Object)TOKEN07).add((Object)TOKEN08).add((Object)TOKEN09).add((Object)TOKEN10).add((Object)TOKEN11).add((Object)TOKEN12).add((Object)TOKEN13).add((Object)TOKEN14).add((Object)TOKEN15).add((Object)TOKEN16).add((Object)TOKEN17).add((Object)TOKEN18).build();
    private static final Map<Token, Host> exampleTokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)SimpleStrategyTest.host("127.0.0.101")).put((Object)TOKEN02, (Object)SimpleStrategyTest.host("127.0.0.101")).put((Object)TOKEN03, (Object)SimpleStrategyTest.host("127.0.0.105")).put((Object)TOKEN04, (Object)SimpleStrategyTest.host("127.0.0.103")).put((Object)TOKEN05, (Object)SimpleStrategyTest.host("127.0.0.101")).put((Object)TOKEN06, (Object)SimpleStrategyTest.host("127.0.0.105")).put((Object)TOKEN07, (Object)SimpleStrategyTest.host("127.0.0.102")).put((Object)TOKEN08, (Object)SimpleStrategyTest.host("127.0.0.106")).put((Object)TOKEN09, (Object)SimpleStrategyTest.host("127.0.0.103")).put((Object)TOKEN10, (Object)SimpleStrategyTest.host("127.0.0.104")).put((Object)TOKEN11, (Object)SimpleStrategyTest.host("127.0.0.105")).put((Object)TOKEN12, (Object)SimpleStrategyTest.host("127.0.0.104")).put((Object)TOKEN13, (Object)SimpleStrategyTest.host("127.0.0.104")).put((Object)TOKEN14, (Object)SimpleStrategyTest.host("127.0.0.102")).put((Object)TOKEN15, (Object)SimpleStrategyTest.host("127.0.0.106")).put((Object)TOKEN16, (Object)SimpleStrategyTest.host("127.0.0.103")).put((Object)TOKEN17, (Object)SimpleStrategyTest.host("127.0.0.102")).put((Object)TOKEN18, (Object)SimpleStrategyTest.host("127.0.0.106")).build();

    private static ReplicationStrategy simpleStrategy(int replicationFactor) {
        return ReplicationStrategy.create((Map)ImmutableMap.builder().put((Object)"class", (Object)"SimpleStrategy").put((Object)"replication_factor", (Object)String.valueOf(replicationFactor)).build());
    }

    @Test(groups={"unit"})
    public void simpleStrategySimpleTopologyTest() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN06).add((Object)TOKEN14).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)SimpleStrategyTest.host(IP1)).put((Object)TOKEN06, (Object)SimpleStrategyTest.host(IP2)).put((Object)TOKEN14, (Object)SimpleStrategyTest.host(IP1)).put((Object)TOKEN19, (Object)SimpleStrategyTest.host(IP2)).build();
        ReplicationStrategy strategy = SimpleStrategyTest.simpleStrategy(2);
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP2, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP1, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP2, IP1);
    }

    @Test(groups={"unit"})
    public void simpleStrategyConsecutiveRingSectionsTest() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN06).add((Object)TOKEN14).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)SimpleStrategyTest.host(IP1)).put((Object)TOKEN06, (Object)SimpleStrategyTest.host(IP1)).put((Object)TOKEN14, (Object)SimpleStrategyTest.host(IP2)).put((Object)TOKEN19, (Object)SimpleStrategyTest.host(IP2)).build();
        ReplicationStrategy strategy = SimpleStrategyTest.simpleStrategy(2);
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP1, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP2, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP2, IP1);
    }

    @Test(groups={"unit"})
    public void simpleStrategyUnbalancedRingTest() {
        ImmutableList ring = ImmutableList.builder().add((Object)TOKEN01).add((Object)TOKEN06).add((Object)TOKEN14).add((Object)TOKEN19).build();
        ImmutableMap tokenToPrimary = ImmutableMap.builder().put((Object)TOKEN01, (Object)SimpleStrategyTest.host(IP1)).put((Object)TOKEN06, (Object)SimpleStrategyTest.host(IP1)).put((Object)TOKEN14, (Object)SimpleStrategyTest.host(IP2)).put((Object)TOKEN19, (Object)SimpleStrategyTest.host(IP1)).build();
        ReplicationStrategy strategy = SimpleStrategyTest.simpleStrategy(2);
        Map replicaMap = strategy.computeTokenToReplicaMap((Map)tokenToPrimary, (List)ring);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP1, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP2, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN19, IP1, IP2);
    }

    @Test(groups={"unit"})
    public void simpleStrategyExampleTopologyMapTest() {
        Map replicaMap = exampleStrategy.computeTokenToReplicaMap(exampleTokenToPrimary, exampleRing);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP5, IP3);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN02, IP1, IP5, IP3);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP5, IP3, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN04, IP3, IP1, IP5);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP1, IP5, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP5, IP2, IP6);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP2, IP6, IP3);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN08, IP6, IP3, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN09, IP3, IP4, IP5);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN10, IP4, IP5, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN11, IP5, IP4, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN12, IP4, IP2, IP6);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP4, IP2, IP6);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP2, IP6, IP3);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP6, IP3, IP2);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN16, IP3, IP2, IP6);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP2, IP6, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN18, IP6, IP1, IP5);
    }

    @Test(groups={"unit"})
    public void simpleStrategyExampleTopologyTooManyReplicasTest() {
        Map replicaMap = exampleStrategyTooManyReplicas.computeTokenToReplicaMap(exampleTokenToPrimary, exampleRing);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN01, IP1, IP5, IP3, IP2, IP6, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN02, IP1, IP5, IP3, IP2, IP6, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN03, IP5, IP3, IP1, IP2, IP6, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN04, IP3, IP1, IP5, IP2, IP6, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN05, IP1, IP5, IP2, IP6, IP3, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN06, IP5, IP2, IP6, IP3, IP4, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN07, IP2, IP6, IP3, IP4, IP5, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN08, IP6, IP3, IP4, IP5, IP2, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN09, IP3, IP4, IP5, IP2, IP6, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN10, IP4, IP5, IP2, IP6, IP3, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN11, IP5, IP4, IP2, IP6, IP3, IP1);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN12, IP4, IP2, IP6, IP3, IP1, IP5);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN13, IP4, IP2, IP6, IP3, IP1, IP5);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN14, IP2, IP6, IP3, IP1, IP5, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN15, IP6, IP3, IP2, IP1, IP5, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN16, IP3, IP2, IP6, IP1, IP5, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN17, IP2, IP6, IP1, IP5, IP3, IP4);
        SimpleStrategyTest.assertReplicaPlacement(replicaMap, TOKEN18, IP6, IP1, IP5, IP3, IP2, IP4);
    }
}

