/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.TestUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StateListenerTest {
    @Test(groups={"short"})
    public void listenerTest() throws Throwable {
        CCMBridge.CCMCluster c = CCMBridge.buildCluster(1, Cluster.builder());
        Cluster cluster = c.cluster;
        try {
            CountingListener listener = new CountingListener();
            cluster.register((Host.StateListener)listener);
            c.cassandraCluster.bootstrapNode(2);
            TestUtils.waitFor(CCMBridge.IP_PREFIX + '2', cluster);
            Thread.sleep(500L);
            Assert.assertEquals((int)listener.adds, (int)1);
            c.cassandraCluster.forceStop(1);
            TestUtils.waitForDown(CCMBridge.IP_PREFIX + '1', cluster);
            Thread.sleep(500L);
            Assert.assertEquals((int)listener.downs, (int)1);
            c.cassandraCluster.start(1);
            TestUtils.waitFor(CCMBridge.IP_PREFIX + '1', cluster);
            Thread.sleep(500L);
            Assert.assertEquals((int)listener.ups, (int)1);
            c.cassandraCluster.decommissionNode(2);
            TestUtils.waitForDecommission(CCMBridge.IP_PREFIX + '2', cluster);
            Thread.sleep(500L);
            Assert.assertEquals((int)listener.removes, (int)1);
        }
        catch (Throwable e) {
            c.errorOut();
            throw e;
        }
        finally {
            c.discard();
        }
    }

    private static class CountingListener
    implements Host.StateListener {
        public int adds;
        public int removes;
        public int ups;
        public int downs;

        private CountingListener() {
        }

        public void onAdd(Host host) {
            ++this.adds;
        }

        public void onUp(Host host) {
            ++this.ups;
        }

        public void onSuspected(Host host) {
        }

        public void onDown(Host host) {
            ++this.downs;
        }

        public void onRemove(Host host) {
            ++this.removes;
        }
    }
}

