/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import java.util.concurrent.TimeUnit;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class TestListener
extends TestListenerAdapter {
    private long start_time = System.nanoTime();
    private int test_index = 0;

    public void onTestFailure(ITestResult tr) {
        long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start_time);
        long testTime = tr.getEndMillis() - tr.getStartMillis();
        tr.getThrowable().printStackTrace();
        System.out.println("FAILED: " + tr.getName());
        System.out.println("Test: " + TestListener.formatIntoHHMMSS(testTime / 1000L));
        System.out.println("Elapsed: " + TestListener.formatIntoHHMMSS(elapsedTime));
        System.out.println();
    }

    public void onTestSkipped(ITestResult tr) {
        long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start_time);
        long testTime = tr.getEndMillis() - tr.getStartMillis();
        System.out.println("SKIPPED: " + tr.getName());
        System.out.println("Test: " + TestListener.formatIntoHHMMSS(testTime / 1000L));
        System.out.println("Elapsed: " + TestListener.formatIntoHHMMSS(elapsedTime));
        System.out.println();
    }

    public void onTestSuccess(ITestResult tr) {
        long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start_time);
        long testTime = tr.getEndMillis() - tr.getStartMillis();
        System.out.println("SUCCESS: " + tr.getName());
        System.out.println("Test: " + TestListener.formatIntoHHMMSS(testTime / 1000L));
        System.out.println("Elapsed: " + TestListener.formatIntoHHMMSS(elapsedTime));
        System.out.println("\n");
    }

    public void onTestStart(ITestResult tr) {
        System.out.println("Starting " + tr.getTestClass().getName() + '.' + tr.getName() + " [Test #" + ++this.test_index + "]...");
    }

    static String formatIntoHHMMSS(long secondsTotal) {
        long hours = secondsTotal / 3600L;
        long remainder = secondsTotal % 3600L;
        long minutes = remainder / 60L;
        long seconds = remainder % 60L;
        return (hours < 10L ? "0" : "") + hours + ':' + (minutes < 10L ? "0" : "") + minutes + ':' + (seconds < 10L ? "0" : "") + seconds;
    }

    static {
        System.out.println("[CCMBridge] Using Cassandra version: " + CCMBridge.CASSANDRA_VERSION);
    }
}

