/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Row;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.SkipException;

public abstract class TestUtils {
    private static final Logger logger = LoggerFactory.getLogger(TestUtils.class);
    public static final String CREATE_KEYSPACE_SIMPLE_FORMAT = "CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }";
    public static final String CREATE_KEYSPACE_GENERIC_FORMAT = "CREATE KEYSPACE %s WITH replication = { 'class' : '%s', %s }";
    public static final String SIMPLE_KEYSPACE = "ks";
    public static final String SIMPLE_TABLE = "test";
    public static final String CREATE_TABLE_SIMPLE_FORMAT = "CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)";
    public static final String INSERT_FORMAT = "INSERT INTO %s (k, t, i, f) VALUES ('%s', '%s', %d, %f)";
    public static final String SELECT_ALL_FORMAT = "SELECT * FROM %s";

    public static BoundStatement setBoundValue(BoundStatement bs, String name, DataType type, Object value) {
        switch (type.getName()) {
            case ASCII: {
                bs.setString(name, (String)value);
                break;
            }
            case BIGINT: {
                bs.setLong(name, ((Long)value).longValue());
                break;
            }
            case BLOB: {
                bs.setBytes(name, (ByteBuffer)value);
                break;
            }
            case BOOLEAN: {
                bs.setBool(name, ((Boolean)value).booleanValue());
                break;
            }
            case COUNTER: {
                break;
            }
            case DECIMAL: {
                bs.setDecimal(name, (BigDecimal)value);
                break;
            }
            case DOUBLE: {
                bs.setDouble(name, ((Double)value).doubleValue());
                break;
            }
            case FLOAT: {
                bs.setFloat(name, ((Float)value).floatValue());
                break;
            }
            case INET: {
                bs.setInet(name, (InetAddress)value);
                break;
            }
            case INT: {
                bs.setInt(name, ((Integer)value).intValue());
                break;
            }
            case TEXT: {
                bs.setString(name, (String)value);
                break;
            }
            case TIMESTAMP: {
                bs.setDate(name, (Date)value);
                break;
            }
            case UUID: {
                bs.setUUID(name, (UUID)value);
                break;
            }
            case VARCHAR: {
                bs.setString(name, (String)value);
                break;
            }
            case VARINT: {
                bs.setVarint(name, (BigInteger)value);
                break;
            }
            case TIMEUUID: {
                bs.setUUID(name, (UUID)value);
                break;
            }
            case LIST: {
                bs.setList(name, (List)value);
                break;
            }
            case SET: {
                bs.setSet(name, (Set)value);
                break;
            }
            case MAP: {
                bs.setMap(name, (Map)value);
                break;
            }
            default: {
                throw new RuntimeException("Missing handling of " + type);
            }
        }
        return bs;
    }

    public static Object getValue(Row row, String name, DataType type) {
        switch (type.getName()) {
            case ASCII: {
                return row.getString(name);
            }
            case BIGINT: {
                return row.getLong(name);
            }
            case BLOB: {
                return row.getBytes(name);
            }
            case BOOLEAN: {
                return row.getBool(name);
            }
            case COUNTER: {
                return row.getLong(name);
            }
            case DECIMAL: {
                return row.getDecimal(name);
            }
            case DOUBLE: {
                return row.getDouble(name);
            }
            case FLOAT: {
                return Float.valueOf(row.getFloat(name));
            }
            case INET: {
                return row.getInet(name);
            }
            case INT: {
                return row.getInt(name);
            }
            case TEXT: {
                return row.getString(name);
            }
            case TIMESTAMP: {
                return row.getDate(name);
            }
            case UUID: {
                return row.getUUID(name);
            }
            case VARCHAR: {
                return row.getString(name);
            }
            case VARINT: {
                return row.getVarint(name);
            }
            case TIMEUUID: {
                return row.getUUID(name);
            }
            case LIST: {
                return row.getList(name, ((DataType)type.getTypeArguments().get(0)).asJavaClass());
            }
            case SET: {
                return row.getSet(name, ((DataType)type.getTypeArguments().get(0)).asJavaClass());
            }
            case MAP: {
                return row.getMap(name, ((DataType)type.getTypeArguments().get(0)).asJavaClass(), ((DataType)type.getTypeArguments().get(1)).asJavaClass());
            }
        }
        throw new RuntimeException("Missing handling of " + type);
    }

    public static Object getFixedValue(final DataType type) {
        try {
            switch (type.getName()) {
                case ASCII: {
                    return "An ascii string";
                }
                case BIGINT: {
                    return 42L;
                }
                case BLOB: {
                    return ByteBuffer.wrap(new byte[]{4, 12, 1});
                }
                case BOOLEAN: {
                    return true;
                }
                case COUNTER: {
                    throw new UnsupportedOperationException("Cannot 'getSomeValue' for counters");
                }
                case DECIMAL: {
                    return new BigDecimal("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679");
                }
                case DOUBLE: {
                    return 3.142519;
                }
                case FLOAT: {
                    return Float.valueOf(3.142519f);
                }
                case INET: {
                    return InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
                }
                case INT: {
                    return 24;
                }
                case TEXT: {
                    return "A text string";
                }
                case TIMESTAMP: {
                    return new Date(1352288289L);
                }
                case UUID: {
                    return UUID.fromString("087E9967-CCDC-4A9B-9036-05930140A41B");
                }
                case VARCHAR: {
                    return "A varchar string";
                }
                case VARINT: {
                    return new BigInteger("123456789012345678901234567890");
                }
                case TIMEUUID: {
                    return UUID.fromString("FE2B4360-28C6-11E2-81C1-0800200C9A66");
                }
                case LIST: {
                    return new ArrayList<Object>(){
                        {
                            this.add(TestUtils.getFixedValue((DataType)type.getTypeArguments().get(0)));
                        }
                    };
                }
                case SET: {
                    return new HashSet<Object>(){
                        {
                            this.add(TestUtils.getFixedValue((DataType)type.getTypeArguments().get(0)));
                        }
                    };
                }
                case MAP: {
                    return new HashMap<Object, Object>(){
                        {
                            this.put(TestUtils.getFixedValue((DataType)type.getTypeArguments().get(0)), TestUtils.getFixedValue((DataType)type.getTypeArguments().get(1)));
                        }
                    };
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Missing handling of " + type);
    }

    public static Object getFixedValue2(final DataType type) {
        try {
            switch (type.getName()) {
                case ASCII: {
                    return "A different ascii string";
                }
                case BIGINT: {
                    return Long.MAX_VALUE;
                }
                case BLOB: {
                    ByteBuffer bb = ByteBuffer.allocate(64);
                    bb.putInt(51966);
                    bb.putShort((short)3);
                    bb.putShort((short)45);
                    return bb;
                }
                case BOOLEAN: {
                    return false;
                }
                case COUNTER: {
                    throw new UnsupportedOperationException("Cannot 'getSomeValue' for counters");
                }
                case DECIMAL: {
                    return new BigDecimal("12.3E+7");
                }
                case DOUBLE: {
                    return Double.POSITIVE_INFINITY;
                }
                case FLOAT: {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case INET: {
                    return InetAddress.getByName("123.123.123.123");
                }
                case INT: {
                    return Integer.MAX_VALUE;
                }
                case TEXT: {
                    return "r\u00e9sum\u00e9";
                }
                case TIMESTAMP: {
                    return new Date(872835240000L);
                }
                case UUID: {
                    return UUID.fromString("067e6162-3b6f-4ae2-a171-2470b63dff00");
                }
                case VARCHAR: {
                    return "A different varchar r\u00e9sum\u00e9";
                }
                case VARINT: {
                    return new BigInteger(Integer.toString(Integer.MAX_VALUE) + "000");
                }
                case TIMEUUID: {
                    return UUID.fromString("FE2B4360-28C6-11E2-81C1-0800200C9A66");
                }
                case LIST: {
                    return new ArrayList<Object>(){
                        {
                            this.add(TestUtils.getFixedValue2((DataType)type.getTypeArguments().get(0)));
                        }
                    };
                }
                case SET: {
                    return new HashSet<Object>(){
                        {
                            this.add(TestUtils.getFixedValue2((DataType)type.getTypeArguments().get(0)));
                        }
                    };
                }
                case MAP: {
                    return new HashMap<Object, Object>(){
                        {
                            this.put(TestUtils.getFixedValue2((DataType)type.getTypeArguments().get(0)), TestUtils.getFixedValue2((DataType)type.getTypeArguments().get(1)));
                        }
                    };
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Missing handling of " + type);
    }

    public static void waitFor(String node, Cluster cluster) {
        TestUtils.waitFor(node, cluster, 60, false, false);
    }

    public static void waitFor(String node, Cluster cluster, int maxTry) {
        TestUtils.waitFor(node, cluster, maxTry, false, false);
    }

    public static void waitForDown(String node, Cluster cluster) {
        TestUtils.waitFor(node, cluster, 180, true, false);
    }

    public static void waitForDownWithWait(String node, Cluster cluster, int waitTime) {
        TestUtils.waitFor(node, cluster, 180, true, false);
        try {
            Thread.sleep(waitTime * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void waitForDown(String node, Cluster cluster, int maxTry) {
        TestUtils.waitFor(node, cluster, maxTry, true, false);
    }

    public static void stopAndWait(CCMBridge.CCMCluster c, int node) {
        c.cassandraCluster.stop(node);
        TestUtils.waitForDownWithWait(CCMBridge.IP_PREFIX + node, c.cluster, 5);
    }

    public static void waitForDecommission(String node, Cluster cluster) {
        TestUtils.waitFor(node, cluster, 30, true, true);
    }

    public static void waitForDecommission(String node, Cluster cluster, int maxTry) {
        TestUtils.waitFor(node, cluster, maxTry, true, true);
    }

    private static void waitFor(String node, Cluster cluster, int maxTry, boolean waitForDead, boolean waitForOut) {
        InetAddress address;
        if (waitForDead || waitForOut) {
            if (waitForDead) {
                logger.info("Waiting for stopped node: " + node);
            } else if (waitForOut) {
                logger.info("Waiting for decommissioned node: " + node);
            } else {
                logger.info("Waiting for upcoming node: " + node);
            }
        }
        if (waitForDead || waitForOut) {
            cluster.manager.submitSchemaRefresh(null, null);
        }
        try {
            address = InetAddress.getByName(node);
        }
        catch (Exception e) {
            return;
        }
        Metadata metadata = cluster.getMetadata();
        for (int i = 0; i < maxTry; ++i) {
            for (Host host : metadata.getAllHosts()) {
                if (!host.getAddress().equals(address) || !TestUtils.testHost(host, waitForDead)) continue;
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (Host host : metadata.getAllHosts()) {
            if (!host.getAddress().equals(address)) continue;
            if (TestUtils.testHost(host, waitForDead)) {
                return;
            }
            logger.info(node + " is not " + (waitForDead ? "DOWN" : "UP") + " after " + maxTry + 's');
            throw new IllegalStateException(node + " is not " + (waitForDead ? "DOWN" : "UP") + " after " + maxTry + 's');
        }
        if (waitForOut) {
            return;
        }
        logger.info(node + " is not part of the cluster after " + maxTry + 's');
        throw new IllegalStateException(node + " is not part of the cluster after " + maxTry + 's');
    }

    private static boolean testHost(Host host, boolean testForDown) {
        return testForDown ? !host.isUp() : host.isUp();
    }

    public static void versionCheck(double majorCheck, int minorCheck, String skipString) {
        String version = System.getProperty("cassandra.version");
        String[] versionArray = version.split("\\.|-");
        double major = Double.parseDouble(versionArray[0] + "." + versionArray[1]);
        int minor = Integer.parseInt(versionArray[2]);
        if (major < majorCheck || major == majorCheck && minor < minorCheck) {
            throw new SkipException(skipString);
        }
    }
}

