/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeIntegrationTest;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.google.common.base.Joiner;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TupleTest
extends CCMBridge.PerClassSingleNodeCluster {
    @Override
    protected Collection<String> getTableDefinitions() {
        TestUtils.versionCheck(2.1, 0, "This will only work with Cassandra 2.1.0");
        return Arrays.asList("CREATE TABLE t (k int PRIMARY KEY, v tuple<int, text, float>)");
    }

    @Test(groups={"short"})
    public void simpleValueTest() throws Exception {
        TupleType t = TupleType.of((DataType[])new DataType[]{DataType.cint(), DataType.text(), DataType.cfloat()});
        TupleValue v = t.newValue();
        v.setInt(0, 1);
        v.setString(1, "a");
        v.setFloat(2, 1.0f);
        Assert.assertEquals((int)v.getType().getComponentTypes().size(), (int)3);
        Assert.assertEquals(v.getType().getComponentTypes().get(0), (Object)DataType.cint());
        Assert.assertEquals(v.getType().getComponentTypes().get(1), (Object)DataType.text());
        Assert.assertEquals(v.getType().getComponentTypes().get(2), (Object)DataType.cfloat());
        Assert.assertEquals((int)v.getInt(0), (int)1);
        Assert.assertEquals((String)v.getString(1), (String)"a");
        Assert.assertEquals((Object)Float.valueOf(v.getFloat(2)), (Object)Float.valueOf(1.0f));
        Assert.assertEquals((String)t.format((Object)v), (String)"(1, 'a', 1.0)");
    }

    @Test(groups={"short"})
    public void simpleWriteReadTest() throws Exception {
        try {
            session.execute("USE ks");
            PreparedStatement ins = session.prepare("INSERT INTO t(k, v) VALUES (?, ?)");
            PreparedStatement sel = session.prepare("SELECT * FROM t WHERE k=?");
            TupleType t = TupleType.of((DataType[])new DataType[]{DataType.cint(), DataType.text(), DataType.cfloat()});
            int k = 1;
            TupleValue v = t.newValue(new Object[]{1, "a", Float.valueOf(1.0f)});
            session.execute((Statement)ins.bind(new Object[]{k, v}));
            TupleValue v2 = session.execute((Statement)sel.bind(new Object[]{k})).one().getTupleValue("v");
            Assert.assertEquals((Object)v2, (Object)v);
            k = 2;
            v = t.newValue(new Object[]{2, "b", Float.valueOf(2.0f)});
            session.execute("INSERT INTO t(k, v) VALUES (?, ?)", new Object[]{k, v});
            v2 = session.execute((Statement)sel.bind(new Object[]{k})).one().getTupleValue("v");
            Assert.assertEquals((Object)v2, (Object)v);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void tupleTypeTest() throws Exception {
        try {
            session.execute("CREATE KEYSPACE test_tuple_type WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE test_tuple_type");
            session.execute("CREATE TABLE mytable (a int PRIMARY KEY, b tuple<ascii, int, boolean>)");
            TupleType t = TupleType.of((DataType[])new DataType[]{DataType.ascii(), DataType.cint(), DataType.cboolean()});
            TupleValue complete = t.newValue(new Object[]{"foo", 123, true});
            session.execute("INSERT INTO mytable (a, b) VALUES (0, ?)", new Object[]{complete});
            TupleValue r = session.execute("SELECT b FROM mytable WHERE a=0").one().getTupleValue("b");
            Assert.assertEquals((Object)r, (Object)complete);
            try {
                TupleValue partial = t.newValue(new Object[]{"bar", 456});
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            TupleType t1 = TupleType.of((DataType[])new DataType[]{DataType.ascii(), DataType.cint()});
            TupleValue partial = t1.newValue(new Object[]{"bar", 456});
            TupleValue partionResult = t.newValue(new Object[]{"bar", 456, null});
            session.execute("INSERT INTO mytable (a, b) VALUES (0, ?)", new Object[]{partial});
            r = session.execute("SELECT b FROM mytable WHERE a=0").one().getTupleValue("b");
            Assert.assertEquals((Object)r, (Object)partionResult);
            try {
                TupleValue subpartial = t.newValue(new Object[]{"zoo"});
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            TupleType t2 = TupleType.of((DataType[])new DataType[]{DataType.ascii()});
            TupleValue subpartial = t2.newValue(new Object[]{"zoo"});
            TupleValue subpartialResult = t.newValue(new Object[]{"zoo", null, null});
            session.execute("INSERT INTO mytable (a, b) VALUES (0, ?)", new Object[]{subpartial});
            r = session.execute("SELECT b FROM mytable WHERE a=0").one().getTupleValue("b");
            Assert.assertEquals((Object)r, (Object)subpartialResult);
            PreparedStatement prepared = session.prepare("INSERT INTO mytable (a, b) VALUES (?, ?)");
            session.execute((Statement)prepared.bind(new Object[]{3, complete}));
            session.execute((Statement)prepared.bind(new Object[]{4, partial}));
            session.execute((Statement)prepared.bind(new Object[]{5, subpartial}));
            prepared = session.prepare("SELECT b FROM mytable WHERE a=?");
            Assert.assertEquals((Object)session.execute((Statement)prepared.bind(new Object[]{3})).one().getTupleValue("b"), (Object)complete);
            Assert.assertEquals((Object)session.execute((Statement)prepared.bind(new Object[]{4})).one().getTupleValue("b"), (Object)partionResult);
            Assert.assertEquals((Object)session.execute((Statement)prepared.bind(new Object[]{5})).one().getTupleValue("b"), (Object)subpartialResult);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void tupleTestTypeVaryingLengths() throws Exception {
        try {
            session.execute("CREATE KEYSPACE test_tuple_type_varying_lengths WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE test_tuple_type_varying_lengths");
            int[] lengths = new int[]{1, 2, 3, 384};
            ArrayList<String> valueSchema = new ArrayList<String>();
            for (int i : lengths) {
                ArrayList<String> ints = new ArrayList<String>();
                for (int j = 0; j < i; ++j) {
                    ints.add("int");
                }
                valueSchema.add(String.format(" v_%d tuple<%s>", i, Joiner.on((char)',').join(ints)));
            }
            session.execute(String.format("CREATE TABLE mytable (k int PRIMARY KEY, %s)", Joiner.on((char)',').join(valueSchema)));
            for (int i : lengths) {
                ArrayList<DataType> dataTypes = new ArrayList<DataType>();
                ArrayList<Integer> values = new ArrayList<Integer>();
                for (int j = 0; j < i; ++j) {
                    dataTypes.add(DataType.cint());
                    values.add(j);
                }
                TupleType t = new TupleType(dataTypes);
                TupleValue createdTuple = t.newValue(values.toArray());
                session.execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (0, ?)", i), new Object[]{createdTuple});
                TupleValue r = session.execute(String.format("SELECT v_%s FROM mytable WHERE k=0", i)).one().getTupleValue(String.format("v_%s", i));
                Assert.assertEquals((Object)r, (Object)createdTuple);
            }
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void tupleSubtypesTest() throws Exception {
        ArrayList<DataType> DATA_TYPE_PRIMITIVES = new ArrayList<DataType>();
        for (DataType dt : DataType.allPrimitiveTypes()) {
            if (dt == DataType.counter()) continue;
            DATA_TYPE_PRIMITIVES.add(dt);
        }
        HashMap<DataType, Object> SAMPLE_DATA = DataTypeIntegrationTest.getSampleData();
        try {
            session.execute("CREATE KEYSPACE test_tuple_subtypes WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE test_tuple_subtypes");
            session.execute(String.format("CREATE TABLE mytable (k int PRIMARY KEY, v tuple<%s>)", Joiner.on((char)',').join(DATA_TYPE_PRIMITIVES)));
            int i = 1;
            for (DataType datatype : DATA_TYPE_PRIMITIVES) {
                int j;
                ArrayList dataTypes = new ArrayList();
                ArrayList completeDataTypes = new ArrayList();
                ArrayList<Object> createdValues = new ArrayList<Object>();
                ArrayList<Object> completeValues = new ArrayList<Object>();
                for (j = 0; j < i; ++j) {
                    dataTypes.add(DATA_TYPE_PRIMITIVES.get(j));
                    completeDataTypes.add(DATA_TYPE_PRIMITIVES.get(j));
                    createdValues.add(SAMPLE_DATA.get(DATA_TYPE_PRIMITIVES.get(j)));
                    completeValues.add(SAMPLE_DATA.get(DATA_TYPE_PRIMITIVES.get(j)));
                }
                for (j = 0; j < DATA_TYPE_PRIMITIVES.size() - i; ++j) {
                    completeDataTypes.add(DATA_TYPE_PRIMITIVES.get(i + j));
                    completeValues.add(null);
                }
                TupleType t = new TupleType(dataTypes);
                TupleType t2 = new TupleType(completeDataTypes);
                TupleValue createdTuple = t.newValue(createdValues.toArray());
                TupleValue completeTuple = t2.newValue(completeValues.toArray());
                session.execute(String.format("INSERT INTO mytable (k, v) VALUES (%s, ?)", i), new Object[]{createdTuple});
                TupleValue r = session.execute("SELECT v FROM mytable WHERE k=?", new Object[]{i}).one().getTupleValue("v");
                Assert.assertEquals((String)r.toString(), (String)completeTuple.toString());
                ++i;
            }
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void tupleNonPrimitiveSubTypesTest() throws Exception {
        ArrayList<DataType> DATA_TYPE_PRIMITIVES = new ArrayList<DataType>();
        for (DataType dt : DataType.allPrimitiveTypes()) {
            if (dt == DataType.counter()) continue;
            DATA_TYPE_PRIMITIVES.add(dt);
        }
        ArrayList<DataType.Name> DATA_TYPE_NON_PRIMITIVE_NAMES = new ArrayList<DataType.Name>(Arrays.asList(DataType.Name.MAP, DataType.Name.SET, DataType.Name.LIST));
        HashMap<DataType, Object> SAMPLE_DATA = DataTypeIntegrationTest.getSampleData();
        try {
            TupleValue r;
            TupleValue createdTuple;
            TupleType t;
            ArrayList<Object> createdValues;
            ArrayList<DataType> dataTypes;
            session.execute("CREATE KEYSPACE test_tuple_non_primitive_subtypes WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE test_tuple_non_primitive_subtypes");
            ArrayList<String> values = new ArrayList<String>();
            for (DataType datatype : DATA_TYPE_PRIMITIVES) {
                values.add(String.format("v_%s tuple<list<%s>>", values.size(), datatype));
            }
            for (DataType datatype : DATA_TYPE_PRIMITIVES) {
                values.add(String.format("v_%s tuple<set<%s>>", values.size(), datatype));
            }
            Iterator i$ = DATA_TYPE_PRIMITIVES.iterator();
            while (i$.hasNext()) {
                DataType datatype;
                DataType dataType1 = datatype = (DataType)i$.next();
                DataType dataType2 = datatype;
                values.add(String.format("v_%s tuple<map<%s, %s>>", values.size(), dataType1, dataType2));
            }
            session.execute(String.format("CREATE TABLE mytable (k int PRIMARY KEY, %s)", Joiner.on((char)',').join(values)));
            int i = 0;
            for (DataType datatype : DATA_TYPE_PRIMITIVES) {
                dataTypes = new ArrayList<DataType>();
                createdValues = new ArrayList<Object>();
                dataTypes.add(DataType.list((DataType)datatype));
                createdValues.add(Arrays.asList(SAMPLE_DATA.get(datatype)));
                t = new TupleType(dataTypes);
                createdTuple = t.newValue(createdValues.toArray());
                session.execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (0, ?)", i), new Object[]{createdTuple});
                r = session.execute(String.format("SELECT v_%s FROM mytable WHERE k=0", i)).one().getTupleValue(String.format("v_%s", i));
                Assert.assertEquals((String)r.toString(), (String)createdTuple.toString());
                ++i;
            }
            for (DataType datatype : DATA_TYPE_PRIMITIVES) {
                dataTypes = new ArrayList();
                createdValues = new ArrayList();
                dataTypes.add(DataType.set((DataType)datatype));
                createdValues.add(new HashSet<Object>(Arrays.asList(SAMPLE_DATA.get(datatype))));
                t = new TupleType(dataTypes);
                createdTuple = t.newValue(createdValues.toArray());
                session.execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (0, ?)", i), new Object[]{createdTuple});
                r = session.execute(String.format("SELECT v_%s FROM mytable WHERE k=0", i)).one().getTupleValue(String.format("v_%s", i));
                Assert.assertEquals((String)r.toString(), (String)createdTuple.toString());
                ++i;
            }
            for (DataType datatype : DATA_TYPE_PRIMITIVES) {
                dataTypes = new ArrayList();
                createdValues = new ArrayList();
                HashMap<Object, Object> hm = new HashMap<Object, Object>();
                hm.put(SAMPLE_DATA.get(datatype), SAMPLE_DATA.get(datatype));
                dataTypes.add(DataType.map((DataType)datatype, (DataType)datatype));
                createdValues.add(hm);
                TupleType t2 = new TupleType(dataTypes);
                TupleValue createdTuple2 = t2.newValue(createdValues.toArray());
                session.execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (0, ?)", i), new Object[]{createdTuple2});
                TupleValue r2 = session.execute(String.format("SELECT v_%s FROM mytable WHERE k=0", i)).one().getTupleValue(String.format("v_%s", i));
                Assert.assertEquals((String)r2.toString(), (String)createdTuple2.toString());
                ++i;
            }
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    private String nestedTuplesSchemaHelper(int depth) {
        if (depth == 0) {
            return "int";
        }
        return String.format("tuple<%s>", this.nestedTuplesSchemaHelper(depth - 1));
    }

    private TupleValue nestedTuplesCreatorHelper(int depth) {
        if (depth == 1) {
            TupleType baseTuple = TupleType.of((DataType[])new DataType[]{DataType.cint()});
            return baseTuple.newValue(new Object[]{303});
        }
        TupleValue innerTuple = this.nestedTuplesCreatorHelper(depth - 1);
        TupleType t = TupleType.of((DataType[])new DataType[]{innerTuple.getType()});
        return t.newValue(new Object[]{innerTuple});
    }

    @Test(groups={"short"})
    public void nestedTuplesTest() throws Exception {
        ArrayList<DataType> DATA_TYPE_PRIMITIVES = new ArrayList<DataType>();
        for (DataType dt : DataType.allPrimitiveTypes()) {
            if (dt == DataType.counter()) continue;
            DATA_TYPE_PRIMITIVES.add(dt);
        }
        HashMap<DataType, Object> SAMPLE_DATA = DataTypeIntegrationTest.getSampleData();
        try {
            session.execute("CREATE KEYSPACE test_nested_tuples WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE test_nested_tuples");
            session.execute(String.format("CREATE TABLE mytable (k int PRIMARY KEY, v_1 %s, v_2 %s, v_3 %s, v_128 %s)", this.nestedTuplesSchemaHelper(1), this.nestedTuplesSchemaHelper(2), this.nestedTuplesSchemaHelper(3), this.nestedTuplesSchemaHelper(128)));
            for (int i : Arrays.asList(1, 2, 3, 128)) {
                TupleValue createdTuple = this.nestedTuplesCreatorHelper(i);
                session.execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (?, ?)", i), new Object[]{i, createdTuple});
                TupleValue r = session.execute(String.format("SELECT v_%s FROM mytable WHERE k=?", i), new Object[]{i}).one().getTupleValue(String.format("v_%s", i));
                Assert.assertEquals((String)r.toString(), (String)createdTuple.toString());
            }
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void testTuplesWithNulls() throws Exception {
        try {
            session.execute("CREATE KEYSPACE testTuplesWithNulls WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE testTuplesWithNulls");
            session.execute("CREATE TYPE user (a text, b tuple<text, int, uuid, blob>)");
            session.execute("CREATE TABLE mytable (a int PRIMARY KEY, b user)");
            UserType userTypeDef = cluster.getMetadata().getKeyspace("testTuplesWithNulls").getUserType("user");
            UDTValue userType = userTypeDef.newValue();
            TupleType t = TupleType.of((DataType[])new DataType[]{DataType.text(), DataType.cint(), DataType.uuid(), DataType.blob()});
            TupleValue v = t.newValue(new Object[]{null, null, null, null});
            userType.setTupleValue("b", v);
            PreparedStatement ins = session.prepare("INSERT INTO mytable (a, b) VALUES (?, ?)");
            session.execute((Statement)ins.bind(new Object[]{0, userType}));
            ResultSet rs = session.execute("SELECT * FROM mytable");
            List rows = rs.all();
            Assert.assertEquals((int)1, (int)rows.size());
            Row row = (Row)rows.get(0);
            Assert.assertEquals((int)row.getInt("a"), (int)0);
            Assert.assertEquals((Object)row.getUDTValue("b"), (Object)userType);
            v = t.newValue(new Object[]{"", null, null, ByteBuffer.allocate(0)});
            userType.setTupleValue("b", v);
            session.execute((Statement)ins.bind(new Object[]{0, userType}));
            rs = session.execute("SELECT * FROM mytable");
            rows = rs.all();
            Assert.assertEquals((int)1, (int)rows.size());
            row = (Row)rows.get(0);
            Assert.assertEquals((int)row.getInt("a"), (int)0);
            Assert.assertEquals((Object)row.getUDTValue("b"), (Object)userType);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }
}

