/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeIntegrationTest;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UserTypesTest
extends CCMBridge.PerClassSingleNodeCluster {
    private static final List<DataType> DATA_TYPE_PRIMITIVES = new ArrayList<DataType>(DataType.allPrimitiveTypes());
    private static final List<DataType.Name> DATA_TYPE_NON_PRIMITIVE_NAMES = new ArrayList<DataType.Name>(EnumSet.of(DataType.Name.LIST, DataType.Name.SET, DataType.Name.MAP, DataType.Name.TUPLE));
    private static final HashMap<DataType, Object> SAMPLE_DATA = DataTypeIntegrationTest.getSampleData();

    @Override
    protected Collection<String> getTableDefinitions() {
        TestUtils.versionCheck(2.1, 0, "This will only work with Cassandra 2.1.0");
        String type1 = "CREATE TYPE phone (alias text, number text)";
        String type2 = "CREATE TYPE address (street text, \"ZIP\" int, phones set<phone>)";
        String table = "CREATE TABLE user (id int PRIMARY KEY, addr address)";
        return Arrays.asList(type1, type2, table);
    }

    @Test(groups={"short"})
    public void simpleWriteReadTest() throws Exception {
        int userId = 0;
        try {
            session.execute("USE ks");
            PreparedStatement ins = session.prepare("INSERT INTO user(id, addr) VALUES (?, ?)");
            PreparedStatement sel = session.prepare("SELECT * FROM user WHERE id=?");
            UserType addrDef = cluster.getMetadata().getKeyspace("ks").getUserType("address");
            UserType phoneDef = cluster.getMetadata().getKeyspace("ks").getUserType("phone");
            UDTValue phone1 = (UDTValue)((UDTValue)phoneDef.newValue().setString("alias", "home")).setString("number", "0123548790");
            UDTValue phone2 = (UDTValue)((UDTValue)phoneDef.newValue().setString("alias", "work")).setString("number", "0698265251");
            UDTValue addr = (UDTValue)((UDTValue)((UDTValue)addrDef.newValue().setString("street", "1600 Pennsylvania Ave NW")).setInt(Metadata.quote((String)"ZIP"), 20500)).setSet("phones", (Set)ImmutableSet.of((Object)phone1, (Object)phone2));
            session.execute((Statement)ins.bind(new Object[]{userId, addr}));
            Row r = session.execute((Statement)sel.bind(new Object[]{userId})).one();
            Assert.assertEquals((int)r.getInt("id"), (int)0);
            Assert.assertEquals((Object)r.getUDTValue("addr"), (Object)addr);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void simpleUnpreparedWriteReadTest() throws Exception {
        int userId = 1;
        try {
            session.execute("USE ks");
            UserType addrDef = cluster.getMetadata().getKeyspace("ks").getUserType("address");
            UserType phoneDef = cluster.getMetadata().getKeyspace("ks").getUserType("phone");
            UDTValue phone1 = (UDTValue)((UDTValue)phoneDef.newValue().setString("alias", "home")).setString("number", "0123548790");
            UDTValue phone2 = (UDTValue)((UDTValue)phoneDef.newValue().setString("alias", "work")).setString("number", "0698265251");
            UDTValue addr = (UDTValue)((UDTValue)((UDTValue)addrDef.newValue().setString("street", "1600 Pennsylvania Ave NW")).setInt(Metadata.quote((String)"ZIP"), 20500)).setSet("phones", (Set)ImmutableSet.of((Object)phone1, (Object)phone2));
            session.execute("INSERT INTO user(id, addr) VALUES (?, ?)", new Object[]{userId, addr});
            Row r = session.execute("SELECT * FROM user WHERE id=?", new Object[]{userId}).one();
            Assert.assertEquals((int)r.getInt("id"), (int)1);
            Assert.assertEquals((Object)r.getUDTValue("addr"), (Object)addr);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void nonExistingTypesTest() throws Exception {
        try {
            session.execute("USE ks");
            UserType addrDef = cluster.getMetadata().getKeyspace("ks").getUserType("address1");
            UserType phoneDef = cluster.getMetadata().getKeyspace("ks").getUserType("phone1");
            Assert.assertEquals((Iterable)addrDef, null);
            Assert.assertEquals((Iterable)phoneDef, null);
            addrDef = cluster.getMetadata().getKeyspace("ks").getUserType("address");
            phoneDef = cluster.getMetadata().getKeyspace("ks").getUserType("phone");
            Assert.assertNotEquals((Object)addrDef, null);
            Assert.assertNotEquals((Object)phoneDef, null);
            session.execute("CREATE KEYSPACE nonExistingTypesTest WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE nonExistingTypesTest");
            addrDef = cluster.getMetadata().getKeyspace("nonExistingTypesTest").getUserType("address");
            phoneDef = cluster.getMetadata().getKeyspace("nonExistingTypesTest").getUserType("phone");
            Assert.assertEquals((Iterable)addrDef, null);
            Assert.assertEquals((Iterable)phoneDef, null);
            session.execute("USE ks");
            addrDef = cluster.getMetadata().getKeyspace("ks").getUserType("address");
            phoneDef = cluster.getMetadata().getKeyspace("ks").getUserType("phone");
            Assert.assertNotEquals((Object)addrDef, null);
            Assert.assertNotEquals((Object)phoneDef, null);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void udtSizesTest() throws Exception {
        int MAX_TEST_LENGTH = 1024;
        try {
            session.execute("CREATE KEYSPACE test_udt_sizes WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE test_udt_sizes");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < MAX_TEST_LENGTH; ++i) {
                sb.append(String.format("v_%s int", i));
                if (i + 1 >= MAX_TEST_LENGTH) continue;
                sb.append(",");
            }
            session.execute(String.format("CREATE TYPE lengthy_udt (%s)", sb.toString()));
            session.execute("CREATE TABLE mytable (k int PRIMARY KEY, v lengthy_udt)");
            UserType udtDef = cluster.getMetadata().getKeyspace("test_udt_sizes").getUserType("lengthy_udt");
            for (int i : Arrays.asList(0, 1, 2, 3, MAX_TEST_LENGTH)) {
                UDTValue createdUDT = udtDef.newValue();
                for (int j = 0; j < i; ++j) {
                    createdUDT.setInt(j, j);
                }
                session.execute("INSERT INTO mytable (k, v) VALUES (0, ?)", new Object[]{createdUDT});
                UDTValue r = session.execute("SELECT v FROM mytable WHERE k=0").one().getUDTValue("v");
                Assert.assertEquals((String)r.toString(), (String)createdUDT.toString());
            }
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void testPrimitiveDatatypes() throws Exception {
        try {
            session.execute("CREATE KEYSPACE testPrimitiveDatatypes WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE testPrimitiveDatatypes");
            ArrayList<String> alpha_type_list = new ArrayList<String>();
            int startIndex = 97;
            for (int i = 0; i < DATA_TYPE_PRIMITIVES.size(); ++i) {
                alpha_type_list.add(String.format("%s %s", Character.toString((char)(startIndex + i)), DATA_TYPE_PRIMITIVES.get(i).getName()));
            }
            session.execute(String.format("CREATE TYPE alldatatypes (%s)", Joiner.on((char)',').join(alpha_type_list)));
            session.execute("CREATE TABLE mytable (a int PRIMARY KEY, b alldatatypes)");
            UserType alldatatypesDef = cluster.getMetadata().getKeyspace("testPrimitiveDatatypes").getUserType("alldatatypes");
            UDTValue alldatatypes = alldatatypesDef.newValue();
            block20: for (int i = 0; i < DATA_TYPE_PRIMITIVES.size(); ++i) {
                DataType dataType = DATA_TYPE_PRIMITIVES.get(i);
                String index = Character.toString((char)(startIndex + i));
                Object sampleData = SAMPLE_DATA.get(dataType);
                switch (dataType.getName()) {
                    case ASCII: {
                        alldatatypes.setString(index, (String)sampleData);
                        continue block20;
                    }
                    case BIGINT: {
                        alldatatypes.setLong(index, ((Long)sampleData).longValue());
                        continue block20;
                    }
                    case BLOB: {
                        alldatatypes.setBytes(index, (ByteBuffer)sampleData);
                        continue block20;
                    }
                    case BOOLEAN: {
                        alldatatypes.setBool(index, ((Boolean)sampleData).booleanValue());
                        continue block20;
                    }
                    case DECIMAL: {
                        alldatatypes.setDecimal(index, (BigDecimal)sampleData);
                        continue block20;
                    }
                    case DOUBLE: {
                        alldatatypes.setDouble(index, ((Double)sampleData).doubleValue());
                        continue block20;
                    }
                    case FLOAT: {
                        alldatatypes.setFloat(index, ((Float)sampleData).floatValue());
                        continue block20;
                    }
                    case INET: {
                        alldatatypes.setInet(index, (InetAddress)sampleData);
                        continue block20;
                    }
                    case INT: {
                        alldatatypes.setInt(index, ((Integer)sampleData).intValue());
                        continue block20;
                    }
                    case TEXT: {
                        alldatatypes.setString(index, (String)sampleData);
                        continue block20;
                    }
                    case TIMESTAMP: {
                        alldatatypes.setDate(index, (Date)sampleData);
                        continue block20;
                    }
                    case TIMEUUID: {
                        alldatatypes.setUUID(index, (UUID)sampleData);
                        continue block20;
                    }
                    case UUID: {
                        alldatatypes.setUUID(index, (UUID)sampleData);
                        continue block20;
                    }
                    case VARCHAR: {
                        alldatatypes.setString(index, (String)sampleData);
                        continue block20;
                    }
                    case VARINT: {
                        alldatatypes.setVarint(index, (BigInteger)sampleData);
                    }
                }
            }
            PreparedStatement ins = session.prepare("INSERT INTO mytable (a, b) VALUES (?, ?)");
            session.execute((Statement)ins.bind(new Object[]{0, alldatatypes}));
            ResultSet rs = session.execute("SELECT * FROM mytable");
            List rows = rs.all();
            Assert.assertEquals((int)1, (int)rows.size());
            Row row = (Row)rows.get(0);
            Assert.assertEquals((int)row.getInt("a"), (int)0);
            Assert.assertEquals((Object)row.getUDTValue("b"), (Object)alldatatypes);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void testNonPrimitiveDatatypes() throws Exception {
        try {
            session.execute("CREATE KEYSPACE test_nonprimitive_datatypes WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE test_nonprimitive_datatypes");
            DATA_TYPE_PRIMITIVES.remove(DataType.counter());
            ArrayList<String> alpha_type_list = new ArrayList<String>();
            int startIndex = 97;
            for (int i = 0; i < DATA_TYPE_NON_PRIMITIVE_NAMES.size(); ++i) {
                for (int j = 0; j < DATA_TYPE_PRIMITIVES.size(); ++j) {
                    String typeString = DATA_TYPE_NON_PRIMITIVE_NAMES.get(i) == DataType.Name.MAP ? String.format("%s_%s %s<%s, %s>", Character.toString((char)(startIndex + i)), Character.toString((char)(startIndex + j)), DATA_TYPE_NON_PRIMITIVE_NAMES.get(i), DATA_TYPE_PRIMITIVES.get(j).getName(), DATA_TYPE_PRIMITIVES.get(j).getName()) : String.format("%s_%s %s<%s>", Character.toString((char)(startIndex + i)), Character.toString((char)(startIndex + j)), DATA_TYPE_NON_PRIMITIVE_NAMES.get(i), DATA_TYPE_PRIMITIVES.get(j).getName());
                    alpha_type_list.add(typeString);
                }
            }
            session.execute(String.format("CREATE TYPE alldatatypes (%s)", Joiner.on((char)',').join(alpha_type_list)));
            session.execute("CREATE TABLE mytable (a int PRIMARY KEY, b alldatatypes)");
            UserType alldatatypesDef = cluster.getMetadata().getKeyspace("test_nonprimitive_datatypes").getUserType("alldatatypes");
            UDTValue alldatatypes = alldatatypesDef.newValue();
            for (int i = 0; i < DATA_TYPE_NON_PRIMITIVE_NAMES.size(); ++i) {
                block11: for (int j = 0; j < DATA_TYPE_PRIMITIVES.size(); ++j) {
                    DataType.Name name = DATA_TYPE_NON_PRIMITIVE_NAMES.get(i);
                    DataType dataType = DATA_TYPE_PRIMITIVES.get(j);
                    String index = Character.toString((char)(startIndex + i)) + "_" + Character.toString((char)(startIndex + j));
                    Object sample = DataTypeIntegrationTest.getCollectionSample(name, dataType);
                    switch (name) {
                        case LIST: {
                            alldatatypes.setList(index, (List)((ArrayList)sample));
                            continue block11;
                        }
                        case SET: {
                            alldatatypes.setSet(index, (Set)sample);
                            continue block11;
                        }
                        case MAP: {
                            alldatatypes.setMap(index, (Map)((HashMap)sample));
                            continue block11;
                        }
                        case TUPLE: {
                            alldatatypes.setTupleValue(index, (TupleValue)sample);
                        }
                    }
                }
            }
            PreparedStatement ins = session.prepare("INSERT INTO mytable (a, b) VALUES (?, ?)");
            session.execute((Statement)ins.bind(new Object[]{0, alldatatypes}));
            ResultSet rs = session.execute("SELECT * FROM mytable");
            List rows = rs.all();
            Assert.assertEquals((int)1, (int)rows.size());
            Row row = (Row)rows.get(0);
            Assert.assertEquals((int)row.getInt("a"), (int)0);
            Assert.assertEquals((Object)row.getUDTValue("b"), (Object)alldatatypes);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void udtNestedTest() throws Exception {
        int MAX_NESTING_DEPTH = 4;
        try {
            session.execute("CREATE KEYSPACE udtNestedTest WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE udtNestedTest");
            session.execute("CREATE TYPE depth_0 (age int, name text)");
            for (int i = 1; i <= 4; ++i) {
                session.execute(String.format("CREATE TYPE depth_%s (value depth_%s)", String.valueOf(i), String.valueOf(i - 1)));
            }
            session.execute(String.format("CREATE TABLE mytable (a int PRIMARY KEY, b depth_0, c depth_1, d depth_2, e depth_3,f depth_%s)", 4));
            UserType depthZeroDef = cluster.getMetadata().getKeyspace("udtNestedTest").getUserType("depth_0");
            UDTValue depthZero = (UDTValue)((UDTValue)depthZeroDef.newValue().setInt("age", 42)).setString("name", "Bob");
            UserType depthOneDef = cluster.getMetadata().getKeyspace("udtNestedTest").getUserType("depth_1");
            UDTValue depthOne = (UDTValue)depthOneDef.newValue().setUDTValue("value", depthZero);
            UserType depthTwoDef = cluster.getMetadata().getKeyspace("udtNestedTest").getUserType("depth_2");
            UDTValue depthTwo = (UDTValue)depthTwoDef.newValue().setUDTValue("value", depthOne);
            UserType depthThreeDef = cluster.getMetadata().getKeyspace("udtNestedTest").getUserType("depth_3");
            UDTValue depthThree = (UDTValue)depthThreeDef.newValue().setUDTValue("value", depthTwo);
            UserType depthFourDef = cluster.getMetadata().getKeyspace("udtNestedTest").getUserType("depth_4");
            UDTValue depthFour = (UDTValue)depthFourDef.newValue().setUDTValue("value", depthThree);
            PreparedStatement ins = session.prepare("INSERT INTO mytable (a, b, c, d, e, f) VALUES (?, ?, ?, ?, ?, ?)");
            session.execute((Statement)ins.bind(new Object[]{0, depthZero, depthOne, depthTwo, depthThree, depthFour}));
            ResultSet rs = session.execute("SELECT * FROM mytable");
            List rows = rs.all();
            Assert.assertEquals((int)1, (int)rows.size());
            Row row = (Row)rows.get(0);
            Assert.assertEquals((int)row.getInt("a"), (int)0);
            Assert.assertEquals((Object)row.getUDTValue("b"), (Object)depthZero);
            Assert.assertEquals((Object)row.getUDTValue("c"), (Object)depthOne);
            Assert.assertEquals((Object)row.getUDTValue("d"), (Object)depthTwo);
            Assert.assertEquals((Object)row.getUDTValue("e"), (Object)depthThree);
            Assert.assertEquals((Object)row.getUDTValue("f"), (Object)depthFour);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }

    @Test(groups={"short"})
    public void testUdtsWithNulls() throws Exception {
        try {
            session.execute("CREATE KEYSPACE testUdtsWithNulls WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
            session.execute("USE testUdtsWithNulls");
            session.execute("CREATE TYPE user (a text, b int, c uuid, d blob)");
            session.execute("CREATE TABLE mytable (a int PRIMARY KEY, b user)");
            UserType userTypeDef = cluster.getMetadata().getKeyspace("testUdtsWithNulls").getUserType("user");
            UDTValue userType = (UDTValue)((UDTValue)((UDTValue)((UDTValue)userTypeDef.newValue().setString("a", null)).setInt("b", 0)).setUUID("c", null)).setBytes("d", null);
            PreparedStatement ins = session.prepare("INSERT INTO mytable (a, b) VALUES (?, ?)");
            session.execute((Statement)ins.bind(new Object[]{0, userType}));
            ResultSet rs = session.execute("SELECT * FROM mytable");
            List rows = rs.all();
            Assert.assertEquals((int)1, (int)rows.size());
            Row row = (Row)rows.get(0);
            Assert.assertEquals((int)row.getInt("a"), (int)0);
            Assert.assertEquals((Object)row.getUDTValue("b"), (Object)userType);
            userType = (UDTValue)((UDTValue)((UDTValue)((UDTValue)userTypeDef.newValue().setString("a", "")).setInt("b", 0)).setUUID("c", null)).setBytes("d", ByteBuffer.allocate(0));
            session.execute((Statement)ins.bind(new Object[]{0, userType}));
            rs = session.execute("SELECT * FROM mytable");
            rows = rs.all();
            Assert.assertEquals((int)1, (int)rows.size());
            row = (Row)rows.get(0);
            Assert.assertEquals((int)row.getInt("a"), (int)0);
            Assert.assertEquals((Object)row.getUDTValue("b"), (Object)userType);
        }
        catch (Exception e) {
            this.errorOut();
            throw e;
        }
    }
}

