/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.VersionNumber;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VersionNumberTest {
    @Test(groups={"unit"})
    public void versionNumberTest() {
        int i;
        String[] versions = new String[]{"1.2.0", "2.0.0", "2.0.0-beta1", "2.0.0-beta1-SNAPSHOT", "2.0.0-beta1-SNAPSHOT+abc01", "2.0.0.22"};
        VersionNumber[] numbers = new VersionNumber[versions.length];
        for (i = 0; i < versions.length; ++i) {
            numbers[i] = VersionNumber.parse((String)versions[i]);
        }
        for (i = 0; i < versions.length; ++i) {
            Assert.assertEquals((String)numbers[i].toString(), (String)versions[i]);
        }
        Assert.assertEquals((int)numbers[0].compareTo(numbers[1]), (int)-1);
        Assert.assertEquals((int)numbers[1].compareTo(numbers[2]), (int)1);
        Assert.assertEquals((int)numbers[2].compareTo(numbers[3]), (int)-1);
        Assert.assertEquals((int)numbers[3].compareTo(numbers[4]), (int)0);
        Assert.assertEquals((int)numbers[1].compareTo(numbers[5]), (int)-1);
        VersionNumber deb = VersionNumber.parse((String)"2.0.0~beta1");
        Assert.assertEquals((Object)deb, (Object)numbers[2]);
        VersionNumber shorter = VersionNumber.parse((String)"2.0");
        Assert.assertEquals((Object)shorter, (Object)numbers[1]);
    }
}

