/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryBuilderExecutionTest
extends CCMBridge.PerClassSingleNodeCluster {
    private static final String TABLE1 = "test1";

    @Override
    protected Collection<String> getTableDefinitions() {
        return Arrays.asList(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", TABLE1), "CREATE TABLE dateTest (t timestamp PRIMARY KEY)", "CREATE TYPE udt (i int)");
    }

    @Test(groups={"short"})
    public void executeTest() throws Exception {
        session.execute((Statement)QueryBuilder.insertInto((String)TABLE1).value("k", (Object)"k1").value("t", (Object)"This is a test").value("i", (Object)3).value("f", (Object)0.42));
        session.execute((Statement)QueryBuilder.update((String)TABLE1).with(QueryBuilder.set((String)"t", (Object)"Another test")).where(QueryBuilder.eq((String)"k", (Object)"k2")));
        List rows = session.execute((Statement)QueryBuilder.select().from(TABLE1).where(QueryBuilder.in((String)"k", (Object[])new Object[]{"k1", "k2"}))).all();
        Assert.assertEquals((int)2, (int)rows.size());
        Row r1 = (Row)rows.get(0);
        Assert.assertEquals((String)"k1", (String)r1.getString("k"));
        Assert.assertEquals((String)"This is a test", (String)r1.getString("t"));
        Assert.assertEquals((int)3, (int)r1.getInt("i"));
        Assert.assertFalse((boolean)r1.isNull("f"));
        Row r2 = (Row)rows.get(1);
        Assert.assertEquals((String)"k2", (String)r2.getString("k"));
        Assert.assertEquals((String)"Another test", (String)r2.getString("t"));
        Assert.assertTrue((boolean)r2.isNull("i"));
        Assert.assertTrue((boolean)r2.isNull("f"));
    }

    @Test(groups={"short"})
    public void dateHandlingTest() throws Exception {
        Date d = new Date();
        session.execute((Statement)QueryBuilder.insertInto((String)"dateTest").value("t", (Object)d));
        String query = QueryBuilder.select().from("dateTest").where(QueryBuilder.eq((String)QueryBuilder.token((String)"t"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{d}))).toString();
        List rows = session.execute(query).all();
        Assert.assertEquals((int)1, (int)rows.size());
        Row r1 = (Row)rows.get(0);
        Assert.assertEquals((Object)d, (Object)r1.getDate("t"));
    }

    @Test(groups={"unit"})
    public void prepareTest() throws Exception {
        String query = "INSERT INTO foo(a,b,c,d) VALUES ('foo','bar',?,0);";
        Insert stmt = QueryBuilder.insertInto((String)"foo").value("a", (Object)"foo").value("b", (Object)"bar").value("c", (Object)QueryBuilder.bindMarker()).value("d", (Object)0);
        Assert.assertEquals((String)query, (String)stmt.getQueryString());
    }

    @Test(groups={"short"})
    public void batchNonBuiltStatementTest() throws Exception {
        SimpleStatement simple = new SimpleStatement("INSERT INTO test1 (k, t) VALUES (?, ?)", new Object[]{"batchTest1", "val1"});
        Insert built = QueryBuilder.insertInto((String)TABLE1).value("k", (Object)"batchTest2").value("t", (Object)"val2");
        session.execute((Statement)QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)simple).add((RegularStatement)built));
        List rows = session.execute((Statement)QueryBuilder.select().from(TABLE1).where(QueryBuilder.in((String)"k", (Object[])new Object[]{"batchTest1", "batchTest2"}))).all();
        Assert.assertEquals((int)2, (int)rows.size());
        Row r1 = (Row)rows.get(0);
        Assert.assertEquals((String)"batchTest1", (String)r1.getString("k"));
        Assert.assertEquals((String)"val1", (String)r1.getString("t"));
        Row r2 = (Row)rows.get(1);
        Assert.assertEquals((String)"batchTest2", (String)r2.getString("k"));
        Assert.assertEquals((String)"val2", (String)r2.getString("t"));
    }

    @Test(groups={"short"})
    public void insertUdtTest() throws Exception {
        UserType udtType = cluster.getMetadata().getKeyspace("ks").getUserType("udt");
        UDTValue udtValue = (UDTValue)udtType.newValue().setInt("i", 2);
        Insert insert = QueryBuilder.insertInto((String)"udtTest").value("i", (Object)1).value("t", (Object)udtValue);
        Assert.assertEquals((String)insert.toString(), (String)"INSERT INTO udtTest(i,t) VALUES (1,{i:2});");
    }
}

