/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryBuilderITest
extends CCMBridge.PerClassSingleNodeCluster {
    private static final String TABLE_TEXT = "test_text";
    private static final String TABLE_INT = "test_int";

    @Override
    protected Collection<String> getTableDefinitions() {
        return Arrays.asList(String.format("CREATE TABLE %s (k text PRIMARY KEY, a int, b int)", TABLE_TEXT), String.format("CREATE TABLE %s (k int PRIMARY KEY, a int, b int)", TABLE_INT));
    }

    @Test(groups={"short"})
    public void remainingDeleteTests() throws Exception {
        TableMetadata table = cluster.getMetadata().getKeyspace("ks").getTable(TABLE_TEXT);
        Assert.assertNotNull((Object)table);
        String expected = "DELETE k FROM ks.test_text;";
        Delete query = QueryBuilder.delete((String[])new String[]{"k"}).from(table);
        Assert.assertEquals((String)query.toString(), (String)expected);
        try {
            session.execute((Statement)query);
            Assert.fail();
        }
        catch (SyntaxError e) {
            // empty catch block
        }
    }

    @Test(groups={"short"})
    public void selectInjectionTests() throws Exception {
        session.execute("CREATE KEYSPACE foo WITH replication = {'class': 'SimpleStrategy', 'replication_factor': 1};");
        session.execute("CREATE TABLE foo.foo ( k ascii PRIMARY KEY , i int, s ascii )");
        session.execute("USE foo");
        String query = "SELECT * FROM foo WHERE k=?;";
        Select.Where select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)QueryBuilder.bindMarker()));
        System.out.println(select.toString());
        System.out.println(session);
        PreparedStatement ps = session.prepare(select.toString());
        BoundStatement bs = ps.bind();
        Assert.assertEquals((String)select.toString(), (String)query);
        session.execute((Statement)bs.setString("k", "4 AND c=5"));
        query = "SELECT * FROM foo WHERE k='4'' AND c=''5';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' AND c='5"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4'' OR ''1''=''1';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' OR '1'='1"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4; --test comment;';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4; --test comment;"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT \"*\" FROM foo;";
        select = QueryBuilder.select((String[])new String[]{"*"}).from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a,b FROM foo WHERE a IN ('b','c''); --comment');";
        select = QueryBuilder.select((String[])new String[]{"a", "b"}).from("foo").where(QueryBuilder.in((String)"a", (Object[])new Object[]{"b", "c'); --comment"}));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM bar; --(b) FROM foo;";
        select = QueryBuilder.select().fcall("* FROM bar; --", new Object[]{QueryBuilder.column((String)"b")}).from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT writetime(\"a) FROM bar; --\"),ttl(a) FROM foo ALLOW FILTERING;";
        select = QueryBuilder.select().writeTime("a) FROM bar; --").ttl("a").from("foo").allowFiltering();
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT writetime(a),ttl(\"a) FROM bar; --\") FROM foo ALLOW FILTERING;";
        select = QueryBuilder.select().writeTime("a").ttl("a) FROM bar; --").from("foo").allowFiltering();
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE \"k=1 OR k\">42 LIMIT 42;";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)"k=1 OR k", (Object)42)).limit(42);
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE token(\"k)>0 OR token(k\")>token(42);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)QueryBuilder.token((String)"k)>0 OR token(k"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42})));
        Assert.assertEquals((String)select.toString(), (String)query);
    }

    @Test(groups={"short"})
    public void insertInjectionTest() throws Exception {
        String query = "INSERT INTO foo(a) VALUES ('123); --comment');";
        Insert insert = QueryBuilder.insertInto((String)"foo").value("a", (Object)"123); --comment");
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo(\"a,b\") VALUES (123);";
        insert = QueryBuilder.insertInto((String)"foo").value("a,b", (Object)123);
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo(a,b) VALUES ({'2''} space','3','4'},3.4) USING TTL 24 AND TIMESTAMP 42;";
        insert = QueryBuilder.insertInto((String)"foo").values(new String[]{"a", "b"}, new Object[]{new TreeSet<String>(){
            {
                this.add("2'} space");
                this.add("3");
                this.add("4");
            }
        }, 3.4}).using(QueryBuilder.ttl((int)24)).and(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)insert.toString(), (String)query);
    }

    @Test(groups={"short"})
    public void updateInjectionTest() throws Exception {
        String query = "UPDATE foo.bar USING TIMESTAMP 42 SET a=12 WHERE k='2 OR 1=1';";
        Update.Where update = QueryBuilder.update((String)"foo", (String)"bar").using(QueryBuilder.timestamp((long)42L)).with(QueryBuilder.set((String)"a", (Object)12)).where(QueryBuilder.eq((String)"k", (Object)"2 OR 1=1"));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b='null WHERE k=1; --comment' WHERE k=2;";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).with(QueryBuilder.set((String)"b", (Object)"null WHERE k=1; --comment"));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo USING TIMESTAMP 42 SET \"b WHERE k=1; --comment\"=[3,2,1]+\"b WHERE k=1; --comment\" WHERE k=2;";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).with(QueryBuilder.prependAll((String)"b WHERE k=1; --comment", Arrays.asList(3, 2, 1))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)update.toString(), (String)query);
    }

    @Test(groups={"short"})
    public void deleteInjectionTests() throws Exception {
        String query = "DELETE FROM \"foo WHERE k=4\";";
        Delete delete = QueryBuilder.delete().from("foo WHERE k=4");
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4 AND c=5';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4 AND c=5"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4'' AND c=''5';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' AND c='5"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4'' OR ''1''=''1';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' OR '1'='1"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4; --test comment;';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4; --test comment;"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE \"*\" FROM foo;";
        delete = QueryBuilder.delete((String[])new String[]{"*"}).from("foo");
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a,b FROM foo WHERE a IN ('b','c''); --comment');";
        delete = QueryBuilder.delete((String[])new String[]{"a", "b"}).from("foo").where(QueryBuilder.in((String)"a", (Object[])new Object[]{"b", "c'); --comment"}));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE \"k=1 OR k\">42;";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.gt((String)"k=1 OR k", (Object)42));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE token(\"k)>0 OR token(k\")>token(42);";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.gt((String)QueryBuilder.token((String)"k)>0 OR token(k"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42})));
        Assert.assertEquals((String)delete.toString(), (String)query);
    }
}

