/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryBuilderRoutingKeyTest
extends CCMBridge.PerClassSingleNodeCluster {
    private static final String TABLE_TEXT = "test_text";
    private static final String TABLE_INT = "test_int";

    @Override
    protected Collection<String> getTableDefinitions() {
        return Arrays.asList(String.format("CREATE TABLE %s (k text PRIMARY KEY, a int, b int)", TABLE_TEXT), String.format("CREATE TABLE %s (k int PRIMARY KEY, a int, b int)", TABLE_INT));
    }

    @Test(groups={"short"})
    public void textRoutingKeyTest() throws Exception {
        TableMetadata table = cluster.getMetadata().getKeyspace("ks").getTable(TABLE_TEXT);
        Assert.assertNotNull((Object)table);
        String txt = "If she weighs the same as a duck... she's made of wood.";
        Insert query = QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"k", "a", "b"}, new Object[]{txt, 1, 2});
        Assert.assertEquals((Object)query.getRoutingKey(), (Object)ByteBuffer.wrap(txt.getBytes()));
        session.execute((Statement)query);
        query = QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"k", (Object)txt));
        Assert.assertEquals((Object)query.getRoutingKey(), (Object)ByteBuffer.wrap(txt.getBytes()));
        Row row = session.execute((Statement)query).one();
        Assert.assertEquals((String)row.getString("k"), (String)txt);
        Assert.assertEquals((int)row.getInt("a"), (int)1);
        Assert.assertEquals((int)row.getInt("b"), (int)2);
    }

    @Test(groups={"short"})
    public void intRoutingKeyTest() throws Exception {
        TableMetadata table = cluster.getMetadata().getKeyspace("ks").getTable(TABLE_INT);
        Assert.assertNotNull((Object)table);
        Insert query = QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"k", "a", "b"}, new Object[]{42, 1, 2});
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 42);
        Assert.assertEquals((Object)query.getRoutingKey(), (Object)bb);
        session.execute((Statement)query);
        query = QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"k", (Object)42));
        Assert.assertEquals((Object)query.getRoutingKey(), (Object)bb);
        Row row = session.execute((Statement)query).one();
        Assert.assertEquals((int)row.getInt("k"), (int)42);
        Assert.assertEquals((int)row.getInt("a"), (int)1);
        Assert.assertEquals((int)row.getInt("b"), (int)2);
    }

    @Test(groups={"short"})
    public void intRoutingBatchKeyTest() throws Exception {
        TableMetadata table = cluster.getMetadata().getKeyspace("ks").getTable(TABLE_INT);
        Assert.assertNotNull((Object)table);
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putInt(0, 42);
        Select.Where query = QueryBuilder.select().from(table).where(QueryBuilder.eq((String)"k", (Object)42));
        String batch_query = "BEGIN BATCH ";
        batch_query = batch_query + "INSERT INTO ks.test_int(k,a) VALUES (42,1);";
        batch_query = batch_query + "UPDATE ks.test_int USING TTL 400;";
        batch_query = batch_query + "APPLY BATCH;";
        Batch batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.insertInto((TableMetadata)table).values(new String[]{"k", "a"}, new Object[]{42, 1})).add((RegularStatement)QueryBuilder.update((TableMetadata)table).using(QueryBuilder.ttl((int)400)));
        Assert.assertEquals((Object)batch.getRoutingKey(), (Object)bb);
        Assert.assertEquals((String)batch.toString(), (String)batch_query);
        batch_query = "BEGIN BATCH ";
        batch_query = batch_query + "SELECT * FROM ks.test_int WHERE k=42;";
        batch_query = batch_query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[]{query});
        Assert.assertEquals((Object)batch.getRoutingKey(), (Object)bb);
        Assert.assertEquals((String)batch.toString(), (String)batch_query);
        batch_query = "BEGIN BATCH ";
        batch_query = batch_query + "SELECT * FROM foo WHERE k=42;";
        batch_query = batch_query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.select().from("foo").where(QueryBuilder.eq((String)"k", (Object)42)));
        Assert.assertEquals((Object)batch.getRoutingKey(), null);
        Assert.assertEquals((String)batch.toString(), (String)batch_query);
        batch_query = "BEGIN BATCH USING TIMESTAMP 42 ";
        batch_query = batch_query + "INSERT INTO foo.bar(a) VALUES (123);";
        batch_query = batch_query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).using(QueryBuilder.timestamp((long)42L)).add((RegularStatement)QueryBuilder.insertInto((String)"foo", (String)"bar").value("a", (Object)123));
        Assert.assertEquals((Object)batch.getRoutingKey(), null);
        Assert.assertEquals((String)batch.toString(), (String)batch_query);
    }
}

