/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.querybuilder.Batch;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryBuilderTest {
    @Test(groups={"unit"})
    public void selectTest() throws Exception {
        String query = "SELECT * FROM foo WHERE k=4 AND c>'a' AND c<='z';";
        Select.Where select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.gt((String)"c", (Object)"a")).and(QueryBuilder.lte((String)"c", (Object)"z"));
        Assert.assertEquals((String)select.toString(), (String)query);
        select = QueryBuilder.select().all().from("foo").where().and(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.gt((String)"c", (Object)"a")).and(QueryBuilder.lte((String)"c", (Object)"z"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a,b,\"C\" FROM foo WHERE a IN ('127.0.0.1','127.0.0.3') AND \"C\"='foo' ORDER BY a ASC,b DESC LIMIT 42;";
        select = QueryBuilder.select((String[])new String[]{"a", "b", QueryBuilder.quote((String)"C")}).from("foo").where(QueryBuilder.in((String)"a", (Object[])new Object[]{InetAddress.getByName("127.0.0.1"), InetAddress.getByName("127.0.0.3")})).and(QueryBuilder.eq((String)QueryBuilder.quote((String)"C"), (Object)"foo")).orderBy(new Ordering[]{QueryBuilder.asc((String)"a"), QueryBuilder.desc((String)"b")}).limit(42);
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT writetime(a),ttl(a) FROM foo ALLOW FILTERING;";
        select = QueryBuilder.select().writeTime("a").ttl("a").from("foo").allowFiltering();
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT DISTINCT longName AS a,ttl(longName) AS ttla FROM foo LIMIT :limit;";
        select = QueryBuilder.select().distinct().column("longName").as("a").ttl("longName").as("ttla").from("foo").limit(QueryBuilder.bindMarker((String)"limit"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT DISTINCT longName AS a,ttl(longName) AS ttla FROM foo WHERE k IN () LIMIT :limit;";
        select = QueryBuilder.select().distinct().column("longName").as("a").ttl("longName").as("ttla").from("foo").where(QueryBuilder.in((String)"k", (Object[])new Object[0])).limit(QueryBuilder.bindMarker((String)"limit"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE bar=:barmark AND baz=:bazmark LIMIT :limit;";
        select = QueryBuilder.select().all().from("foo").where().and(QueryBuilder.eq((String)"bar", (Object)QueryBuilder.bindMarker((String)"barmark"))).and(QueryBuilder.eq((String)"baz", (Object)QueryBuilder.bindMarker((String)"bazmark"))).limit(QueryBuilder.bindMarker((String)"limit"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a FROM foo WHERE k IN ();";
        select = QueryBuilder.select((String[])new String[]{"a"}).from("foo").where(QueryBuilder.in((String)"k", (Object[])new Object[0]));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a FROM foo WHERE k IN ?;";
        select = QueryBuilder.select((String[])new String[]{"a"}).from("foo").where(QueryBuilder.in((String)"k", (Object[])new Object[]{QueryBuilder.bindMarker()}));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT count(*) FROM foo;";
        select = QueryBuilder.select().countAll().from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT intToBlob(b) FROM foo;";
        select = QueryBuilder.select().fcall("intToBlob", new Object[]{QueryBuilder.column((String)"b")}).from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k>42 LIMIT 42;";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)"k", (Object)42)).limit(42);
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE token(k)>token(42);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)QueryBuilder.token((String)"k"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42})));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo2 WHERE token(a,b)>token(42,101);";
        select = QueryBuilder.select().all().from("foo2").where(QueryBuilder.gt((String)QueryBuilder.token((String[])new String[]{"a", "b"}), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42, 101})));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM words WHERE w='):,ydL ;O,D';";
        select = QueryBuilder.select().all().from("words").where(QueryBuilder.eq((String)"w", (Object)"):,ydL ;O,D"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM words WHERE w='WA(!:gS)r(UfW';";
        select = QueryBuilder.select().all().from("words").where(QueryBuilder.eq((String)"w", (Object)"WA(!:gS)r(UfW"));
        Assert.assertEquals((String)select.toString(), (String)query);
        try {
            select = QueryBuilder.select().countAll().from("foo").orderBy(new Ordering[]{QueryBuilder.asc((String)"a"), QueryBuilder.desc((String)"b")}).orderBy(new Ordering[]{QueryBuilder.asc((String)"a"), QueryBuilder.desc((String)"b")});
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"An ORDER BY clause has already been provided");
        }
        try {
            select = QueryBuilder.select().column("a").all().from("foo");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Some columns ([a]) have already been selected.");
        }
        try {
            select = QueryBuilder.select().column("a").countAll().from("foo");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Some columns ([a]) have already been selected.");
        }
        try {
            select = QueryBuilder.select().all().from("foo").limit(-42);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid LIMIT value, must be strictly positive");
        }
        try {
            select = QueryBuilder.select().all().from("foo").limit(42).limit(42);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"A LIMIT value has already been provided");
        }
    }

    @Test(groups={"unit"})
    public void insertTest() throws Exception {
        String query = "INSERT INTO foo(a,b,\"C\",d) VALUES (123,'127.0.0.1','foo''bar',{'x':3,'y':2}) USING TIMESTAMP 42 AND TTL 24;";
        Insert.Options insert = QueryBuilder.insertInto((String)"foo").value("a", (Object)123).value("b", (Object)InetAddress.getByName("127.0.0.1")).value(QueryBuilder.quote((String)"C"), (Object)"foo'bar").value("d", (Object)new TreeMap<String, Integer>(){
            {
                this.put("x", 3);
                this.put("y", 2);
            }
        }).using(QueryBuilder.timestamp((long)42L)).and(QueryBuilder.ttl((int)24));
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo(a,b) VALUES (2,null);";
        insert = QueryBuilder.insertInto((String)"foo").value("a", (Object)2).value("b", null);
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo(a,b) VALUES ({2,3,4},3.4) USING TTL 24 AND TIMESTAMP 42;";
        insert = QueryBuilder.insertInto((String)"foo").values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4}).using(QueryBuilder.ttl((int)24)).and(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo.bar(a,b) VALUES ({2,3,4},3.4) USING TTL ? AND TIMESTAMP ?;";
        insert = QueryBuilder.insertInto((String)"foo", (String)"bar").values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4}).using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker())).and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker()));
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo.bar(a,b,c) VALUES ({2,3,4},3.4,123) USING TIMESTAMP 42;";
        insert = QueryBuilder.insertInto((String)"foo", (String)"bar").using(QueryBuilder.timestamp((long)42L)).values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4}).value("c", (Object)123);
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo(c,a,b) VALUES (123,{2,3,4},3.4) USING TIMESTAMP 42;";
        insert = QueryBuilder.insertInto((String)"foo").using(QueryBuilder.timestamp((long)42L)).value("c", (Object)123).values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4});
        Assert.assertEquals((String)insert.toString(), (String)query);
        try {
            insert = QueryBuilder.insertInto((String)"foo").values(new String[]{"a", "b"}, new Object[]{1, 2, 3});
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Got 2 names but 3 values");
        }
        query = "INSERT INTO foo(k,x) VALUES (0,1) IF NOT EXISTS;";
        insert = QueryBuilder.insertInto((String)"foo").value("k", (Object)0).value("x", (Object)1).ifNotExists();
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo(k,x) VALUES (0,(1));";
        insert = QueryBuilder.insertInto((String)"foo").value("k", (Object)0).value("x", (Object)TupleType.of((DataType[])new DataType[]{DataType.cint()}).newValue(new Object[]{1}));
        Assert.assertEquals((String)insert.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void updateTest() throws Exception {
        String query = "UPDATE foo.bar USING TIMESTAMP 42 SET a=12,b=[3,2,1],c=c+3 WHERE k=2;";
        Update.Where update = QueryBuilder.update((String)"foo", (String)"bar").using(QueryBuilder.timestamp((long)42L)).with(QueryBuilder.set((String)"a", (Object)12)).and(QueryBuilder.set((String)"b", Arrays.asList(3, 2, 1))).and(QueryBuilder.incr((String)"c", (long)3L)).where(QueryBuilder.eq((String)"k", (Object)2));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b=null WHERE k=2;";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).with(QueryBuilder.set((String)"b", null));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET a[2]='foo',b=[3,2,1]+b,c=c-{'a'} WHERE k=2 AND l='foo' AND m<4 AND n>=1;";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.setIdx((String)"a", (int)2, (Object)"foo")).and(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1))).and(QueryBuilder.remove((String)"c", (Object)"a")).where(QueryBuilder.eq((String)"k", (Object)2)).and(QueryBuilder.eq((String)"l", (Object)"foo")).and(QueryBuilder.lt((String)"m", (Object)4)).and(QueryBuilder.gte((String)"n", (Object)1));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b=[3]+b,c=c+['a'],d=d+[1,2,3],e=e-[1];";
        update = QueryBuilder.update((String)"foo").with().and(QueryBuilder.prepend((String)"b", (Object)3)).and(QueryBuilder.append((String)"c", (Object)"a")).and(QueryBuilder.appendAll((String)"d", Arrays.asList(1, 2, 3))).and(QueryBuilder.discard((String)"e", (Object)1));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b=b-[1,2,3],c=c+{1},d=d+{2,3,4};";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.discardAll((String)"b", Arrays.asList(1, 2, 3))).and(QueryBuilder.add((String)"c", (Object)1)).and(QueryBuilder.addAll((String)"d", (Set)new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b=b-{2,3,4},c['k']='v',d=d+{'x':3,'y':2};";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.removeAll((String)"b", (Set)new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        })).and(QueryBuilder.put((String)"c", (Object)"k", (Object)"v")).and(QueryBuilder.putAll((String)"d", (Map)new TreeMap<String, Integer>(){
            {
                this.put("x", 3);
                this.put("y", 2);
            }
        }));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo USING TTL 400;";
        update = QueryBuilder.update((String)"foo").using(QueryBuilder.ttl((int)400));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET a=" + new BigDecimal(3.2) + ",b=42 WHERE k=2;";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"a", (Object)new BigDecimal(3.2))).and(QueryBuilder.set((String)"b", (Object)new BigInteger("42"))).where(QueryBuilder.eq((String)"k", (Object)2));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo USING TIMESTAMP 42 SET b=[3,2,1]+b WHERE k=2 AND l='foo';";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).and(QueryBuilder.eq((String)"l", (Object)"foo")).with(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)update.toString(), (String)query);
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).and(QueryBuilder.eq((String)"l", (Object)"foo")).using(QueryBuilder.timestamp((long)42L)).with(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1)));
        Assert.assertEquals((String)update.toString(), (String)query);
        update = QueryBuilder.update((String)"foo").using(QueryBuilder.timestamp((long)42L)).where(QueryBuilder.eq((String)"k", (Object)2)).and(QueryBuilder.eq((String)"l", (Object)"foo")).with(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1)));
        Assert.assertEquals((String)update.toString(), (String)query);
        try {
            update = QueryBuilder.update((String)"foo").using(QueryBuilder.ttl((int)-400));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid ttl, must be positive");
        }
        query = "UPDATE foo SET x=4 WHERE k=0 IF x=1;";
        update = QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"x", (Object)4)).where(QueryBuilder.eq((String)"k", (Object)0)).onlyIf(QueryBuilder.eq((String)"x", (Object)1));
        Assert.assertEquals((String)update.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void deleteTest() throws Exception {
        String query = "DELETE a,b,c FROM foo USING TIMESTAMP 0 WHERE k=1;";
        Delete.Where delete = QueryBuilder.delete((String[])new String[]{"a", "b", "c"}).from("foo").using(QueryBuilder.timestamp((long)0L)).where(QueryBuilder.eq((String)"k", (Object)1));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a[3],b['foo'],c FROM foo WHERE k=1;";
        delete = QueryBuilder.delete().listElt("a", 3).mapElt("b", (Object)"foo").column("c").from("foo").where(QueryBuilder.eq((String)"k", (Object)1));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a,b,c FROM foo;";
        delete = QueryBuilder.delete((String[])new String[]{"a", "b", "c"}).from("foo");
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo USING TIMESTAMP 1240003134 WHERE k='value';";
        delete = QueryBuilder.delete().all().from("foo").using(QueryBuilder.timestamp((long)1240003134L)).where(QueryBuilder.eq((String)"k", (Object)"value"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        delete = QueryBuilder.delete().from("foo").using(QueryBuilder.timestamp((long)1240003134L)).where(QueryBuilder.eq((String)"k", (Object)"value"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a,b,c FROM foo.bar USING TIMESTAMP 1240003134 WHERE k=1;";
        delete = QueryBuilder.delete((String[])new String[]{"a", "b", "c"}).from("foo", "bar").where().and(QueryBuilder.eq((String)"k", (Object)1)).using(QueryBuilder.timestamp((long)1240003134L));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo.bar WHERE k1='foo' AND k2=1;";
        delete = QueryBuilder.delete().from("foo", "bar").where(QueryBuilder.eq((String)"k1", (Object)"foo")).and(QueryBuilder.eq((String)"k2", (Object)1));
        Assert.assertEquals((String)delete.toString(), (String)query);
        try {
            delete = QueryBuilder.delete().column("a").all().from("foo");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Some columns ([a]) have already been selected.");
        }
        try {
            delete = QueryBuilder.delete().from("foo").using(QueryBuilder.timestamp((long)-1240003134L));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid timestamp, must be positive");
        }
    }

    @Test(groups={"unit"})
    public void batchTest() throws Exception {
        String query = "BEGIN BATCH USING TIMESTAMP 42 ";
        query = query + "INSERT INTO foo(a,b) VALUES ({2,3,4},3.4);";
        query = query + "UPDATE foo SET a[2]='foo',b=[3,2,1]+b,c=c-{'a'} WHERE k=2;";
        query = query + "DELETE a[3],b['foo'],c FROM foo WHERE k=1;";
        query = query + "APPLY BATCH;";
        Batch.Options batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.insertInto((String)"foo").values(new String[]{"a", "b"}, new Object[]{new TreeSet<Integer>(){
            {
                this.add(2);
                this.add(3);
                this.add(4);
            }
        }, 3.4})).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.setIdx((String)"a", (int)2, (Object)"foo")).and(QueryBuilder.prependAll((String)"b", Arrays.asList(3, 2, 1))).and(QueryBuilder.remove((String)"c", (Object)"a")).where(QueryBuilder.eq((String)"k", (Object)2))).add((RegularStatement)QueryBuilder.delete().listElt("a", 3).mapElt("b", (Object)"foo").column("c").from("foo").where(QueryBuilder.eq((String)"k", (Object)1))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN BATCH ";
        query = query + "DELETE a[3] FROM foo WHERE k=1;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[]{QueryBuilder.delete().listElt("a", 3).from("foo").where(QueryBuilder.eq((String)"k", (Object)1))});
        Assert.assertEquals((String)batch.toString(), (String)query);
        Assert.assertEquals((String)QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).toString(), (String)"BEGIN BATCH APPLY BATCH;");
    }

    @Test(groups={"unit"})
    public void batchCounterTest() throws Exception {
        String query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a+1;";
        query = query + "UPDATE foo SET b=b+2;";
        query = query + "UPDATE foo SET c=c+3;";
        query = query + "APPLY BATCH;";
        Batch.Options batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"a", (long)1L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"b", (long)2L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"c", (long)3L))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a+1;";
        query = query + "UPDATE foo SET b=b+1;";
        query = query + "UPDATE foo SET c=c+1;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"a"))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"b"))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"c"))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a-1;";
        query = query + "UPDATE foo SET b=b-2;";
        query = query + "UPDATE foo SET c=c-3;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"a", (long)1L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"b", (long)2L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"c", (long)3L))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a-1;";
        query = query + "UPDATE foo SET b=b-1;";
        query = query + "UPDATE foo SET c=c-1;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"a"))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"b"))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"c"))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
        query = "BEGIN COUNTER BATCH USING TIMESTAMP 42 ";
        query = query + "UPDATE foo SET a=a+1;";
        query = query + "UPDATE foo SET b=b+-2;";
        query = query + "UPDATE foo SET c=c-3;";
        query = query + "APPLY BATCH;";
        batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"a", (long)-1L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"b", (long)-2L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.decr((String)"c", (long)3L))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)batch.toString(), (String)query);
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void batchMixedCounterTest() throws Exception {
        Batch.Options batch = QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"a", (long)1L))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"b", (Object)2))).add((RegularStatement)QueryBuilder.update((String)"foo").with(QueryBuilder.incr((String)"c", (long)3L))).using(QueryBuilder.timestamp((long)42L));
    }

    @Test(groups={"unit"})
    public void markerTest() throws Exception {
        String query = "INSERT INTO test(k,c) VALUES (0,?);";
        Insert insert = QueryBuilder.insertInto((String)"test").value("k", (Object)0).value("c", (Object)QueryBuilder.bindMarker());
        Assert.assertEquals((String)insert.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void rawEscapingTest() throws Exception {
        String query = "SELECT * FROM t WHERE c='C''est la vie!';";
        Select.Where select = QueryBuilder.select().from("t").where(QueryBuilder.eq((String)"c", (Object)"C'est la vie!"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM t WHERE c=C'est la vie!;";
        select = QueryBuilder.select().from("t").where(QueryBuilder.eq((String)"c", (Object)QueryBuilder.raw((String)"C'est la vie!")));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM t WHERE c=now();";
        select = QueryBuilder.select().from("t").where(QueryBuilder.eq((String)"c", (Object)QueryBuilder.fcall((String)"now", (Object[])new Object[0])));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM t WHERE c='now()';";
        select = QueryBuilder.select().from("t").where(QueryBuilder.eq((String)"c", (Object)QueryBuilder.raw((String)"'now()'")));
        Assert.assertEquals((String)select.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void selectInjectionTests() throws Exception {
        String query = "SELECT * FROM \"foo WHERE k=4\";";
        Select select = QueryBuilder.select().all().from("foo WHERE k=4");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4 AND c=5';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4 AND c=5"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4'' AND c=''5';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' AND c='5"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4'' OR ''1''=''1';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' OR '1'='1"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k='4; --test comment;';";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4; --test comment;"));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT \"*\" FROM foo;";
        select = QueryBuilder.select((String[])new String[]{"*"}).from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT a,b FROM foo WHERE a IN ('b','c''); --comment');";
        select = QueryBuilder.select((String[])new String[]{"a", "b"}).from("foo").where(QueryBuilder.in((String)"a", (Object[])new Object[]{"b", "c'); --comment"}));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM bar; --(b) FROM foo;";
        select = QueryBuilder.select().fcall("* FROM bar; --", new Object[]{QueryBuilder.column((String)"b")}).from("foo");
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT writetime(\"a) FROM bar; --\"),ttl(a) FROM foo ALLOW FILTERING;";
        select = QueryBuilder.select().writeTime("a) FROM bar; --").ttl("a").from("foo").allowFiltering();
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT writetime(a),ttl(\"a) FROM bar; --\") FROM foo ALLOW FILTERING;";
        select = QueryBuilder.select().writeTime("a").ttl("a) FROM bar; --").from("foo").allowFiltering();
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE \"k=1 OR k\">42 LIMIT 42;";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)"k=1 OR k", (Object)42)).limit(42);
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE token(\"k)>0 OR token(k\")>token(42);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.gt((String)QueryBuilder.token((String)"k)>0 OR token(k"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42})));
        Assert.assertEquals((String)select.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void insertInjectionTest() throws Exception {
        String query = "INSERT INTO foo(a) VALUES ('123); --comment');";
        Insert insert = QueryBuilder.insertInto((String)"foo").value("a", (Object)"123); --comment");
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo(\"a,b\") VALUES (123);";
        insert = QueryBuilder.insertInto((String)"foo").value("a,b", (Object)123);
        Assert.assertEquals((String)insert.toString(), (String)query);
        query = "INSERT INTO foo(a,b) VALUES ({'2''} space','3','4'},3.4) USING TTL 24 AND TIMESTAMP 42;";
        insert = QueryBuilder.insertInto((String)"foo").values(new String[]{"a", "b"}, new Object[]{new TreeSet<String>(){
            {
                this.add("2'} space");
                this.add("3");
                this.add("4");
            }
        }, 3.4}).using(QueryBuilder.ttl((int)24)).and(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)insert.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void updateInjectionTest() throws Exception {
        String query = "UPDATE foo.bar USING TIMESTAMP 42 SET a=12 WHERE k='2 OR 1=1';";
        Update.Where update = QueryBuilder.update((String)"foo", (String)"bar").using(QueryBuilder.timestamp((long)42L)).with(QueryBuilder.set((String)"a", (Object)12)).where(QueryBuilder.eq((String)"k", (Object)"2 OR 1=1"));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo SET b='null WHERE k=1; --comment' WHERE k=2;";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).with(QueryBuilder.set((String)"b", (Object)"null WHERE k=1; --comment"));
        Assert.assertEquals((String)update.toString(), (String)query);
        query = "UPDATE foo USING TIMESTAMP 42 SET \"b WHERE k=1; --comment\"=[3,2,1]+\"b WHERE k=1; --comment\" WHERE k=2;";
        update = QueryBuilder.update((String)"foo").where().and(QueryBuilder.eq((String)"k", (Object)2)).with(QueryBuilder.prependAll((String)"b WHERE k=1; --comment", Arrays.asList(3, 2, 1))).using(QueryBuilder.timestamp((long)42L));
        Assert.assertEquals((String)update.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void deleteInjectionTests() throws Exception {
        String query = "DELETE FROM \"foo WHERE k=4\";";
        Delete delete = QueryBuilder.delete().from("foo WHERE k=4");
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4 AND c=5';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4 AND c=5"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4'' AND c=''5';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' AND c='5"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4'' OR ''1''=''1';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4' OR '1'='1"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE k='4; --test comment;';";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.eq((String)"k", (Object)"4; --test comment;"));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE \"*\" FROM foo;";
        delete = QueryBuilder.delete((String[])new String[]{"*"}).from("foo");
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE a,b FROM foo WHERE a IN ('b','c''); --comment');";
        delete = QueryBuilder.delete((String[])new String[]{"a", "b"}).from("foo").where(QueryBuilder.in((String)"a", (Object[])new Object[]{"b", "c'); --comment"}));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE \"k=1 OR k\">42;";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.gt((String)"k=1 OR k", (Object)42));
        Assert.assertEquals((String)delete.toString(), (String)query);
        query = "DELETE FROM foo WHERE token(\"k)>0 OR token(k\")>token(42);";
        delete = QueryBuilder.delete().from("foo").where(QueryBuilder.gt((String)QueryBuilder.token((String)"k)>0 OR token(k"), (Object)QueryBuilder.fcall((String)"token", (Object[])new Object[]{42})));
        Assert.assertEquals((String)delete.toString(), (String)query);
    }

    @Test(groups={"unit"})
    public void statementForwardingTest() throws Exception {
        Update upd = QueryBuilder.update((String)"foo");
        upd.setConsistencyLevel(ConsistencyLevel.QUORUM);
        upd.enableTracing();
        Update.Where query = upd.using(QueryBuilder.timestamp((long)42L)).with(QueryBuilder.set((String)"a", (Object)12)).and(QueryBuilder.incr((String)"c", (long)3L)).where(QueryBuilder.eq((String)"k", (Object)2));
        Assert.assertEquals((Object)query.getConsistencyLevel(), (Object)ConsistencyLevel.QUORUM);
        Assert.assertTrue((boolean)query.isTracing());
    }

    @Test(groups={"unit"})
    public void rejectUnknownValueTest() throws Exception {
        try {
            QueryBuilder.update((String)"foo").with(QueryBuilder.set((String)"a", (Object)new byte[13])).where(QueryBuilder.eq((String)"k", (Object)2)).toString();
            Assert.fail((String)"Byte arrays should not be valid, ByteBuffer should be used instead");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(groups={"unit"})
    public void truncateTest() throws Exception {
        Assert.assertEquals((String)QueryBuilder.truncate((String)"foo").toString(), (String)"TRUNCATE foo;");
        Assert.assertEquals((String)QueryBuilder.truncate((String)"foo", (String)QueryBuilder.quote((String)"Bar")).toString(), (String)"TRUNCATE foo.\"Bar\";");
    }

    @Test(groups={"unit"})
    public void quotingTest() {
        Assert.assertEquals((String)QueryBuilder.select().from("Metrics", "epochs").getQueryString(), (String)"SELECT * FROM Metrics.epochs;");
        Assert.assertEquals((String)QueryBuilder.select().from("Metrics", QueryBuilder.quote((String)"epochs")).getQueryString(), (String)"SELECT * FROM Metrics.\"epochs\";");
        Assert.assertEquals((String)QueryBuilder.select().from(QueryBuilder.quote((String)"Metrics"), "epochs").getQueryString(), (String)"SELECT * FROM \"Metrics\".epochs;");
        Assert.assertEquals((String)QueryBuilder.select().from(QueryBuilder.quote((String)"Metrics"), QueryBuilder.quote((String)"epochs")).getQueryString(), (String)"SELECT * FROM \"Metrics\".\"epochs\";");
        Assert.assertEquals((String)QueryBuilder.insertInto((String)"Metrics", (String)"epochs").getQueryString(), (String)"INSERT INTO Metrics.epochs() VALUES ();");
        Assert.assertEquals((String)QueryBuilder.insertInto((String)"Metrics", (String)QueryBuilder.quote((String)"epochs")).getQueryString(), (String)"INSERT INTO Metrics.\"epochs\"() VALUES ();");
        Assert.assertEquals((String)QueryBuilder.insertInto((String)QueryBuilder.quote((String)"Metrics"), (String)"epochs").getQueryString(), (String)"INSERT INTO \"Metrics\".epochs() VALUES ();");
        Assert.assertEquals((String)QueryBuilder.insertInto((String)QueryBuilder.quote((String)"Metrics"), (String)QueryBuilder.quote((String)"epochs")).getQueryString(), (String)"INSERT INTO \"Metrics\".\"epochs\"() VALUES ();");
    }

    @Test(groups={"unit"})
    public void compoundWhereClauseTest() throws Exception {
        String query = "SELECT * FROM foo WHERE k=4 AND (c1,c2)>('a',2);";
        Select.Where select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.gt(Arrays.asList("c1", "c2"), Arrays.asList("a", 2)));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k=4 AND (c1,c2)>=('a',2) AND (c1,c2)<('b',0);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.gte(Arrays.asList("c1", "c2"), Arrays.asList("a", 2))).and(QueryBuilder.lt(Arrays.asList("c1", "c2"), Arrays.asList("b", 0)));
        Assert.assertEquals((String)select.toString(), (String)query);
        query = "SELECT * FROM foo WHERE k=4 AND (c1,c2)<=('a',2);";
        select = QueryBuilder.select().all().from("foo").where(QueryBuilder.eq((String)"k", (Object)4)).and(QueryBuilder.lte(Arrays.asList("c1", "c2"), Arrays.asList("a", 2)));
        Assert.assertEquals((String)select.toString(), (String)query);
    }
}

