/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.utils;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.utils.UUIDs;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UUIDsTest {
    @Test(groups={"unit"})
    public void conformanceTest() {
        UUIDs.random();
        long now = System.currentTimeMillis();
        UUID uuid = UUIDs.timeBased();
        Assert.assertEquals((int)uuid.version(), (int)1);
        Assert.assertEquals((int)uuid.variant(), (int)2);
        long tstamp = UUIDs.unixTimestamp((UUID)uuid);
        assert (now <= tstamp && now >= tstamp - 10L) : String.format("now = %d, tstamp = %d", now, tstamp);
    }

    @Test(groups={"unit"})
    public void uniquenessTest() {
        int nbGenerated = 1000000;
        HashSet<UUID> generated = new HashSet<UUID>(nbGenerated);
        for (int i = 0; i < nbGenerated; ++i) {
            generated.add(UUIDs.timeBased());
        }
        Assert.assertEquals((int)generated.size(), (int)nbGenerated);
    }

    @Test(groups={"unit"})
    public void multiThreadUniquenessTest() throws Exception {
        int i;
        int nbThread = 10;
        int nbGenerated = 10000;
        ConcurrentSkipListSet<UUID> generated = new ConcurrentSkipListSet<UUID>();
        UUIDGenerator[] generators = new UUIDGenerator[nbThread];
        for (i = 0; i < nbThread; ++i) {
            generators[i] = new UUIDGenerator(nbGenerated, generated);
        }
        for (i = 0; i < nbThread; ++i) {
            generators[i].start();
        }
        for (i = 0; i < nbThread; ++i) {
            generators[i].join();
        }
        Assert.assertEquals((int)generated.size(), (int)(nbThread * nbGenerated));
    }

    @Test(groups={"unit"})
    public void timestampIncreasingTest() {
        int nbGenerated = 1000000;
        long previous = 0L;
        for (int i = 0; i < nbGenerated; ++i) {
            long current = UUIDs.timeBased().timestamp();
            assert (previous < current) : String.format("previous = %d >= %d = current", previous, current);
        }
    }

    @Test(groups={"unit"})
    public void startEndOfTest() {
        Random random = new Random(System.currentTimeMillis());
        int nbTstamp = 10;
        int nbPerTstamp = 10;
        for (int i = 0; i < nbTstamp; ++i) {
            long tstamp = random.nextInt();
            for (int j = 0; j < nbPerTstamp; ++j) {
                UUIDsTest.assertWithin(new UUID(UUIDs.makeMSB((long)UUIDs.fromUnixTimestamp((long)tstamp)), random.nextLong()), UUIDs.startOf((long)tstamp), UUIDs.endOf((long)tstamp));
            }
        }
    }

    private static void assertWithin(UUID uuid, UUID lowerBound, UUID upperBound) {
        ByteBuffer uuidBytes = DataType.uuid().serialize((Object)uuid, 1);
        ByteBuffer lb = DataType.uuid().serialize((Object)lowerBound, 1);
        ByteBuffer ub = DataType.uuid().serialize((Object)upperBound, 1);
        Assert.assertTrue((UUIDsTest.compareTimestampBytes(lb, uuidBytes) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((UUIDsTest.compareTimestampBytes(ub, uuidBytes) >= 0 ? 1 : 0) != 0);
    }

    private static int compareTimestampBytes(ByteBuffer o1, ByteBuffer o2) {
        int o1Pos = o1.position();
        int o2Pos = o2.position();
        int d = (o1.get(o1Pos + 6) & 0xF) - (o2.get(o2Pos + 6) & 0xF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 7) & 0xFF) - (o2.get(o2Pos + 7) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 4) & 0xFF) - (o2.get(o2Pos + 4) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 5) & 0xFF) - (o2.get(o2Pos + 5) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos) & 0xFF) - (o2.get(o2Pos) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 1) & 0xFF) - (o2.get(o2Pos + 1) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 2) & 0xFF) - (o2.get(o2Pos + 2) & 0xFF);
        if (d != 0) {
            return d;
        }
        return (o1.get(o1Pos + 3) & 0xFF) - (o2.get(o2Pos + 3) & 0xFF);
    }

    private static class UUIDGenerator
    extends Thread {
        private final int toGenerate;
        private final Set<UUID> generated;

        UUIDGenerator(int toGenerate, Set<UUID> generated) {
            this.toGenerate = toGenerate;
            this.generated = generated;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.toGenerate; ++i) {
                this.generated.add(UUIDs.timeBased());
            }
        }
    }
}

