/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCAwareRoundRobinPolicy
implements LoadBalancingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DCAwareRoundRobinPolicy.class);
    private final String UNSET = "";
    private final ConcurrentMap<String, CopyOnWriteArrayList<Host>> perDcLiveHosts = new ConcurrentHashMap<String, CopyOnWriteArrayList<Host>>();
    private final AtomicInteger index = new AtomicInteger();
    @VisibleForTesting
    volatile String localDc;
    private final ConcurrentMap<String, CopyOnWriteArrayList<Host>> perDcSuspectedHosts = new ConcurrentHashMap<String, CopyOnWriteArrayList<Host>>();
    private final int usedHostsPerRemoteDc;
    private final boolean dontHopForLocalCL;
    private volatile Configuration configuration;

    public DCAwareRoundRobinPolicy() {
        this(null, 0, false, true);
    }

    public DCAwareRoundRobinPolicy(String localDc) {
        this(localDc, 0, false, false);
    }

    public DCAwareRoundRobinPolicy(String localDc, int usedHostsPerRemoteDc) {
        this(localDc, usedHostsPerRemoteDc, false, false);
    }

    public DCAwareRoundRobinPolicy(String localDc, int usedHostsPerRemoteDc, boolean allowRemoteDCsForLocalConsistencyLevel) {
        this(localDc, usedHostsPerRemoteDc, allowRemoteDCsForLocalConsistencyLevel, false);
    }

    private DCAwareRoundRobinPolicy(String localDc, int usedHostsPerRemoteDc, boolean allowRemoteDCsForLocalConsistencyLevel, boolean allowEmptyLocalDc) {
        if (!allowEmptyLocalDc && Strings.isNullOrEmpty((String)localDc)) {
            throw new IllegalArgumentException("Null or empty data center specified for DC-aware policy");
        }
        this.localDc = localDc == null ? "" : localDc;
        this.usedHostsPerRemoteDc = usedHostsPerRemoteDc;
        this.dontHopForLocalCL = !allowRemoteDCsForLocalConsistencyLevel;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.configuration = cluster.getConfiguration();
        ArrayList<String> notInLocalDC = new ArrayList<String>();
        for (Host host : hosts) {
            String dc = this.dc(host);
            if (this.localDc == "" && dc != "") {
                logger.info("Using data-center name '{}' for DCAwareRoundRobinPolicy (if this is incorrect, please provide the correct datacenter name with DCAwareRoundRobinPolicy constructor)", (Object)dc);
                this.localDc = dc;
            } else if (!dc.equals(this.localDc)) {
                notInLocalDC.add(String.format("%s (%s)", host.toString(), dc));
            }
            CopyOnWriteArrayList prev = (CopyOnWriteArrayList)this.perDcLiveHosts.get(dc);
            if (prev == null) {
                this.perDcLiveHosts.put(dc, new CopyOnWriteArrayList<Host>(Collections.singletonList(host)));
                continue;
            }
            prev.addIfAbsent(host);
        }
        if (notInLocalDC.size() > 0) {
            String nonLocalHosts = Joiner.on((String)",").join(notInLocalDC);
            logger.warn("Some contact points don't match specified local data center. Local DC = {}. Non-conforming contact points: {}", (Object)this.localDc, (Object)nonLocalHosts);
        }
    }

    private String dc(Host host) {
        String dc = host.getDatacenter();
        return dc == null ? this.localDc : dc;
    }

    private static CopyOnWriteArrayList<Host> cloneList(CopyOnWriteArrayList<Host> list) {
        return (CopyOnWriteArrayList)list.clone();
    }

    @Override
    public HostDistance distance(Host host) {
        String dc = this.dc(host);
        if (dc == "" || dc.equals(this.localDc)) {
            return HostDistance.LOCAL;
        }
        CopyOnWriteArrayList<Host> dcHosts = (CopyOnWriteArrayList<Host>)this.perDcLiveHosts.get(dc);
        if (dcHosts == null || this.usedHostsPerRemoteDc == 0) {
            return HostDistance.IGNORED;
        }
        return (dcHosts = DCAwareRoundRobinPolicy.cloneList(dcHosts)).subList(0, Math.min(dcHosts.size(), this.usedHostsPerRemoteDc)).contains(host) ? HostDistance.REMOTE : HostDistance.IGNORED;
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, final Statement statement) {
        CopyOnWriteArrayList localLiveHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(this.localDc);
        final List hosts = localLiveHosts == null ? Collections.emptyList() : DCAwareRoundRobinPolicy.cloneList(localLiveHosts);
        final int startIdx = this.index.getAndIncrement();
        return new AbstractIterator<Host>(){
            private int idx;
            private int remainingLocal;
            private Iterator<Host> localSuspected;
            private Iterator<String> remoteDcs;
            private List<Host> currentDcHosts;
            private int currentDcRemaining;
            private Iterator<Host> currentDcSuspected;
            {
                this.idx = startIdx;
                this.remainingLocal = hosts.size();
            }

            protected Host computeNext() {
                ConsistencyLevel cl;
                if (this.remainingLocal > 0) {
                    int c;
                    --this.remainingLocal;
                    if ((c = this.idx++ % hosts.size()) < 0) {
                        c += hosts.size();
                    }
                    return (Host)hosts.get(c);
                }
                if (this.localSuspected == null) {
                    List l = (List)DCAwareRoundRobinPolicy.this.perDcSuspectedHosts.get(DCAwareRoundRobinPolicy.this.localDc);
                    Iterator<Object> iterator = this.localSuspected = l == null ? Collections.emptySet().iterator() : l.iterator();
                }
                while (this.localSuspected.hasNext()) {
                    Host h = this.localSuspected.next();
                    DCAwareRoundRobinPolicy.this.waitOnReconnection(h);
                    if (!h.isUp()) continue;
                    return h;
                }
                ConsistencyLevel consistencyLevel = cl = statement.getConsistencyLevel() == null ? DCAwareRoundRobinPolicy.this.configuration.getQueryOptions().getConsistencyLevel() : statement.getConsistencyLevel();
                if (DCAwareRoundRobinPolicy.this.dontHopForLocalCL && cl.isDCLocal()) {
                    return (Host)this.endOfData();
                }
                if (this.remoteDcs == null) {
                    HashSet copy = new HashSet(DCAwareRoundRobinPolicy.this.perDcLiveHosts.keySet());
                    copy.remove(DCAwareRoundRobinPolicy.this.localDc);
                    this.remoteDcs = copy.iterator();
                }
                while (true) {
                    List suspectedList;
                    if (this.currentDcHosts != null && this.currentDcRemaining > 0) {
                        int c;
                        --this.currentDcRemaining;
                        if ((c = this.idx++ % this.currentDcHosts.size()) < 0) {
                            c += this.currentDcHosts.size();
                        }
                        return this.currentDcHosts.get(c);
                    }
                    if (this.currentDcSuspected != null) {
                        while (this.currentDcSuspected.hasNext()) {
                            Host h = this.currentDcSuspected.next();
                            DCAwareRoundRobinPolicy.this.waitOnReconnection(h);
                            if (!h.isUp()) continue;
                            return h;
                        }
                    }
                    if (!this.remoteDcs.hasNext()) break;
                    String nextRemoteDc = this.remoteDcs.next();
                    CopyOnWriteArrayList nextDcHosts = (CopyOnWriteArrayList)DCAwareRoundRobinPolicy.this.perDcLiveHosts.get(nextRemoteDc);
                    if (nextDcHosts != null) {
                        CopyOnWriteArrayList dcHosts = DCAwareRoundRobinPolicy.cloneList(nextDcHosts);
                        this.currentDcHosts = dcHosts.subList(0, Math.min(dcHosts.size(), DCAwareRoundRobinPolicy.this.usedHostsPerRemoteDc));
                        this.currentDcRemaining = this.currentDcHosts.size();
                    }
                    this.currentDcSuspected = (suspectedList = (List)DCAwareRoundRobinPolicy.this.perDcSuspectedHosts.get(nextRemoteDc)) == null ? null : suspectedList.iterator();
                }
                return (Host)this.endOfData();
            }
        };
    }

    private void waitOnReconnection(Host h) {
        try {
            h.getInitialReconnectionAttemptFuture().get((long)this.configuration.getSocketOptions().getConnectTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
        catch (TimeoutException e) {
            logger.debug("Timeout while waiting only host initial reconnection future", (Throwable)e);
        }
    }

    @Override
    public void onUp(Host host) {
        CopyOnWriteArrayList<Host> newMap;
        CopyOnWriteArrayList<Host> dcHosts;
        String dc = this.dc(host);
        if (this.localDc == "" && dc != "") {
            logger.info("Using data-center name '{}' for DCAwareRoundRobinPolicy (if this is incorrect, please provide the correct datacenter name with DCAwareRoundRobinPolicy constructor)", (Object)dc);
            this.localDc = dc;
        }
        if ((dcHosts = (CopyOnWriteArrayList<Host>)this.perDcLiveHosts.get(dc)) == null && (dcHosts = this.perDcLiveHosts.putIfAbsent(dc, newMap = new CopyOnWriteArrayList<Host>(Collections.singletonList(host)))) == null) {
            return;
        }
        dcHosts.addIfAbsent(host);
        CopyOnWriteArrayList dcSuspected = (CopyOnWriteArrayList)this.perDcSuspectedHosts.get(this.dc(host));
        if (dcSuspected != null) {
            dcSuspected.remove(host);
        }
    }

    @Override
    public void onSuspected(Host host) {
        CopyOnWriteArrayList<Host> newMap;
        String dc = this.dc(host);
        CopyOnWriteArrayList<Host> dcSuspected = (CopyOnWriteArrayList<Host>)this.perDcSuspectedHosts.get(dc);
        if (dcSuspected == null && (dcSuspected = this.perDcSuspectedHosts.putIfAbsent(dc, newMap = new CopyOnWriteArrayList<Host>(Collections.singletonList(host)))) == null) {
            return;
        }
        dcSuspected.addIfAbsent(host);
    }

    @Override
    public void onDown(Host host) {
        CopyOnWriteArrayList dcSuspected;
        CopyOnWriteArrayList dcHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(this.dc(host));
        if (dcHosts != null) {
            dcHosts.remove(host);
        }
        if ((dcSuspected = (CopyOnWriteArrayList)this.perDcSuspectedHosts.get(this.dc(host))) != null) {
            dcSuspected.remove(host);
        }
    }

    @Override
    public void onAdd(Host host) {
        this.onUp(host);
    }

    @Override
    public void onRemove(Host host) {
        this.onDown(host);
    }
}

