/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.DynamicConnectionPool;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PooledConnection;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.SingleConnectionPool;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

abstract class HostConnectionPool {
    final Host host;
    volatile HostDistance hostDistance;
    protected final SessionManager manager;
    protected final AtomicReference<CloseFuture> closeFuture = new AtomicReference();

    static HostConnectionPool newInstance(Host host, HostDistance hostDistance, SessionManager manager, ProtocolVersion version) throws ConnectionException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
        switch (version) {
            case V1: 
            case V2: {
                return new DynamicConnectionPool(host, hostDistance, manager);
            }
            case V3: {
                return new SingleConnectionPool(host, hostDistance, manager);
            }
        }
        throw version.unsupported();
    }

    protected HostConnectionPool(Host host, HostDistance hostDistance, SessionManager manager) {
        assert (hostDistance != HostDistance.IGNORED);
        this.host = host;
        this.hostDistance = hostDistance;
        this.manager = manager;
    }

    abstract PooledConnection borrowConnection(long var1, TimeUnit var3) throws ConnectionException, TimeoutException;

    abstract void returnConnection(PooledConnection var1);

    abstract void ensureCoreConnections();

    abstract void replaceDefunctConnection(PooledConnection var1);

    abstract void trashIdleConnections(long var1);

    abstract int opened();

    abstract int inFlightQueriesCount();

    protected abstract CloseFuture makeCloseFuture();

    public final boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    public final CloseFuture closeAsync() {
        CloseFuture future = this.closeFuture.get();
        if (future != null) {
            return future;
        }
        future = this.makeCloseFuture();
        return this.closeFuture.compareAndSet(null, future) ? future : this.closeFuture.get();
    }

    static class PoolState {
        volatile String keyspace;

        PoolState() {
        }

        public void setKeyspace(String keyspace) {
            this.keyspace = keyspace;
        }
    }
}

