/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.shaded.netty.buffer.ChannelBuffer;
import java.net.InetSocketAddress;

class ProtocolEvent {
    public final Type type;

    private ProtocolEvent(Type type) {
        this.type = type;
    }

    public static ProtocolEvent deserialize(ChannelBuffer cb, ProtocolVersion version) {
        switch (CBUtil.readEnumValue(Type.class, cb)) {
            case TOPOLOGY_CHANGE: {
                return TopologyChange.deserializeEvent(cb);
            }
            case STATUS_CHANGE: {
                return StatusChange.deserializeEvent(cb);
            }
            case SCHEMA_CHANGE: {
                return SchemaChange.deserializeEvent(cb, version);
            }
        }
        throw new AssertionError();
    }

    public static class SchemaChange
    extends ProtocolEvent {
        public final Change change;
        public final Target target;
        public final String keyspace;
        public final String name;

        public SchemaChange(Change change, Target target, String keyspace, String name) {
            super(Type.SCHEMA_CHANGE);
            this.change = change;
            this.target = target;
            this.keyspace = keyspace;
            this.name = name;
        }

        private static SchemaChange deserializeEvent(ChannelBuffer cb, ProtocolVersion version) {
            switch (version) {
                case V1: 
                case V2: {
                    Change change = CBUtil.readEnumValue(Change.class, cb);
                    String keyspace = CBUtil.readString(cb);
                    String name = CBUtil.readString(cb);
                    Target target = name.isEmpty() ? Target.KEYSPACE : Target.TABLE;
                    return new SchemaChange(change, target, keyspace, name);
                }
                case V3: {
                    Change change = CBUtil.readEnumValue(Change.class, cb);
                    Target target = CBUtil.readEnumValue(Target.class, cb);
                    String keyspace = CBUtil.readString(cb);
                    String name = target == Target.KEYSPACE ? "" : CBUtil.readString(cb);
                    return new SchemaChange(change, target, keyspace, name);
                }
            }
            throw version.unsupported();
        }

        public String toString() {
            return this.change.toString() + ' ' + (Object)((Object)this.target) + ' ' + this.keyspace + (this.name.isEmpty() ? "" : '.' + this.name);
        }

        public static enum Target {
            KEYSPACE,
            TABLE,
            TYPE;

        }

        public static enum Change {
            CREATED,
            UPDATED,
            DROPPED;

        }
    }

    public static class StatusChange
    extends ProtocolEvent {
        public final Status status;
        public final InetSocketAddress node;

        private StatusChange(Status status, InetSocketAddress node) {
            super(Type.STATUS_CHANGE);
            this.status = status;
            this.node = node;
        }

        private static StatusChange deserializeEvent(ChannelBuffer cb) {
            Status status = CBUtil.readEnumValue(Status.class, cb);
            InetSocketAddress node = CBUtil.readInet(cb);
            return new StatusChange(status, node);
        }

        public String toString() {
            return (Object)((Object)this.status) + " " + this.node;
        }

        public static enum Status {
            UP,
            DOWN;

        }
    }

    public static class TopologyChange
    extends ProtocolEvent {
        public final Change change;
        public final InetSocketAddress node;

        private TopologyChange(Change change, InetSocketAddress node) {
            super(Type.TOPOLOGY_CHANGE);
            this.change = change;
            this.node = node;
        }

        private static TopologyChange deserializeEvent(ChannelBuffer cb) {
            Change change = CBUtil.readEnumValue(Change.class, cb);
            InetSocketAddress node = CBUtil.readInet(cb);
            return new TopologyChange(change, node);
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + this.node;
        }

        public static enum Change {
            NEW_NODE,
            REMOVED_NODE,
            MOVED_NODE;

        }
    }

    public static enum Type {
        TOPOLOGY_CHANGE,
        STATUS_CHANGE,
        SCHEMA_CHANGE;

    }
}

